/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.client.render;

import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.client.LucraftCoreKeyBindings;
import lucraft.mods.lucraftcore.client.gui.buttons.GuiButton10x;
import lucraft.mods.lucraftcore.client.gui.buttons.GuiButtonTranslucent;
import lucraft.mods.lucraftcore.config.LCConfig;
import lucraft.mods.lucraftcore.events.RenderModelEvent;
import lucraft.mods.lucraftcore.network.MessageSendInfoToServer;
import lucraft.mods.lucraftcore.network.PacketDispatcher;
import lucraft.mods.lucraftcore.potions.PotionKnockOut;
import lucraft.mods.lucraftcore.suitset.ItemSuitSetArmor;
import lucraft.mods.lucraftcore.suitset.SuitSet;
import lucraft.mods.lucraftcore.superpower.ISuperpowerCapability;
import lucraft.mods.lucraftcore.util.IShiftableItemToolTip;
import lucraft.mods.lucraftcore.util.LucraftCoreClientUtil;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;

public class LCRenderer {
    public static final int EXTENDEDINVENTORY_BUTTON_ID = 42;
    public static final int ABILITYBAR_BUTTON_ID = 43;
    public static int knockOutSymbolTimer;
    private static final ResourceLocation knockOutOnTexture;
    private static final ResourceLocation knockOutOffTexture;

    @SubscribeEvent
    public void tooltip(ItemTooltipEvent e) {
        if (e.getItemStack().func_77973_b() instanceof IShiftableItemToolTip) {
            IShiftableItemToolTip item = (IShiftableItemToolTip)e.getItemStack().func_77973_b();
            ItemStack stack = e.getItemStack();
            EntityPlayer player = e.getEntityPlayer();
            boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            boolean ctrl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
            List<String> toolTip = item.getShiftableToolTip(stack, player);
            if (shift && item.shouldRenderShiftableToolTip(stack, player)) {
                e.getToolTip().addAll(toolTip);
            } else if (ctrl && item.shouldRenderArmorAbilitiesToolTip(stack, player) && e.getItemStack().func_77973_b() instanceof ItemSuitSetArmor) {
                SuitSet suitSet = ((ItemSuitSetArmor)e.getItemStack().func_77973_b()).getSuitSet();
                List<Ability> abilities = suitSet.getDefaultAbilities(player, new ArrayList<Ability>());
                if (abilities.size() > 0) {
                    e.getToolTip().add(TextFormatting.RED + LucraftCoreUtil.translateToLocal("lucraftcore.info.abilities") + TextFormatting.DARK_RED + ":");
                    for (Ability ability : abilities) {
                        LucraftKeys key = LCRenderer.getKeyFromArmorAbility(player, abilities, suitSet, ability);
                        e.getToolTip().add(TextFormatting.RED + "- " + TextFormatting.GRAY + ability.getDisplayName() + (key == null ? "" : TextFormatting.DARK_RED + " (" + TextFormatting.RED + GameSettings.func_74298_c((int)LucraftCoreKeyBindings.getKeyBindingFromKeyType(key).func_151463_i()) + TextFormatting.DARK_RED + ")"));
                    }
                }
            } else {
                if (item.shouldRenderShiftableToolTip(stack, player)) {
                    e.getToolTip().add(TextFormatting.GRAY + LucraftCoreUtil.translateToLocal("lucraftcore.info.shifttooltip").replace("%KEY", TextFormatting.YELLOW + "SHIFT" + TextFormatting.GRAY));
                }
                if (item.shouldRenderArmorAbilitiesToolTip(stack, player) && e.getItemStack().func_77973_b() instanceof ItemSuitSetArmor && ((ItemSuitSetArmor)e.getItemStack().func_77973_b()).getSuitSet().getDefaultAbilities(player, new ArrayList<Ability>()).size() > 0) {
                    e.getToolTip().add(TextFormatting.GRAY + LucraftCoreUtil.translateToLocal("lucraftcore.info.controltooltip").replace("%KEY", TextFormatting.GOLD + "CONTROL" + TextFormatting.GRAY));
                }
            }
        }
    }

    public static LucraftKeys getKeyFromArmorAbility(EntityPlayer player, List<Ability> abilities, SuitSet suitSet, Ability ability) {
        for (LucraftKeys keys : LucraftKeys.values()) {
            if (keys.type != LucraftKeys.LucraftKeyTypes.ARMOR_ACTION || ability != suitSet.getSuitAbilityForKey(keys, abilities)) continue;
            return keys;
        }
        return null;
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent e) {
        LucraftCoreClientUtil.renderTick = e.renderTickTime;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post e) {
        if (e.getGui() instanceof GuiInventory) {
            int k = (e.getGui().field_146294_l - 176) / 2;
            int l = (e.getGui().field_146295_m - 166) / 2;
            e.getButtonList().add(new GuiButton10x(42, k + 159, l + 70, "+"));
        } else if (e.getGui() instanceof GuiContainerCreative) {
            int k = (e.getGui().field_146294_l - 195) / 2;
            int l = (e.getGui().field_146295_m - 136) / 2;
            e.getButtonList().add(new GuiButton10x(42, k + 151, l + 142, "+"));
        } else if (e.getGui() instanceof GuiChat) {
            GuiScreen gui = e.getGui();
            String displayString = LucraftCoreUtil.translateToLocal("lucraftcore.info.abilitybar") + ": " + (LCConfig.renderAbilityBar ? LucraftCoreUtil.translateToLocal("options.on") : LucraftCoreUtil.translateToLocal("options.off"));
            int width = MathHelper.func_76125_a((int)(Minecraft.func_71410_x().field_71466_p.func_78256_a(displayString) + 10), (int)100, (int)200);
            for (GuiButton buttons : e.getButtonList()) {
                if (buttons.field_146128_h != gui.field_146294_l - 100) continue;
                buttons.field_146129_i -= 21;
            }
            e.getButtonList().add(new GuiButtonTranslucent(43, gui.field_146294_l - width, gui.field_146295_m - 40, width, 20, displayString));
        }
    }

    @SubscribeEvent
    public void onButtonPressPre(GuiScreenEvent.ActionPerformedEvent.Pre e) {
        if ((e.getGui() instanceof GuiInventory || e.getGui() instanceof GuiContainerCreative) && e.getButton().field_146127_k == 42) {
            PacketDispatcher.sendToServer(new MessageSendInfoToServer(MessageSendInfoToServer.InfoType.EXTENDED_INVENTORY));
        } else if (e.getGui() instanceof GuiChat && e.getButton().field_146127_k == 43) {
            LCConfig.renderAbilityBar = !LCConfig.renderAbilityBar;
            e.getButton().field_146126_j = LucraftCoreUtil.translateToLocal("lucraftcore.info.abilitybar") + ": " + (LCConfig.renderAbilityBar ? LucraftCoreUtil.translateToLocal("options.on") : LucraftCoreUtil.translateToLocal("options.off"));
        }
    }

    @SubscribeEvent
    public void setupModel(RenderModelEvent e) {
        if (e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.potion)) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-e.getEntityLiving().field_70130_N / 3.0f), (float)(-e.getEntityLiving().field_70131_O / 2.0f));
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void renderView(EntityViewRenderEvent.CameraSetup e) {
        if (e.getEntity() == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71439_g.func_70644_a((Potion)PotionKnockOut.potion)) {
            GlStateManager.func_179109_b((float)0.0f, (float)(Minecraft.func_71410_x().field_71439_g.func_70047_e() * 0.8f), (float)0.0f);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && knockOutSymbolTimer > 0) {
            --knockOutSymbolTimer;
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || knockOutSymbolTimer == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = event.getResolution();
        int x = res.func_78326_a() / 2 - 16;
        int y = res.func_78328_b() - 100;
        boolean knockOut = ((ISuperpowerCapability)mc.field_71439_g.getCapability(LucraftCore.SUPERPOWER_CAP, null)).isKnockOutModeEnabled();
        float alpha = ((float)knockOutSymbolTimer + event.getPartialTicks()) / 10.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        mc.field_71446_o.func_110577_a(knockOut ? knockOutOffTexture : knockOutOnTexture);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        GlStateManager.func_179121_F();
    }

    static {
        knockOutOnTexture = new ResourceLocation("lucraftcore", "textures/gui/knockout_off.png");
        knockOutOffTexture = new ResourceLocation("lucraftcore", "textures/gui/knockout_on.png");
    }
}

