/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityMountableBlock
extends Entity
implements IEntityAdditionalSpawnData {
    public int blockPosX;
    public int blockPosY;
    public int blockPosZ;
    public boolean shouldRenderSit;
    public String info;

    public EntityMountableBlock(World world) {
        super(world);
        this.field_70145_X = true;
        this.field_70131_O = 0.01f;
        this.field_70130_N = 0.01f;
        this.info = "";
        this.shouldRenderSit = true;
    }

    public EntityMountableBlock(World world, double x, double y, double z, double y0ffset, boolean shouldRiderSit, String info) {
        this(world);
        this.blockPosX = (int)x;
        this.blockPosY = (int)y;
        this.blockPosZ = (int)z;
        this.shouldRenderSit = shouldRiderSit;
        this.info = info;
        this.func_70107_b(x + 0.5, y + y0ffset, z + 0.5);
    }

    public EntityMountableBlock(World world, double x, double y, double z, double y0ffset, int rotation, double rotationOffset, boolean shouldRiderSit) {
        this(world);
        this.blockPosX = (int)x;
        this.blockPosY = (int)y;
        this.blockPosZ = (int)z;
        this.shouldRenderSit = shouldRiderSit;
        this.setPostionWithRotation(x + 0.5, y + y0ffset, z + 0.5, rotation, rotationOffset);
    }

    public void setPostionWithRotation(double x, double y, double z, int rotation, double rotationOffset) {
        switch (rotation) {
            case 2: {
                z += rotationOffset;
                break;
            }
            case 0: {
                z -= rotationOffset;
                break;
            }
            case 3: {
                x -= rotationOffset;
                break;
            }
            case 1: {
                x += rotationOffset;
            }
        }
        this.func_70107_b(x, y, z);
    }

    public boolean shouldRiderSit() {
        return this.shouldRenderSit;
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && this.func_184188_bt().size() == 0) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeBoolean(this.shouldRenderSit);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.info);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.shouldRenderSit = additionalData.readBoolean();
        this.info = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
    }
}

