/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.integration.jei.suitmaker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import lucraft.mods.lucraftcore.client.gui.GuiSuitMaker;
import lucraft.mods.lucraftcore.integration.jei.LucraftCoreJEIPlugin;
import lucraft.mods.lucraftcore.recipes.ISuitMakerRecipe;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class SuitMakerRecipeWrapper
extends BlankRecipeWrapper {
    @Nonnull
    private final ISuitMakerRecipe recipe;
    private ArrayList<List<ItemStack>> inputs;
    private IDrawable slotTex;

    public SuitMakerRecipeWrapper(ISuitMakerRecipe recipe) {
        this.recipe = recipe;
        this.inputs = new ArrayList();
        this.inputs.add(recipe.getFirstInput());
        this.inputs.add(recipe.getSecondInput());
        this.inputs.add(recipe.getThirdInput());
        this.slotTex = LucraftCoreJEIPlugin.guiHelper.createDrawable(GuiSuitMaker.TEX, 176, 16 * recipe.getRecipeType().ordinal(), 16, 16);
    }

    public ISuitMakerRecipe.SuitMakerRecipeType getType() {
        return this.recipe.getRecipeType();
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public List<ItemStack> getOutputs() {
        return Arrays.asList(this.recipe.getOutput());
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        this.slotTex.draw(minecraft, 58, 3);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.getInputs());
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getOutput());
    }
}

