/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.proxies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lucraft.mods.lucraftcore.access.LucraftForgeLoading;
import lucraft.mods.lucraftcore.client.LCClientEvents;
import lucraft.mods.lucraftcore.client.LucraftCoreKeyBindings;
import lucraft.mods.lucraftcore.client.UpdateChecker;
import lucraft.mods.lucraftcore.client.gui.book.heroguide.BookHeroGuide;
import lucraft.mods.lucraftcore.client.render.LCRenderer;
import lucraft.mods.lucraftcore.client.render.LayerRendererLucraftCore;
import lucraft.mods.lucraftcore.client.render.NonOptiFineEntityRenderer;
import lucraft.mods.lucraftcore.client.render.RenderFirstPersonArmor;
import lucraft.mods.lucraftcore.client.render.TileEntityRendererArmorStand;
import lucraft.mods.lucraftcore.client.render.TileEntityRendererDNAExtractor;
import lucraft.mods.lucraftcore.client.render.TileEntityRendererSuitMaker;
import lucraft.mods.lucraftcore.client.render.abilitybar.AbilityBarHandlerArmorAbilities;
import lucraft.mods.lucraftcore.client.render.abilitybar.AbilityBarHandlerSuperpowerAbilities;
import lucraft.mods.lucraftcore.client.render.abilitybar.AbilityBarMainHandler;
import lucraft.mods.lucraftcore.proxies.LucraftCoreProxy;
import lucraft.mods.lucraftcore.tileentities.TileEntityArmorStand;
import lucraft.mods.lucraftcore.tileentities.TileEntityDNAExtractor;
import lucraft.mods.lucraftcore.tileentities.TileEntitySuitMaker;
import lucraft.mods.lucraftcore.util.LCModelEntry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.stats.Achievement;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class LucraftCoreClientProxy
extends LucraftCoreProxy {
    public static HashMap<Item, ArrayList<LCModelEntry>> models = new HashMap();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        UpdateChecker.init();
        LucraftCoreKeyBindings.init();
        BookHeroGuide.preInitHeroGuide();
        AbilityBarMainHandler.registerAbilityBarHandler(new AbilityBarHandlerSuperpowerAbilities());
        AbilityBarMainHandler.registerAbilityBarHandler(new AbilityBarHandlerArmorAbilities());
        MinecraftForge.EVENT_BUS.register((Object)new LCClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)new LCRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new AbilityBarMainHandler());
        if (LucraftForgeLoading.isOptiFineInstalled) {
            MinecraftForge.EVENT_BUS.register((Object)new NonOptiFineEntityRenderer());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySuitMaker.class, (TileEntitySpecialRenderer)new TileEntityRendererSuitMaker());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityArmorStand.class, (TileEntitySpecialRenderer)new TileEntityRendererArmorStand());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDNAExtractor.class, (TileEntitySpecialRenderer)new TileEntityRendererDNAExtractor());
        this.initModels();
        if (Loader.isModLoaded((String)"RenderPlayerAPI")) {
            RenderFirstPersonArmor.register();
        }
        BookHeroGuide.initHeroGuide();
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        RenderPlayer render = (RenderPlayer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new LayerRendererLucraftCore((RenderLivingBase<?>)render));
        render = (RenderPlayer)skinMap.get("slim");
        render.func_177094_a((LayerRenderer)new LayerRendererLucraftCore((RenderLivingBase<?>)render));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        BookHeroGuide.postInitHeroGuide();
    }

    public void initModels() {
        for (Item item : models.keySet()) {
            ArrayList<LCModelEntry> list = models.get(item);
            for (LCModelEntry entry : list) {
                ModelResourceLocation loc = new ModelResourceLocation(entry.modid.toLowerCase() + ":" + entry.tex, "inventory");
                Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, entry.meta, loc);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{loc});
            }
        }
        models.clear();
    }

    @Override
    public void registerModel(Item item, LCModelEntry entry) {
        ArrayList<Object> list = models.get(item) == null ? new ArrayList() : models.get(item);
        list.add(entry);
        models.put(item, list);
    }

    @Override
    public void registerModel(Block block, LCModelEntry entry) {
        this.registerModel(Item.func_150898_a((Block)block), entry);
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x() : super.getThreadFromContext(ctx);
    }

    @Override
    public boolean hasAchievement(EntityPlayer player, Achievement achievement) {
        if (player instanceof EntityPlayerSP) {
            return ((EntityPlayerSP)player).func_146107_m().func_77443_a(achievement);
        }
        return super.hasAchievement(player, achievement);
    }
}

