/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.sizechange;

import lucraft.mods.lucraftcore.attributes.LCAttributes;
import lucraft.mods.lucraftcore.sizechange.ISizeChangeCapability;
import lucraft.mods.lucraftcore.sizechange.SizeChangeManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class SCDefaultImplementation
implements ISizeChangeCapability {
    public float defaultWidth;
    public float defaultHeight;
    public float prevSize;
    public float size;
    public float baseSize;
    public float estimatedSize;
    public float sizeChangePerTick = 0.05f;
    public float prevStepHeight;

    @Override
    public void tick(Entity entity) {
        if (this.size == 0.0f) {
            this.size = 1.0f;
        }
        if (this.baseSize == 0.0f) {
            this.baseSize = 1.0f;
        }
        if (this.estimatedSize == 0.0f) {
            this.estimatedSize = 1.0f;
        }
        if (this.defaultWidth == 0.0f) {
            this.defaultWidth = entity.field_70130_N;
        }
        if (this.defaultHeight == 0.0f) {
            this.defaultHeight = entity.field_70131_O;
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase entityliving = (EntityLivingBase)entity;
            this.estimatedSize = this.baseSize;
            for (AttributeModifier modifiers : entityliving.func_110140_aT().func_111151_a(LCAttributes.SIZE).func_111122_c()) {
                this.estimatedSize = (float)((double)this.estimatedSize * modifiers.func_111164_d());
            }
        }
        this.prevSize = this.size;
        if (this.size != this.estimatedSize) {
            float f = this.size = this.estimatedSize > this.size ? this.size + this.sizeChangePerTick : this.size - this.sizeChangePerTick;
            if (Math.abs(this.estimatedSize - this.size) < this.sizeChangePerTick) {
                this.size = this.estimatedSize;
            }
        }
        if (this.size != 1.0f && !(entity instanceof EntityPlayer)) {
            this.setBoundingBox(entity, this.size);
        }
        if (entity.field_70173_aa == 0 && entity.field_70170_p != null) {
            SizeChangeManager.sendUpdatePacket(entity);
        }
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("defaultWidth", this.defaultWidth);
        nbt.func_74776_a("defaultHeight", this.defaultHeight);
        nbt.func_74776_a("size", this.size);
        nbt.func_74776_a("baseSize", this.baseSize);
        nbt.func_74776_a("estimatedSize", this.estimatedSize);
        return nbt;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.defaultWidth = nbt.func_74760_g("defaultWidth");
        this.defaultHeight = nbt.func_74760_g("defaultHeight");
        this.size = nbt.func_74760_g("size");
        this.baseSize = nbt.func_74760_g("baseSize");
        this.estimatedSize = nbt.func_74760_g("estimatedSize");
    }

    public void setBoundingBox(Entity entity, float size) {
        this.size = size;
        Vec3d pos = entity.func_174791_d();
        float width = this.defaultWidth * size / 2.0f;
        float height = this.defaultHeight * size;
        entity.field_70130_N = width * 2.0f;
        entity.field_70131_O = height;
        entity.func_174826_a(new AxisAlignedBB(pos.field_72450_a - (double)width, pos.field_72448_b, pos.field_72449_c - (double)width, pos.field_72450_a + (double)width, pos.field_72448_b + (double)height, pos.field_72449_c + (double)width));
    }

    @Override
    public float getSize() {
        if (this.size == 0.0f) {
            return 1.0f;
        }
        return this.size;
    }

    @Override
    public float getRenderSize(float partialTick) {
        if (this.size == 0.0f) {
            return 1.0f;
        }
        return this.prevSize + (this.size - this.prevSize) * partialTick;
    }

    @Override
    public float getBaseSize() {
        return this.baseSize;
    }

    @Override
    public void setBaseSize(float baseSize) {
        this.baseSize = baseSize;
    }
}

