/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.sizechange;

import java.lang.reflect.Field;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.access.Hooks;
import lucraft.mods.lucraftcore.sizechange.ISizeChangeCapability;
import lucraft.mods.lucraftcore.sizechange.SizeChangeManager;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SizeChangeEventHandler {
    private static final EntityPlayer.SleepResult TOO_SMALL = EnumHelper.addStatus((String)"TOO_SMALL");
    private static final EntityPlayer.SleepResult TOO_BIG = EnumHelper.addStatus((String)"TOO_BIG");

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new SizeChangeEventHandler());
        SizeChangeEventHandler.fixBedAABB();
    }

    @SubscribeEvent
    public void onAttachCapabilitiesEvent(AttachCapabilitiesEvent.Entity evt) {
        evt.addCapability(new ResourceLocation("lucraftcore", "ISizeChangeCapability"), (ICapabilityProvider)new ICapabilitySerializable<NBTBase>(){
            ISizeChangeCapability inst = (ISizeChangeCapability)LucraftCore.SIZECHANGE_CAP.getDefaultInstance();

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == this.inst;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(capability == LucraftCore.SIZECHANGE_CAP ? LucraftCore.SIZECHANGE_CAP.cast((Object)this.inst) : null);
            }

            public NBTBase serializeNBT() {
                return LucraftCore.SIZECHANGE_CAP.getStorage().writeNBT(LucraftCore.SIZECHANGE_CAP, (Object)this.inst, null);
            }

            public void deserializeNBT(NBTBase nbt) {
                LucraftCore.SIZECHANGE_CAP.getStorage().readNBT(LucraftCore.SIZECHANGE_CAP, (Object)this.inst, null, nbt);
            }
        });
    }

    private static void fixBedAABB() {
        try {
            Field f = ReflectionHelper.findField(BlockBed.class, (String[])new String[]{"field_185513_c", "BED_AABB"});
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.1875, 0.0, 1.0, 0.5625, 1.0);
            EnumHelper.setFailsafeFieldValue((Field)f, null, (Object)aabb);
        }
        catch (Exception e) {
            LucraftCoreUtil.logger.info("Failed to modify bed AABB!");
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        float size = Hooks.getSize((Entity)player);
        if (size < 1.0f) {
            e.setResult(TOO_SMALL);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("lucraftcore.bed.too_small", new Object[0]));
        } else if (size > 1.0f) {
            e.setResult(TOO_BIG);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("lucraftcore.bed.too_big", new Object[0]));
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking e) {
        if (e.getEntityPlayer() instanceof EntityPlayerMP && e.getTarget().hasCapability(LucraftCore.SIZECHANGE_CAP, null) && (double)((ISizeChangeCapability)e.getTarget().getCapability(LucraftCore.SIZECHANGE_CAP, null)).getSize() != 1.0) {
            SizeChangeManager.sendUpdatePacket(e.getTarget(), (EntityPlayerMP)e.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent e) {
        float size = SizeChangeManager.getSize(e.getEntity());
        if (size != 1.0f) {
            for (EntityItem item : e.getDrops()) {
                SizeChangeManager.setBaseSize((Entity)item, size);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDrop(ItemTossEvent e) {
        float size = SizeChangeManager.getSize((Entity)e.getPlayer());
        if (size != 1.0f) {
            SizeChangeManager.setBaseSize((Entity)e.getEntityItem(), size);
        }
    }
}

