/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.suitset;

import java.util.List;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.client.model.ModelAdvancedBiped;
import lucraft.mods.lucraftcore.config.LCConfig;
import lucraft.mods.lucraftcore.suitset.ItemSuitSetArmor;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SuitSet {
    private String name;
    private boolean canOpenHelmet;

    public SuitSet(String name) {
        this.name = name;
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public boolean canOpenHelmet() {
        return this.canOpenHelmet;
    }

    public void onOpenHelmet(Entity entity, ItemStack stack, boolean open) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketCustomSound(SoundEvents.field_187725_r.getRegistryName().toString(), entity.func_184176_by(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0f, 1.0f));
        }
    }

    public String getDisplayName() {
        return LucraftCoreUtil.translateToLocal(this.getModId().toLowerCase() + ".suit." + this.name + ".name");
    }

    public abstract String getModId();

    public String getDisplayNameForItem(Item item, ItemStack stack, EntityEquipmentSlot armorType) {
        NBTTagCompound nbttagcompound;
        String s = item.func_77653_i(stack);
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("display", 10) && (nbttagcompound = stack.func_77978_p().func_74775_l("display")).func_150297_b("Name", 8)) {
            s = nbttagcompound.func_74779_i("Name");
        }
        return s;
    }

    public String getArmorTexturePath(ItemStack stack, Entity entity, EntityEquipmentSlot slot, boolean light, boolean smallArms, boolean helmetOpen) {
        String tex;
        String string = slot == EntityEquipmentSlot.HEAD ? "helmet" : (slot == EntityEquipmentSlot.CHEST ? "chestplate" : (tex = slot == EntityEquipmentSlot.LEGS ? "legs" : "boots"));
        if (slot == EntityEquipmentSlot.HEAD) {
            tex = tex + (helmetOpen ? "_open" : "");
        } else if (slot == EntityEquipmentSlot.CHEST) {
            tex = tex + (smallArms ? "_smallArms" : "");
        }
        tex = tex + (light ? "_lights" : "");
        return this.getModId() + ":textures/models/armor/" + this.getUnlocalizedName() + "/" + tex + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(ItemStack stack, Entity entity, EntityEquipmentSlot slot, boolean light, boolean smallArms, boolean helmetOpen) {
        return new ModelAdvancedBiped(this.getArmorModelScale(slot), this.getArmorTexturePath(stack, entity, slot, false, smallArms, helmetOpen), this.getArmorTexturePath(stack, entity, slot, true, smallArms, helmetOpen), this, slot, smallArms);
    }

    public abstract ItemArmor.ArmorMaterial getArmorMaterial(EntityEquipmentSlot var1);

    public boolean hasGlowyThings(EntityLivingBase entity, EntityEquipmentSlot slot) {
        return false;
    }

    public boolean showInCreativeTab() {
        return this.getCreativeTab() != null;
    }

    public CreativeTabs getCreativeTab() {
        return CreativeTabs.field_78037_j;
    }

    public boolean hasArmorOn(EntityLivingBase entity) {
        boolean hasArmorOn = true;
        if (this.getHelmet() != null && (entity.func_184582_a(EntityEquipmentSlot.HEAD) == null || entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() != this.getHelmet())) {
            hasArmorOn = false;
        }
        if (this.getLegs() != null && (entity.func_184582_a(EntityEquipmentSlot.LEGS) == null || entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() != this.getLegs())) {
            hasArmorOn = false;
        }
        if (this.getBoots() != null && (entity.func_184582_a(EntityEquipmentSlot.FEET) == null || entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() != this.getBoots())) {
            hasArmorOn = false;
        }
        return hasArmorOn;
    }

    public Item getHelmet() {
        return null;
    }

    public Item getChestplate() {
        return null;
    }

    public Item getLegs() {
        return null;
    }

    public Item getBoots() {
        return null;
    }

    public float getArmorModelScale(EntityEquipmentSlot armorSlot) {
        if (armorSlot == EntityEquipmentSlot.HEAD) {
            return 0.5f;
        }
        return 0.25f;
    }

    public boolean hasExtraDescription(ItemStack stack, EntityPlayer player) {
        return this.getExtraDescription(stack, player) != null && this.getExtraDescription(stack, player).size() > 0;
    }

    public List<String> getExtraDescription(ItemStack stack, EntityPlayer player) {
        return null;
    }

    protected List<Ability> addDefaultAbilities(EntityPlayer player, List<Ability> list) {
        return list;
    }

    public List<Ability> getDefaultAbilities(EntityPlayer player, List<Ability> list) {
        return LCConfig.removeDisabledAbilities(this.addDefaultAbilities(player, list));
    }

    public Ability getSuitAbilityForKey(LucraftKeys key, List<Ability> list) {
        return null;
    }

    public void onEquip(EntityPlayer player) {
    }

    public void onUnequip(EntityPlayer player) {
    }

    public void onUpdate(EntityPlayer player) {
    }

    public static SuitSet getSuitSet(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return SuitSet.hasSuitSetOn(entity) ? SuitSet.getSuitSet(entity.func_184582_a(EntityEquipmentSlot.CHEST)) : null;
        }
        return null;
    }

    public static SuitSet getSuitSet(ItemStack stack) {
        if (stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemSuitSetArmor) {
            return ((ItemSuitSetArmor)stack.func_77973_b()).getSuitSet();
        }
        return null;
    }

    public static boolean hasSuitSetOn(EntityLivingBase entity) {
        if (entity.func_184582_a(EntityEquipmentSlot.CHEST) != null && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemSuitSetArmor) {
            return ((ItemSuitSetArmor)entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b()).getSuitSet().hasArmorOn(entity);
        }
        return false;
    }
}

