/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpower;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lucraft.mods.lucraftcore.abilities.Ability;
import lucraft.mods.lucraftcore.attributes.LCAttributes;
import lucraft.mods.lucraftcore.suitset.SuitSet;
import lucraft.mods.lucraftcore.superpower.ISuperpowerCapability;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import lucraft.mods.lucraftcore.util.LucraftKeys;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SPDefaultImplementation
implements ISuperpowerCapability {
    private List<Ability> suitAbilities = new ArrayList<Ability>();
    private Superpower prevSuperpower;
    private Superpower superpower;
    private SuperpowerPlayerHandler handler;
    private boolean knockOut;
    private SuitSet prevSuitSet;
    private SuitSet suitSet;
    private EntityPlayer player;
    public float prevStepHeight;
    public int hostileKills;
    public int ambientKills;
    public int minutesSinceLastAmbientKill;
    public int hostileKnockOuts;

    @Override
    public void setCapabilityOwner(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public EntityPlayer getCapabilityOwner() {
        return this.player;
    }

    @Override
    public void setSuperpower(Superpower superpower) {
        if (this.superpower != null && this.handler != null) {
            for (Ability ab : this.handler.getAbilities()) {
                if (!ab.isUnlocked()) continue;
                ab.lastTick();
            }
            this.handler.onRemovePower();
        }
        this.setSuperpowerWithoutUpdate(superpower);
        if (this.handler != null) {
            this.handler.onApplyPower();
        }
        LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
    }

    @Override
    public void setSuperpowerWithoutUpdate(Superpower superpower) {
        if (this.superpower != null && this.handler != null) {
            this.player.getEntityData().func_74775_l("Superpowers").func_74782_a(this.superpower.getUnlocalizedName(), (NBTBase)this.handler.writeToNBT(new NBTTagCompound()));
        }
        this.superpower = superpower;
        if (this.player != null) {
            if (superpower != null) {
                this.handler = superpower.getNewSuperpowerHandler(this.player);
                this.handler.readFromNBT(this.player.getEntityData().func_74775_l("Superpowers").func_74775_l(superpower.getUnlocalizedName()));
            } else {
                this.handler = null;
            }
        }
        LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
    }

    @Override
    public void removeSuperpower() {
        if (this.superpower != null && this.handler != null) {
            for (Ability ab : this.handler.getAbilities()) {
                if (!ab.isUnlocked()) continue;
                ab.lastTick();
            }
            this.handler.onRemovePower();
            this.setSuperpowerWithoutUpdate(null);
        }
        LucraftCoreUtil.sendSuperpowerUpdatePacket(this.player);
    }

    @Override
    public Superpower getSuperpower() {
        return this.superpower;
    }

    @Override
    public boolean hasSuperpower() {
        return this.superpower != null;
    }

    @Override
    public boolean hasSuperpower(Superpower superpower) {
        return this.superpower == superpower;
    }

    @Override
    public SuperpowerPlayerHandler getPlayerHandler() {
        return this.handler;
    }

    @Override
    public void onUpdate(TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.END) {
            this.player.field_70138_W = this.prevStepHeight;
        } else {
            this.prevStepHeight = this.player.field_70138_W;
            for (AttributeModifier mod : this.player.func_110140_aT().func_111151_a(LCAttributes.STEP_HEIGHT).func_111130_a(0)) {
                this.player.field_70138_W = (float)((double)this.player.field_70138_W + mod.func_111164_d());
            }
            for (AttributeModifier mod : this.player.func_110140_aT().func_111151_a(LCAttributes.STEP_HEIGHT).func_111130_a(1)) {
                this.player.field_70138_W = (float)((double)this.player.field_70138_W * mod.func_111164_d());
            }
            for (AttributeModifier mod : this.player.func_110140_aT().func_111151_a(LCAttributes.STEP_HEIGHT).func_111130_a(2)) {
                this.player.field_70138_W = (float)((double)this.player.field_70138_W * mod.func_111164_d());
            }
            if (this.player.field_70173_aa % 1200 == 0) {
                ++this.minutesSinceLastAmbientKill;
            }
        }
        if (this.player != null && this.player.field_70173_aa == 0) {
            this.setSuperpowerWithoutUpdate(this.superpower);
            if (this.handler != null) {
                this.handler.onWorldJoin();
            }
        }
        if (this.handler != null) {
            this.handler.update(phase);
        } else if (this.superpower != null) {
            this.handler = this.superpower.getNewSuperpowerHandler(this.player);
            this.handler.readFromNBT(this.player.getEntityData().func_74775_l("Superpowers").func_74775_l(this.superpower.getUnlocalizedName()));
            LucraftCoreUtil.sendSuperpowerUpdatePacketToAllPlayers(this.player);
        }
        this.prevSuperpower = this.superpower;
        if (phase == TickEvent.Phase.START) {
            this.prevSuitSet = this.suitSet;
            this.suitSet = SuitSet.getSuitSet((EntityLivingBase)this.player);
            if (this.suitSet != null) {
                this.suitSet.onUpdate(this.player);
            }
            if (this.suitSet != this.prevSuitSet) {
                for (Ability ab : this.getSuitAbilities()) {
                    ab.lastTick();
                }
                this.getSuitAbilities().clear();
                if (this.prevSuitSet != null) {
                    this.prevSuitSet.onUnequip(this.player);
                }
                if (this.suitSet != null) {
                    this.suitSet.onEquip(this.player);
                    List<Ability> newAbilities = this.suitSet.getDefaultAbilities(this.player, new ArrayList<Ability>());
                    Collections.sort(newAbilities, new Ability.AbilityComparator());
                    this.setSuitAbilities(newAbilities);
                }
            }
            for (Ability ability : this.getSuitAbilities()) {
                ability.onUpdate();
            }
        }
    }

    @Override
    public List<Ability> getSuitAbilities() {
        return this.suitAbilities;
    }

    public void setSuitAbilities(List<Ability> list) {
        this.suitAbilities = list;
    }

    @Override
    public boolean hasSuitAbility(Ability ability) {
        return this.getSuitAbilities().contains(ability);
    }

    @Override
    public Ability getSuitAbilityForKey(LucraftKeys key) {
        return this.suitSet != null ? this.suitSet.getSuitAbilityForKey(key, this.getSuitAbilities()) : null;
    }

    @Override
    public void loadSuperpowerHandler() {
        if (this.superpower != null) {
            this.handler = this.superpower.getNewSuperpowerHandler(this.player);
            if (this.handler != null && this.player != null && this.player.getEntityData() != null) {
                this.handler.readFromNBT(this.player.getEntityData().func_74775_l("Superpowers").func_74775_l(this.superpower.getUnlocalizedName()));
            }
            if (this.player != null) {
                LucraftCoreUtil.sendSuperpowerUpdatePacketToAllPlayers(this.player);
            }
        }
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        String sp = "";
        if (this.hasSuperpower()) {
            sp = this.getSuperpower().getUnlocalizedName();
        }
        nbt.func_74778_a("superpower", sp);
        if (this.getPlayerHandler() != null) {
            NBTTagCompound superpowersNBT = this.player.getEntityData().func_74775_l("Superpowers");
            superpowersNBT.func_74782_a(this.getSuperpower().getUnlocalizedName(), (NBTBase)this.getPlayerHandler().writeToNBT(new NBTTagCompound()));
            this.player.getEntityData().func_74782_a("Superpowers", (NBTBase)superpowersNBT);
        }
        NBTTagList tagList = new NBTTagList();
        for (Ability ability : this.getSuitAbilities()) {
            tagList.func_74742_a((NBTBase)ability.serializeNBT());
        }
        nbt.func_74782_a("SuitAbilities", (NBTBase)tagList);
        nbt.func_74757_a("KnockOut", this.knockOut);
        nbt.func_74768_a("HostileKills", this.hostileKills);
        nbt.func_74768_a("AmbientKills", this.ambientKills);
        nbt.func_74768_a("MinutesSinceLastAmbientKill", this.minutesSinceLastAmbientKill);
        nbt.func_74768_a("HostileKnockOuts", this.hostileKnockOuts);
        return nbt;
    }

    @Override
    public void readNBT(NBTTagCompound compound) {
        this.setSuperpowerWithoutUpdate(SuperpowerHandler.getSuperpowerFromName(compound.func_74779_i("superpower")));
        if (this.suitSet != null) {
            if (compound.func_150295_c("SuitAbilities", 10).func_74745_c() > 0) {
                List<Ability> list = this.suitSet.getDefaultAbilities(this.player, new ArrayList<Ability>());
                NBTTagList tagList = compound.func_150295_c("SuitAbilities", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound nbt = tagList.func_150305_b(i);
                    Class clz = (Class)Ability.REGISTRY.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("Ability")));
                    for (Ability ab : list) {
                        if (ab.getClass() != clz) continue;
                        ab.deserializeNBT(nbt);
                    }
                }
                Collections.sort(list, new Ability.AbilityComparator());
                this.suitAbilities = list;
            } else {
                List<Ability> list = this.suitSet.getDefaultAbilities(this.player, new ArrayList<Ability>());
                Collections.sort(list, new Ability.AbilityComparator());
                this.suitAbilities = list;
            }
        }
        this.knockOut = compound.func_74767_n("KnockOut");
        this.hostileKills = compound.func_74762_e("HostileKills");
        this.ambientKills = compound.func_74762_e("AmbientKills");
        this.minutesSinceLastAmbientKill = compound.func_74762_e("MinutesSinceLastAmbientKill");
        this.hostileKnockOuts = compound.func_74762_e("HostileKnockOuts");
    }

    @Override
    public boolean isKnockOutModeEnabled() {
        return this.knockOut;
    }

    @Override
    public void setKnockOutModeEnabled(boolean enabled) {
        this.knockOut = enabled;
    }
}

