/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpower;

import java.util.ArrayList;
import java.util.HashMap;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.superpower.ISuperpowerCapability;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerPlayerHandler;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class SuperpowerHandler {
    private static HashMap<String, Superpower> powers = new HashMap();
    private static ArrayList<Superpower> powersList = new ArrayList();

    public static void registerSuperPower(Superpower power) {
        if (!powers.containsKey(power.getUnlocalizedName()) && !powers.containsValue(power)) {
            powers.put(power.getUnlocalizedName(), power);
            powersList.add(power);
        }
    }

    public static Superpower getSuperpowerFromName(String name) {
        return powers.get(name);
    }

    public static ArrayList<Superpower> getSuperpowers() {
        return powersList;
    }

    public static void setSuperpower(EntityPlayer player, Superpower superpower) {
        if (LucraftCoreUtil.isRealPlayer((Entity)player)) {
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            superpowerdata.setSuperpower(superpower);
        }
    }

    public static void removeSuperpower(EntityPlayer player) {
        if (LucraftCoreUtil.isRealPlayer((Entity)player)) {
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            superpowerdata.removeSuperpower();
        }
    }

    public static Superpower getSuperpower(EntityPlayer player) {
        if (LucraftCoreUtil.isRealPlayer((Entity)player)) {
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            return superpowerdata.getSuperpower();
        }
        return null;
    }

    public static boolean hasSuperpower(EntityPlayer player, Superpower superpower) {
        if (LucraftCoreUtil.isRealPlayer((Entity)player)) {
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            return superpowerdata.hasSuperpower(superpower);
        }
        return false;
    }

    public static boolean hasSuperpower(EntityPlayer player) {
        if (LucraftCoreUtil.isRealPlayer((Entity)player)) {
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            return superpowerdata.hasSuperpower();
        }
        return false;
    }

    public static SuperpowerPlayerHandler getSuperpowerPlayerHandler(EntityPlayer player) {
        if (LucraftCoreUtil.isRealPlayer((Entity)player)) {
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            return superpowerdata.getPlayerHandler();
        }
        return null;
    }

    public static <T extends SuperpowerPlayerHandler> T getSpecificSuperpowerPlayerHandler(EntityPlayer player, Class<T> handlerClass) {
        if (player != null && LucraftCoreUtil.isRealPlayer((Entity)player)) {
            ISuperpowerCapability superpowerdata = (ISuperpowerCapability)player.getCapability(LucraftCore.SUPERPOWER_CAP, null);
            SuperpowerPlayerHandler handler = superpowerdata.getPlayerHandler();
            return (T)(handler == null ? null : (handler.getClass() == handlerClass ? handler : null));
        }
        return null;
    }
}

