/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.tileentities;

import java.util.ArrayList;
import lucraft.mods.lucraftcore.recipes.IDNAExtractorRecipe;
import lucraft.mods.lucraftcore.recipes.LucraftCoreRecipes;
import lucraft.mods.lucraftcore.util.TileEntityEnergy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityDNAExtractor
extends TileEntityEnergy
implements IInventory {
    public ItemStack[] items = new ItemStack[10];
    public int progress;
    public int prevProgress;
    public final int maxProgress = 600;
    public final int energyPerTick = 25;

    public TileEntityDNAExtractor() {
        super(100000, 256);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean update = false;
        if (this.func_70301_a(1) != null) {
            ArrayList<ItemStack> currentItems = new ArrayList<ItemStack>();
            for (int i = 2; i < 10; ++i) {
                if (this.func_70301_a(i) == null) continue;
                currentItems.add(this.func_70301_a(i));
            }
            boolean areSame = true;
            for (int i = 0; i < currentItems.size(); ++i) {
                ItemStack stacks = (ItemStack)currentItems.get(i);
                if (i >= currentItems.size() - 1 || ItemStack.func_179545_c((ItemStack)stacks, (ItemStack)((ItemStack)currentItems.get(i + 1)))) continue;
                areSame = false;
            }
            if (areSame && currentItems.size() > 0) {
                ItemStack stack = (ItemStack)currentItems.get(0);
                IDNAExtractorRecipe recipe = LucraftCoreRecipes.getDNAExtractorResultFromItems(this.func_70301_a(1), stack);
                if (recipe != null && recipe.matches(this.func_70301_a(1), stack) && this.extractEnergy(null, 25, true) == 25) {
                    ++this.progress;
                    this.extractEnergy(null, 25, false);
                    if (this.progress >= 600) {
                        this.progress = 0;
                        for (int i = 2; i < 10; ++i) {
                            if (this.func_70301_a(i) == null) continue;
                            this.func_70299_a(i, recipe.getOutput().func_77946_l());
                        }
                        this.func_70298_a(1, 1);
                    }
                    update = true;
                } else if (this.progress > 0) {
                    this.progress = 0;
                    update = true;
                }
            } else if (this.progress > 0) {
                this.progress = 0;
                update = true;
            }
        } else if (this.progress > 0) {
            this.progress = 0;
            update = true;
        }
        this.prevProgress = this.progress;
        if (update) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            this.func_70296_d();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomFromNBT(compound);
    }

    public void readCustomFromNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.items.length) continue;
            this.items[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.progress = compound.func_74762_e("Progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return this.writeCustomToNBT(compound);
    }

    public NBTTagCompound writeCustomToNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        compound.func_74768_a("Progress", this.progress);
        return compound;
    }

    public String func_70005_c_() {
        return "container.dnaExtractor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.items[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.items[index] != null) {
            if (this.items[index].field_77994_a <= count) {
                ItemStack itemstack1 = this.items[index];
                this.items[index] = null;
                return itemstack1;
            }
            ItemStack itemstack = this.items[index].func_77979_a(count);
            if (this.items[index].field_77994_a == 0) {
                this.items[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.items[index] != null) {
            ItemStack itemstack = this.items[index];
            this.items[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.items[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
            case 1: {
                return this.prevProgress;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
            }
            case 1: {
                this.prevProgress = value;
            }
        }
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = null;
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    @Override
    public ItemStack getFuelStack() {
        return this.func_70301_a(0);
    }

    @Override
    public void removeFuel() {
        --this.func_70301_a((int)0).field_77994_a;
        if (this.func_70301_a((int)0).field_77994_a == 0) {
            this.func_70299_a(0, null);
        }
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            if (this.func_145838_q() != Blocks.field_150350_a) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            }
        }
    }
}

