/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.items.LCItems;
import lucraft.mods.lucraftcore.network.MessageShowActionBar;
import lucraft.mods.lucraftcore.network.MessageSpawnParticle;
import lucraft.mods.lucraftcore.network.MessageSwingArm;
import lucraft.mods.lucraftcore.network.MessageSyncPlayerData;
import lucraft.mods.lucraftcore.network.PacketDispatcher;
import lucraft.mods.lucraftcore.recipes.LucraftCoreRecipes;
import lucraft.mods.lucraftcore.suitset.SuitSet;
import lucraft.mods.lucraftcore.util.CustomTeleporter;
import lucraft.mods.lucraftcore.util.EnumMetalTypes;
import lucraft.mods.lucraftcore.util.IArmorUpgrade;
import lucraft.mods.lucraftcore.util.IFakePlayerEntity;
import lucraft.mods.lucraftcore.util.IUpgradableArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Achievement;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class LucraftCoreUtil {
    public static Logger logger = Logger.getLogger("LucraftCore");

    public static void logInfo(String modName, String msg) {
        logger.info(modName + " - " + msg);
    }

    public static ItemStack getLCItems(String type, int amount, EnumMetalTypes metal) {
        Object item = type.equalsIgnoreCase("ingot") ? LCItems.ingot : (type.equalsIgnoreCase("dust") ? LCItems.dust : (type.equalsIgnoreCase("nugget") ? LCItems.nugget : (type.equalsIgnoreCase("plate") ? LCItems.plate : null)));
        return new ItemStack(item, amount, metal.getId());
    }

    public static void addOreDictionaryMetalFurnaceRecipe(EnumMetalTypes type, float xp) {
        LucraftCoreUtil.addOreDictionaryMetalFurnaceRecipe(type.getMetalName(), type.isAlloy(), xp);
    }

    public static void addOreDictionaryMetalFurnaceRecipe(String name, boolean isAlloy, float xp) {
        for (ItemStack dust : OreDictionary.getOres((String)("dust" + name))) {
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
                GameRegistry.addSmelting((ItemStack)dust, (ItemStack)ingot, (float)xp);
            }
        }
        if (!isAlloy) {
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + name))) {
                for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
                    GameRegistry.addSmelting((ItemStack)ore, (ItemStack)ingot, (float)xp);
                }
            }
        }
    }

    public static void registerStorageBlockRecipe(EnumMetalTypes type) {
        LucraftCoreUtil.registerStorageBlockRecipe(type.getMetalName());
    }

    public static void registerStorageBlockRecipe(String name) {
        for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
            ItemStack ingots = ingot.func_77946_l();
            ingots.field_77994_a = 9;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingots, new Object[]{"X", Character.valueOf('X'), "block" + name}));
        }
        for (ItemStack block : OreDictionary.getOres((String)("block" + name))) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(block, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "ingot" + name}));
        }
    }

    public static void registerNuggetRecipe(EnumMetalTypes type) {
        LucraftCoreUtil.registerNuggetRecipe(type.getMetalName());
    }

    public static void registerNuggetRecipe(String name) {
        for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingot, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "nugget" + name}));
        }
        for (ItemStack nugget : OreDictionary.getOres((String)("nugget" + name))) {
            ItemStack nuggets = nugget.func_77946_l();
            nuggets.field_77994_a = 9;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(nuggets, new Object[]{"X", Character.valueOf('X'), "ingot" + name}));
        }
    }

    public static void addOreDictionaryMetalPulverizerRecipe(EnumMetalTypes type, float xp) {
        LucraftCoreUtil.addOreDictionaryMetalPulverizerRecipe(type.getMetalName(), type.isAlloy(), xp);
    }

    public static void addOreDictionaryMetalPulverizerRecipe(String name, boolean isAlloy, float xp) {
        for (ItemStack dust : OreDictionary.getOres((String)("dust" + name))) {
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
                LucraftCoreRecipes.addPulverizerRecipe(ingot, dust, 1.0f);
            }
        }
        if (!isAlloy) {
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + name))) {
                for (ItemStack dust : OreDictionary.getOres((String)("dust" + name))) {
                    ItemStack dusts = dust.func_77946_l();
                    dusts.field_77994_a = 2;
                    LucraftCoreRecipes.addPulverizerRecipe(ore, dusts, 1.0f);
                }
            }
        }
    }

    public static void addMetalPlateRecipe(EnumMetalTypes type) {
        LucraftCoreUtil.addMetalPlateRecipe(type.getMetalName(), type.getResistance());
    }

    public static void addMetalPlateRecipe(String name, float resistance) {
        for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + name))) {
            for (ItemStack plate : OreDictionary.getOres((String)("plate" + name))) {
                if (resistance < 13.0f) {
                    GameRegistry.addShapelessRecipe((ItemStack)plate, (Object[])new Object[]{new ItemStack(LCItems.hammer, 1, Short.MAX_VALUE), ingot, ingot});
                }
                LucraftCoreRecipes.addCompressorRecipe(ingot, plate, 2.0f);
            }
        }
    }

    public static String intToTime(int time) {
        SimpleDateFormat df = new SimpleDateFormat("mm:ss");
        String formatted = df.format(time * 1000);
        return formatted;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static String translateToLocal(String string) {
        return I18n.func_74838_a((String)string);
    }

    public static boolean isRealPlayer(Entity entity) {
        return entity != null && entity instanceof EntityPlayer && !(entity instanceof IFakePlayerEntity);
    }

    public static void sendSuperpowerUpdatePacket(EntityPlayer player, EntityPlayer receiver) {
        if (receiver instanceof EntityPlayerMP && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            PacketDispatcher.sendTo(new MessageSyncPlayerData(player), (EntityPlayerMP)receiver);
        }
    }

    public static void sendSuperpowerUpdatePacket(EntityPlayer player) {
        LucraftCoreUtil.sendSuperpowerUpdatePacket(player, player);
    }

    public static void sendSuperpowerUpdatePacketToAllPlayers(EntityPlayer player) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            PacketDispatcher.sendToAllAround(new MessageSyncPlayerData(player), player, 500.0);
        }
    }

    public static boolean hasAchievement(EntityPlayer player, Achievement achievement) {
        return LucraftCore.proxy.hasAchievement(player, achievement);
    }

    public static void swingPlayerArm(EntityPlayer player, EnumHand hand) {
        PacketDispatcher.sendToAll(new MessageSwingArm(player, hand));
    }

    public static boolean hasArmorThisUpgrade(ItemStack suit, Item upgrade) {
        if (suit != null && suit.func_77973_b() instanceof IUpgradableArmor && suit.func_77942_o()) {
            NBTTagCompound nbt = suit.func_77978_p().func_74775_l("HasItems");
            ResourceLocation resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)upgrade);
            return nbt.func_74767_n(resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        }
        return false;
    }

    public static boolean isArmorUpgrade(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IArmorUpgrade;
    }

    public static boolean hasNoArmorOn(EntityLivingBase entity) {
        return entity.func_184582_a(EntityEquipmentSlot.HEAD) == null && entity.func_184582_a(EntityEquipmentSlot.CHEST) == null && entity.func_184582_a(EntityEquipmentSlot.LEGS) == null && entity.func_184582_a(EntityEquipmentSlot.FEET) == null;
    }

    public static void playSound(World world, EntityPlayer player, double x, double y, double z, SoundEvent sound, SoundCategory category) {
        LucraftCoreUtil.playSound(world, player, x, y, z, sound, category, 1.0f, 1.0f);
    }

    public static void playSound(World world, EntityPlayer player, double x, double y, double z, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketCustomSound(sound.getRegistryName().toString(), category, x, y, z, volume, pitch));
        }
    }

    public static void playSoundToAll(World world, double x, double y, double z, double range, SoundEvent sound, SoundCategory category) {
        LucraftCoreUtil.playSoundToAll(world, x, y, z, range, sound, category, 1.0f, 1.0f);
    }

    public static void playSoundToAll(World world, double x, double y, double z, double range, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        AxisAlignedBB a = new AxisAlignedBB(new BlockPos(x - range, y - range, z - range), new BlockPos(x + range, y + range, z + range));
        for (EntityPlayer players : world.func_72872_a(EntityPlayer.class, a)) {
            if (!(players instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)players).field_71135_a.func_147359_a((Packet)new SPacketCustomSound(sound.getRegistryName().toString(), category, x, y, z, volume, pitch));
        }
    }

    public static void showActionBarMessage(EntityPlayer player, ITextComponent text) {
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new MessageShowActionBar(text), (EntityPlayerMP)player);
        }
    }

    public static void givePlayerItemStack(EntityPlayer player, ItemStack stack) {
        if (player.func_184614_ca() == null) {
            player.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        } else if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, true);
        }
    }

    public static void teleportToDimension(EntityPlayer player, int dimension, double x, double y, double z) {
        int oldDimension = player.field_70170_p.field_73011_w.getDimension();
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
        MinecraftServer server = ((EntityPlayerMP)player).field_70170_p.func_73046_m();
        WorldServer worldServer = server.func_71218_a(dimension);
        player.func_82242_a(0);
        if (player.field_71093_bK != dimension) {
            worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(entityPlayerMP, dimension, (Teleporter)new CustomTeleporter(worldServer, x, y, z));
        }
        player.func_70634_a(x, y, z);
        if (oldDimension == 1) {
            player.func_70634_a(x, y, z);
            worldServer.func_72838_d((Entity)player);
            worldServer.func_72866_a((Entity)player, false);
        }
    }

    public static void spawnParticle(EnumParticleTypes type, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int dimension) {
        PacketDispatcher.sendToAllAround(new MessageSpawnParticle(type, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset), dimension, xCoord, yCoord, zCoord, 100.0);
    }

    public static ItemStack getItemStackInHandSide(EntityPlayer player, EnumHandSide side) {
        if (side == EnumHandSide.RIGHT) {
            return player.func_184591_cq() == EnumHandSide.RIGHT ? player.func_184614_ca() : player.func_184592_cb();
        }
        return player.func_184591_cq() == EnumHandSide.LEFT ? player.func_184614_ca() : player.func_184592_cb();
    }

    public static List<ItemStack> setSuitOfPlayer(EntityPlayer player, SuitSet suit) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (suit.getHelmet() != null) {
            if (player.func_184582_a(EntityEquipmentSlot.HEAD) != null) {
                list.add(player.func_184582_a(EntityEquipmentSlot.HEAD));
            }
            player.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(suit.getHelmet()));
        }
        if (suit.getChestplate() != null) {
            if (player.func_184582_a(EntityEquipmentSlot.CHEST) != null) {
                list.add(player.func_184582_a(EntityEquipmentSlot.CHEST));
            }
            player.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(suit.getChestplate()));
        }
        if (suit.getLegs() != null) {
            if (player.func_184582_a(EntityEquipmentSlot.LEGS) != null) {
                list.add(player.func_184582_a(EntityEquipmentSlot.LEGS));
            }
            player.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(suit.getLegs()));
        }
        if (suit.getBoots() != null) {
            if (player.func_184582_a(EntityEquipmentSlot.FEET) != null) {
                list.add(player.func_184582_a(EntityEquipmentSlot.FEET));
            }
            player.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(suit.getBoots()));
        }
        return list;
    }

    public static RayTraceResult rayTrace(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }
}

