/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.karma;

import lucraft.mods.lucraftcore.karma.KarmaHandler;
import lucraft.mods.lucraftcore.karma.KarmaStat;
import lucraft.mods.lucraftcore.karma.events.EntityKnockOutEvent;
import lucraft.mods.lucraftcore.karma.potions.PotionKnockOut;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.util.events.RenderModelEvent;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import lucraft.mods.lucraftcore.util.network.MessageSyncPotionEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class KarmaEventHandler {
    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent e) {
        if (e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.POTION_KNOCK_OUT)) {
            e.getEntityLiving().field_70159_w = 0.0;
            e.getEntityLiving().field_70181_x = 0.0;
            e.getEntityLiving().field_70179_y = 0.0;
        }
    }

    @SubscribeEvent
    public void onSetAttackTarget(LivingSetAttackTargetEvent e) {
        if (e.getTarget() != null && e.getTarget().func_70644_a((Potion)PotionKnockOut.POTION_KNOCK_OUT)) {
            e.getEntityLiving().func_70604_c(null);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        if (e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.POTION_KNOCK_OUT)) {
            e.getEntityLiving().field_70177_z = e.getEntityLiving().field_70126_B;
            e.getEntityLiving().field_70125_A = e.getEntityLiving().field_70127_C;
            e.getEntityLiving().field_70759_as = 0.0f;
            e.getEntityLiving().field_70143_R = 0.0f;
            if (e.getEntityLiving().func_70660_b((Potion)PotionKnockOut.POTION_KNOCK_OUT).func_76459_b() == 1) {
                MinecraftForge.EVENT_BUS.post((Event)new EntityKnockOutEvent.WakeUp(e.getEntityLiving()));
                e.getEntityLiving().func_184589_d((Potion)PotionKnockOut.POTION_KNOCK_OUT);
                if (e.getEntityLiving() instanceof EntityPlayer) {
                    BlockPos respawn = ((EntityPlayer)e.getEntityLiving()).func_180470_cg() != null ? ((EntityPlayer)e.getEntityLiving()).func_180470_cg() : ((EntityPlayer)e.getEntityLiving()).field_70170_p.func_175694_M();
                    e.getEntityLiving().func_70634_a((double)respawn.func_177958_n(), (double)respawn.func_177956_o(), (double)respawn.func_177952_p());
                } else {
                    e.getEntityLiving().func_70606_j(0.0f);
                }
                LCPacketDispatcher.sendToAll(new MessageSyncPotionEffects(e.getEntityLiving()));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent e) {
        if (e.getSource() != null && e.getSource().func_76346_g() != null && e.getSource().func_76346_g() instanceof EntityPlayer && !e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.POTION_KNOCK_OUT)) {
            EntityPlayer player = (EntityPlayer)e.getSource().func_76346_g();
            boolean save = false;
            for (EntityLivingBase entity : e.getEntity().func_130014_f_().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(e.getEntity().func_180425_c().func_177982_a(-10, -10, -10), e.getEntity().func_180425_c().func_177982_a(10, 10, 10)))) {
                if (entity.field_70128_L || e.getEntityLiving() != entity.func_70643_av()) continue;
                KarmaHandler.increaseKarmaStat(player, KarmaStat.SAVES);
                save = true;
            }
            if (!save) {
                if (KarmaHandler.isMonster(e.getEntityLiving())) {
                    KarmaHandler.increaseKarmaStat(player, KarmaStat.MONSTER_KILL);
                } else if (KarmaHandler.isGoodEntity(e.getEntityLiving())) {
                    KarmaHandler.increaseKarmaStat(player, KarmaStat.GOOD_PLAYER_KILL);
                } else if (e.getEntityLiving() instanceof EntityPlayer && KarmaHandler.isEvilPlayer((EntityPlayer)e.getEntityLiving())) {
                    KarmaHandler.increaseKarmaStat(player, KarmaStat.BAD_PLAYER_KILL);
                }
            }
        }
    }

    @SubscribeEvent
    public void onTaming(AnimalTameEvent e) {
        KarmaHandler.increaseKarmaStat(e.getTamer(), KarmaStat.TAMING);
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent e) {
        if (e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.POTION_KNOCK_OUT) && e.getSource().func_76364_f() != null && !(e.getSource().func_76364_f() instanceof EntityPlayer)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent e) {
        if (e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.POTION_KNOCK_OUT) && e.getSource().func_76364_f() != null && !(e.getSource().func_76364_f() instanceof EntityPlayer)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRightclick(PlayerInteractEvent.EntityInteract e) {
        if (e.getTarget() instanceof EntityVillager && ((EntityVillager)e.getTarget()).func_70644_a((Potion)PotionKnockOut.POTION_KNOCK_OUT)) {
            EntityVillager villager = (EntityVillager)e.getTarget();
            e.setCanceled(true);
            MerchantRecipeList recipeList = villager.func_70934_b(e.getEntityPlayer());
            boolean hasStolen = false;
            if (recipeList != null) {
                for (MerchantRecipe aRecipeList : recipeList) {
                    PlayerHelper.givePlayerItemStack(e.getEntityPlayer(), aRecipeList.func_77397_d().func_77946_l());
                    hasStolen = true;
                }
                recipeList.clear();
                if (hasStolen) {
                    KarmaHandler.increaseKarmaStat(e.getEntityPlayer(), KarmaStat.THEFTS);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void setupModel(RenderModelEvent e) {
        if (e.getEntityLiving().func_70644_a((Potion)PotionKnockOut.POTION_KNOCK_OUT)) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-e.getEntityLiving().field_70130_N / 3.0f), (float)(-e.getEntityLiving().field_70131_O / 2.0f));
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderView(EntityViewRenderEvent.CameraSetup e) {
        if (e.getEntity() == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71439_g.func_70644_a((Potion)PotionKnockOut.POTION_KNOCK_OUT) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            GlStateManager.func_179109_b((float)0.0f, (float)(Minecraft.func_71410_x().field_71439_g.func_70047_e() * 0.8f), (float)0.0f);
        }
    }
}

