/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.karma;

import lucraft.mods.lucraftcore.karma.KarmaStat;
import lucraft.mods.lucraftcore.karma.capabilities.CapabilityKarma;
import lucraft.mods.lucraftcore.karma.capabilities.IKarmaCapability;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;

public class KarmaHandler {
    public static int getKarma(EntityPlayer player) {
        return ((IKarmaCapability)player.getCapability(CapabilityKarma.KARMA_CAP, null)).getKarma();
    }

    public static KarmaStat.KarmaClass getKarmaClass(EntityPlayer player) {
        for (KarmaStat.KarmaClass c : KarmaStat.KarmaClass.values()) {
            if (!c.hasPlayerThisClass(player)) continue;
            return c;
        }
        return KarmaStat.KarmaClass.NEUTRAL;
    }

    public static KarmaStat.KarmaPlayerType getKarmaPlayerType(EntityPlayer player) {
        for (KarmaStat.KarmaPlayerType c : KarmaStat.KarmaPlayerType.values()) {
            if (!c.hasPlayerThisType(player)) continue;
            return c;
        }
        return KarmaStat.KarmaPlayerType.NEUTRAL;
    }

    public static int getKarmaStat(EntityPlayer player, KarmaStat stat) {
        return ((IKarmaCapability)player.getCapability(CapabilityKarma.KARMA_CAP, null)).getKarmaStat(stat);
    }

    public static void setKarmaStat(EntityPlayer player, KarmaStat stat, int amount) {
        ((IKarmaCapability)player.getCapability(CapabilityKarma.KARMA_CAP, null)).setKarmaStat(stat, MathHelper.func_76125_a((int)amount, (int)stat.getMin(), (int)stat.getMax()));
    }

    public static void increaseKarmaStat(EntityPlayer player, KarmaStat stat) {
        KarmaHandler.increaseKarmaStat(player, stat, 1);
    }

    public static void increaseKarmaStat(EntityPlayer player, KarmaStat stat, int amount) {
        IKarmaCapability cap = (IKarmaCapability)player.getCapability(CapabilityKarma.KARMA_CAP, null);
        cap.setKarmaStat(stat, MathHelper.func_76125_a((int)(cap.getKarmaStat(stat) + amount), (int)stat.getMin(), (int)stat.getMax()));
    }

    public static void decreaseKarmaStat(EntityPlayer player, KarmaStat stat) {
        KarmaHandler.decreaseKarmaStat(player, stat, 1);
    }

    public static void decreaseKarmaStat(EntityPlayer player, KarmaStat stat, int amount) {
        KarmaHandler.increaseKarmaStat(player, stat, -amount);
    }

    public static boolean isGoodPlayer(EntityPlayer player) {
        return KarmaHandler.getKarmaPlayerType(player) == KarmaStat.KarmaPlayerType.GOOD;
    }

    public static boolean isEvilPlayer(EntityPlayer player) {
        return KarmaHandler.getKarmaPlayerType(player) == KarmaStat.KarmaPlayerType.BAD;
    }

    public static boolean isEvilEntity(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return KarmaHandler.isEvilPlayer((EntityPlayer)entity);
        }
        return KarmaHandler.isMonster(entity);
    }

    public static boolean isMonster(EntityLivingBase entity) {
        for (Biome.SpawnListEntry entry : entity.field_70170_p.func_180494_b(entity.func_180425_c()).func_76747_a(EnumCreatureType.MONSTER)) {
            if (entry.field_76300_b != entity.getClass()) continue;
            return true;
        }
        return false;
    }

    public static boolean isGoodEntity(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return KarmaHandler.isGoodPlayer((EntityPlayer)entity);
        }
        return entity instanceof EntityVillager;
    }

    public static boolean isEntityAnimal(EntityLivingBase entity) {
        if (entity instanceof EntityVillager) {
            return false;
        }
        boolean b = false;
        for (Biome.SpawnListEntry entry : entity.field_70170_p.func_180494_b(entity.func_180425_c()).func_76747_a(EnumCreatureType.MONSTER)) {
            if (entry.field_76300_b != entity.getClass()) continue;
            b = true;
        }
        return entity instanceof IAnimals || b;
    }
}

