/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.materials;

import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.materials.blocks.MaterialsBlocks;
import lucraft.mods.lucraftcore.materials.integration.MaterialsTiConIntegration;
import lucraft.mods.lucraftcore.materials.items.MaterialsItems;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class Material {
    public static final RegistryNamespaced<String, Material> REGISTRY = new RegistryNamespaced();
    public static Material IRON = new Material(MaterialComponent.DUST, MaterialComponent.PLATE, MaterialComponent.FLUID).setColor(0xD8D8D8).setTemperature(769);
    public static Material GOLD = new Material(MaterialComponent.DUST, MaterialComponent.PLATE, MaterialComponent.FLUID).setColor(0xFFFF8B).setTemperature(532);
    public static Material COPPER = new Material(MaterialComponent.ALL).setHarvestLevel(1).setResistance(8.0f).setOreSettings(3, 8, 11, 0, 75).setColor(13669679).setTemperature(542);
    public static Material TIN = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(1).setResistance(8.0f).setOreSettings(2, 7, 9, 20, 55).setColor(14204842).setTemperature(350);
    public static Material NICKEL = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(1).setResistance(9.0f).setOreSettings(1, 4, 3, 5, 20).setColor(0xEDEDE8).setTemperature(727);
    public static Material LEAD = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(2).setResistance(9.0f).setOreSettings(2, 8, 6, 10, 35).setColor(6718869).setTemperature(400);
    public static Material SILVER = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(2).setResistance(10.0f).setOreSettings(3, 8, 6, 5, 30).setColor(14870761).setTemperature(480);
    public static Material PALLADIUM = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(2).setResistance(9.0f).setOreSettings(2, 6, 4, 2, 18).setColor(0xE7E7E7).setTemperature(500);
    public static Material TITANIUM = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(2).setResistance(17.0f).setOreSettings(2, 5, 2, 4, 14).setColor(0x474747).setTemperature(800);
    public static Material VIBRANIUM = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(3).setResistance(23.0f).setOreSettings(1, 4, 2, 3, 12).setColor(0x91C1CC).setTemperature(950);
    public static Material OSMIUM = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(1).setResistance(9.0f).setOreSettings(1, 5, 5, 10, 32).setColor(0x8AA9A9).setTemperature(500);
    public static Material IRIDIUM = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(3).setResistance(13.0f).setOreSettings(1, 4, 2, 3, 12).setColor(14212831).setTemperature(900);
    public static Material DWARF_STAR_ALLOY = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(2).setResistance(15.0f).setOreSettings(2, 6, 4, 2, 18).setColor(8027264).setTemperature(760);
    public static Material BRONZE = new Material(MaterialComponent.INGOT, MaterialComponent.BLOCK, MaterialComponent.NUGGET, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.FLUID).setHarvestLevel(1).setResistance(11.0f).setColor(11755318).setTemperature(475);
    public static Material GOLD_TITANIUM_ALLOY = new Material(MaterialComponent.INGOT, MaterialComponent.BLOCK, MaterialComponent.NUGGET, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.FLUID).setHarvestLevel(2).setResistance(20.0f).setColor(8418079).setTemperature(850);
    public static Material INTERTIUM = new Material(MaterialComponent.INGOT, MaterialComponent.BLOCK, MaterialComponent.NUGGET, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.FLUID).setHarvestLevel(1).setResistance(11.0f).setColor(10575454).setTemperature(752);
    public static Material URANIUM = new Material(MaterialComponent.ORE, MaterialComponent.BLOCK, MaterialComponent.INGOT, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.NUGGET, MaterialComponent.FLUID).setHarvestLevel(1).setResistance(9.0f).setOreSettings(3, 6, 4, 8, 24).setRadioactive(true).setColor(8966496);
    public static Material STEEL = new Material(MaterialComponent.INGOT, MaterialComponent.BLOCK, MaterialComponent.NUGGET, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.FLUID).setHarvestLevel(2).setResistance(13.0f).setColor(0x656565).setTemperature(681);
    public static Material ADAMANTIUM = new Material(MaterialComponent.INGOT, MaterialComponent.BLOCK, MaterialComponent.NUGGET, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.FLUID).setHarvestLevel(3).setResistance(30.0f).setColor(0xF7FFFF).setTemperature(1000);
    public static Material URU = new Material(MaterialComponent.INGOT, MaterialComponent.BLOCK, MaterialComponent.ORE, MaterialComponent.NUGGET, MaterialComponent.PLATE, MaterialComponent.DUST, MaterialComponent.FLUID).setHarvestLevel(3).setResistance(60.0f).setColor(0xD8D8D8).setTemperature(3000);
    public static Material COAL = new Material(MaterialComponent.DUST).setColor(0x2A2A2A);
    public static Material CHARCOAL = new Material(MaterialComponent.DUST).setColor(3089944);
    private MaterialComponent[] components;
    private Fluid fluid;
    private int harvestLevel;
    private float resistance;
    private int maxVeinSize;
    private int minVeinSize;
    private int chance;
    private int minY;
    private int maxY;
    private boolean generateOre;
    private boolean radioactive;
    private int color;
    private int temperature;

    public static void init() {
        REGISTRY.func_177775_a(0, (Object)"iron", (Object)IRON);
        REGISTRY.func_177775_a(1, (Object)"gold", (Object)GOLD);
        REGISTRY.func_177775_a(2, (Object)"copper", (Object)COPPER);
        REGISTRY.func_177775_a(3, (Object)"tin", (Object)TIN);
        REGISTRY.func_177775_a(4, (Object)"nickel", (Object)NICKEL);
        REGISTRY.func_177775_a(5, (Object)"lead", (Object)LEAD);
        REGISTRY.func_177775_a(6, (Object)"silver", (Object)SILVER);
        REGISTRY.func_177775_a(7, (Object)"palladium", (Object)PALLADIUM);
        REGISTRY.func_177775_a(8, (Object)"titanium", (Object)TITANIUM);
        REGISTRY.func_177775_a(9, (Object)"vibranium", (Object)VIBRANIUM);
        REGISTRY.func_177775_a(10, (Object)"osmium", (Object)OSMIUM);
        REGISTRY.func_177775_a(11, (Object)"iridium", (Object)IRIDIUM);
        REGISTRY.func_177775_a(12, (Object)"dwarfStarAlloy", (Object)DWARF_STAR_ALLOY);
        REGISTRY.func_177775_a(13, (Object)"bronze", (Object)BRONZE);
        REGISTRY.func_177775_a(14, (Object)"goldTitaniumAlloy", (Object)GOLD_TITANIUM_ALLOY);
        REGISTRY.func_177775_a(15, (Object)"intertium", (Object)INTERTIUM);
        REGISTRY.func_177775_a(16, (Object)"uranium", (Object)URANIUM);
        REGISTRY.func_177775_a(17, (Object)"steel", (Object)STEEL);
        REGISTRY.func_177775_a(18, (Object)"adamantium", (Object)ADAMANTIUM);
        REGISTRY.func_177775_a(19, (Object)"coal", (Object)COAL);
        REGISTRY.func_177775_a(20, (Object)"charcoal", (Object)CHARCOAL);
        REGISTRY.func_177775_a(21, (Object)"uru", (Object)URU);
        for (String s : REGISTRY.func_148742_b()) {
            Material m = (Material)REGISTRY.func_82594_a((Object)s);
            int id = REGISTRY.func_148757_b((Object)m);
            EnumHelper.addEnum(EnumMaterialWrapper.class, (String)m.getResourceName().toUpperCase(), (Class[])new Class[]{Material.class}, (Object[])new Object[]{m});
        }
    }

    public static int getHighestMaterialId() {
        int i = 0;
        for (String s : REGISTRY.func_148742_b()) {
            Material m = (Material)REGISTRY.func_82594_a((Object)s);
            if (REGISTRY.func_148757_b((Object)m) <= i) continue;
            i = REGISTRY.func_148757_b((Object)m);
        }
        return i;
    }

    public static List<Material> getMaterials() {
        ArrayList<Material> list = new ArrayList<Material>();
        for (String s : REGISTRY.func_148742_b()) {
            list.add((Material)REGISTRY.func_82594_a((Object)s));
        }
        return list;
    }

    public Material(MaterialComponent ... components) {
        this.components = components;
    }

    public String getIdentifier() {
        return (String)REGISTRY.func_177774_c((Object)this);
    }

    public String getUnlocalizedName() {
        return "lucraftcore.materials." + this.getIdentifier() + ".name";
    }

    public String getResourceName() {
        return StringHelper.unlocalizedToResourceName(this.getIdentifier());
    }

    public boolean autoGenerateComponent(MaterialComponent component) {
        for (MaterialComponent c : this.components) {
            if (!c.equals((Object)MaterialComponent.ALL) && !c.equals((Object)component)) continue;
            return true;
        }
        return false;
    }

    public ItemStack getItemStack(MaterialComponent component) {
        return this.getItemStack(component, 1);
    }

    public ItemStack getItemStack(MaterialComponent component, int amount) {
        if (this.equals(IRON)) {
            if (component == MaterialComponent.INGOT) {
                return new ItemStack(Items.field_151042_j, amount);
            }
            if (component == MaterialComponent.NUGGET) {
                return new ItemStack(Items.field_191525_da, amount);
            }
            if (component == MaterialComponent.ORE) {
                return new ItemStack(Blocks.field_150366_p, amount);
            }
            if (component == MaterialComponent.BLOCK) {
                return new ItemStack(Blocks.field_150339_S, amount);
            }
        }
        if (this.equals(GOLD)) {
            if (component == MaterialComponent.INGOT) {
                return new ItemStack(Items.field_151043_k, amount);
            }
            if (component == MaterialComponent.NUGGET) {
                return new ItemStack(Items.field_151074_bl, amount);
            }
            if (component == MaterialComponent.ORE) {
                return new ItemStack(Blocks.field_150352_o, amount);
            }
            if (component == MaterialComponent.BLOCK) {
                return new ItemStack(Blocks.field_150340_R, amount);
            }
        }
        if (!this.autoGenerateComponent(component)) {
            return ItemStack.field_190927_a;
        }
        if (component == MaterialComponent.INGOT) {
            return new ItemStack((Item)MaterialsItems.INGOTS.get(this), amount);
        }
        if (component == MaterialComponent.DUST) {
            return new ItemStack((Item)MaterialsItems.DUSTS.get(this), amount);
        }
        if (component == MaterialComponent.PLATE) {
            return new ItemStack((Item)MaterialsItems.PLATES.get(this), amount);
        }
        if (component == MaterialComponent.NUGGET) {
            return new ItemStack((Item)MaterialsItems.NUGGETS.get(this), amount);
        }
        if (component == MaterialComponent.WIRING) {
            return new ItemStack((Item)MaterialsItems.WIRINGS.get(this), amount);
        }
        if (component == MaterialComponent.ORE) {
            return new ItemStack(this.getBlock(component).func_177230_c(), amount);
        }
        if (component == MaterialComponent.BLOCK) {
            return new ItemStack(this.getBlock(component).func_177230_c(), amount);
        }
        return ItemStack.field_190927_a;
    }

    public IBlockState getBlock(MaterialComponent component) {
        if (this.equals(IRON)) {
            if (component == MaterialComponent.ORE) {
                return Blocks.field_150366_p.func_176223_P();
            }
            if (component == MaterialComponent.BLOCK) {
                return Blocks.field_150339_S.func_176223_P();
            }
        }
        if (this.equals(GOLD)) {
            if (component == MaterialComponent.ORE) {
                return Blocks.field_150352_o.func_176223_P();
            }
            if (component == MaterialComponent.BLOCK) {
                return Blocks.field_150340_R.func_176223_P();
            }
        }
        if (component == MaterialComponent.ORE) {
            return MaterialsBlocks.ORES.containsKey(this) ? MaterialsBlocks.ORES.get(this).func_176223_P() : null;
        }
        if (component == MaterialComponent.BLOCK) {
            return MaterialsBlocks.BLOCKS.containsKey(this) ? MaterialsBlocks.BLOCKS.get(this).func_176223_P() : null;
        }
        return null;
    }

    public Fluid getFluid() {
        return this.getFluid(false);
    }

    public Fluid getFluid(boolean ownFluid) {
        return null;
    }

    public String getRegistryName(MaterialComponent component) {
        if (component == MaterialComponent.ORE) {
            return "ore_" + this.getResourceName();
        }
        if (component == MaterialComponent.BLOCK) {
            return "block_" + this.getResourceName();
        }
        return component.getName().toLowerCase();
    }

    public String getOreDictionaryName(MaterialComponent c) {
        String name = c == MaterialComponent.WIRING ? "wire" : c.getName();
        return name + Character.toString(this.getIdentifier().charAt(0)).toUpperCase() + this.getIdentifier().substring(1);
    }

    public int getHarvestLevel(MaterialComponent component) {
        return this.harvestLevel;
    }

    public Material setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
        return this;
    }

    public float getResistance() {
        return this.resistance;
    }

    public Material setResistance(float resistance) {
        this.resistance = resistance;
        return this;
    }

    public float getBlockHardness(IBlockState blockState, World world, BlockPos pos) {
        return this.getResistance() / 2.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.getResistance();
    }

    public int getMaxVeinSize() {
        return this.maxVeinSize;
    }

    public int getMinVeinSize() {
        return this.minVeinSize;
    }

    public int getChance() {
        return this.chance;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public Material setOreSettings(int minVeinSize, int maxVeinSize, int chance, int minY, int maxY) {
        this.minVeinSize = minVeinSize;
        this.maxVeinSize = maxVeinSize;
        this.chance = chance;
        this.minY = minY;
        this.maxY = maxY;
        this.generateOre = true;
        return this;
    }

    public boolean generateOre() {
        return this.generateOre;
    }

    public boolean isRadioactive() {
        return this.radioactive;
    }

    public Material setRadioactive(boolean radioactive) {
        this.radioactive = radioactive;
        return this;
    }

    @Optional.Method(modid="tconstruct")
    public IMaterialStats[] getTiConMaterialStats() {
        int harvestLevel = this.getHarvestLevel(MaterialComponent.ORE) + 1;
        if (this == PALLADIUM) {
            return new IMaterialStats[]{new HeadMaterialStats(250, 5.78f, 4.9f, harvestLevel), new HandleMaterialStats(1.1f, 50), new ExtraMaterialStats(120), new BowMaterialStats(0.65f, 1.55f, 6.0f)};
        }
        if (this == IRIDIUM) {
            return new IMaterialStats[]{new HeadMaterialStats(1910, 11.02f, 9.95f, harvestLevel), new HandleMaterialStats(0.83f, 500), new ExtraMaterialStats(200), new BowMaterialStats(0.23f, 1.44f, 5.0f)};
        }
        if (this == TITANIUM) {
            return new IMaterialStats[]{new HeadMaterialStats(590, 7.63f, 10.41f, harvestLevel), new HandleMaterialStats(1.52f, 180), new ExtraMaterialStats(95), new BowMaterialStats(1.0f, 3.52f, 7.6f)};
        }
        if (this == OSMIUM) {
            return new IMaterialStats[]{new HeadMaterialStats(500, 3.73f, 4.01f, harvestLevel), new HandleMaterialStats(1.19f, 98), new ExtraMaterialStats(48), new BowMaterialStats(0.98f, 1.09f, 4.0f)};
        }
        if (this == DWARF_STAR_ALLOY) {
            return new IMaterialStats[]{new HeadMaterialStats(782, 8.69f, 8.62f, harvestLevel), new HandleMaterialStats(1.74f, 373), new ExtraMaterialStats(150), new BowMaterialStats(1.0f, 4.0f, 8.0f)};
        }
        if (this == GOLD_TITANIUM_ALLOY) {
            return new IMaterialStats[]{new HeadMaterialStats(698, 8.03f, 7.92f, harvestLevel), new HandleMaterialStats(1.54f, 321), new ExtraMaterialStats(132), new BowMaterialStats(1.0f, 3.75f, 7.2f)};
        }
        if (this == INTERTIUM) {
            return new IMaterialStats[]{new HeadMaterialStats(559, 4.21f, 4.9f, harvestLevel), new HandleMaterialStats(1.25f, 120), new ExtraMaterialStats(60), new BowMaterialStats(1.2f, 2.4f, 6.1f)};
        }
        if (this == VIBRANIUM) {
            return new IMaterialStats[]{new HeadMaterialStats(2519, 15.0f, 15.0f, harvestLevel), new HandleMaterialStats(2.0f, 1000), new ExtraMaterialStats(400), new BowMaterialStats(2.0f, 5.0f, 10.0f)};
        }
        if (this == ADAMANTIUM) {
            return new IMaterialStats[]{new HeadMaterialStats(2519, 15.0f, 20.0f, harvestLevel), new HandleMaterialStats(4.0f, 2000), new ExtraMaterialStats(600), new BowMaterialStats(4.0f, 8.0f, 15.0f)};
        }
        if (this == URU) {
            return new IMaterialStats[]{new HeadMaterialStats(16384, 20.0f, 40.0f, harvestLevel), new HandleMaterialStats(6.0f, 4000), new ExtraMaterialStats(800), new BowMaterialStats(6.0f, 12.0f, 20.0f)};
        }
        return new IMaterialStats[0];
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="tconstruct")
    public MaterialRenderInfo getTiConMaterialRenderInfo() {
        if (this == DWARF_STAR_ALLOY) {
            return new MaterialRenderInfo.BlockTexture(new ResourceLocation("lucraftcore", "blocks/ores/dwarf_star_alloy"));
        }
        if (this == VIBRANIUM) {
            return new MaterialRenderInfo.BlockTexture(new ResourceLocation("lucraftcore", "blocks/blocks/vibranium_0"));
        }
        return new MaterialRenderInfo.Default(this.getColor());
    }

    @Optional.Method(modid="tconstruct")
    public ITrait[] getTiConTraits() {
        if (this == DWARF_STAR_ALLOY) {
            return new ITrait[]{TinkerTraits.alien};
        }
        if (this == IRIDIUM) {
            return new ITrait[]{TinkerTraits.alien};
        }
        if (this == VIBRANIUM) {
            return new ITrait[]{TinkerTraits.dense, TinkerTraits.ecological, TinkerTraits.lightweight};
        }
        if (this == NICKEL && !Loader.isModLoaded((String)"mmdlib")) {
            return new ITrait[]{TinkerTraits.magnetic};
        }
        if (this == ADAMANTIUM) {
            return new ITrait[]{TinkerTraits.sharp};
        }
        if (this == URU) {
            return new ITrait[]{TinkerTraits.alien, MaterialsTiConIntegration.TRAIT_SUPER_HEAVY};
        }
        return new ITrait[0];
    }

    public int getColor() {
        return this.color;
    }

    public Material setColor(int color) {
        this.color = color;
        return this;
    }

    public int getTemperature() {
        return MathHelper.func_76125_a((int)this.temperature, (int)0, (int)1000);
    }

    public Material setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public static enum EnumMaterialWrapper implements IStringSerializable
    {

        private Material material;

        private EnumMaterialWrapper(Material material) {
            this.material = material;
        }

        public Material getMaterial() {
            return this.material;
        }

        public int getMetadataForBlock(MaterialComponent component) {
            for (int i = 0; i < 10; ++i) {
                EnumMaterialWrapper[] array = EnumMaterialWrapper.getMaterialsForBlock(component, i);
                for (int j = 0; j < array.length; ++j) {
                    if (array[j] != this) continue;
                    return j;
                }
            }
            return 0;
        }

        public String func_176610_l() {
            return this.getMaterial().getIdentifier().toLowerCase();
        }

        public static EnumMaterialWrapper getWrapperFromMetadata(int i) {
            for (EnumMaterialWrapper type : EnumMaterialWrapper.values()) {
                if (REGISTRY.func_148757_b((Object)type.getMaterial()) != i) continue;
                return type;
            }
            return null;
        }

        public static EnumMaterialWrapper[] getMaterialsForBlock(MaterialComponent component, int index) {
            ArrayList<EnumMaterialWrapper> list = new ArrayList<EnumMaterialWrapper>();
            int ignore = index * 16;
            for (EnumMaterialWrapper emw : EnumMaterialWrapper.values()) {
                if (!emw.getMaterial().autoGenerateComponent(component)) continue;
                if (ignore > 0) {
                    --ignore;
                    continue;
                }
                if (list.size() >= 16) continue;
                list.add(emw);
            }
            EnumMaterialWrapper[] array = new EnumMaterialWrapper[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = (EnumMaterialWrapper)((Object)list.get(i));
            }
            return array;
        }
    }

    public static enum MaterialComponent {
        ALL(""),
        INGOT("ingot"),
        ORE("ore"),
        BLOCK("block"),
        NUGGET("nugget"),
        PLATE("plate"),
        DUST("dust"),
        WIRING("wiring"),
        FLUID("fluid");

        private String name;

        private MaterialComponent(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

