/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.materials;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lucraft.mods.lucraftcore.infinity.ModuleInfinity;
import lucraft.mods.lucraftcore.materials.Material;
import lucraft.mods.lucraftcore.util.helper.mods.ThermalExpansionHelper;
import lucraft.mods.lucraftcore.utilities.blocks.UtilitiesBlocks;
import lucraft.mods.lucraftcore.utilities.items.UtilitiesItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class MaterialsRecipes {
    public static boolean generateRecipeJson = false;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File RECIPE_DIR = null;
    private static final Set<String> USED_OD_NAMES = new TreeSet<String>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRegisterRecipes(RegistryEvent.Register<IRecipe> e) {
        MaterialsRecipes.init();
        if (generateRecipeJson) {
            for (Material m : Material.getMaterials()) {
                ItemStack stack;
                if (m.autoGenerateComponent(Material.MaterialComponent.BLOCK)) {
                    MaterialsRecipes.addShapedRecipe(m.getItemStack(Material.MaterialComponent.BLOCK), new ResourceLocation("lucraftcore", "ingots_to_block"), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), m.getOreDictionaryName(Material.MaterialComponent.INGOT)});
                }
                if (m.autoGenerateComponent(Material.MaterialComponent.INGOT)) {
                    MaterialsRecipes.addShapedRecipe(m.getItemStack(Material.MaterialComponent.INGOT, 9), new ResourceLocation("lucraftcore", "block_to_ingots"), new Object[]{"X", Character.valueOf('X'), m.getOreDictionaryName(Material.MaterialComponent.BLOCK)});
                }
                if (m.autoGenerateComponent(Material.MaterialComponent.INGOT)) {
                    MaterialsRecipes.addShapedRecipe(m.getItemStack(Material.MaterialComponent.INGOT), new ResourceLocation("lucraftcore", "nuggets_to_ingot"), new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), m.getOreDictionaryName(Material.MaterialComponent.NUGGET)});
                }
                if (m.autoGenerateComponent(Material.MaterialComponent.NUGGET)) {
                    MaterialsRecipes.addShapedRecipe(m.getItemStack(Material.MaterialComponent.NUGGET, 9), new ResourceLocation("lucraftcore", "ingot_to_nuggets"), new Object[]{"X", Character.valueOf('X'), m.getOreDictionaryName(Material.MaterialComponent.INGOT)});
                }
                if (m.autoGenerateComponent(Material.MaterialComponent.PLATE) && !(stack = m.getItemStack(Material.MaterialComponent.INGOT)).func_190926_b()) {
                    MaterialsRecipes.addShapelessRecipe(m.getItemStack(Material.MaterialComponent.PLATE), new ResourceLocation("lucraftcore", "ingots_to_plate"), new Object[]{new ItemStack(UtilitiesItems.HAMMER, 1, Short.MAX_VALUE), m.getOreDictionaryName(Material.MaterialComponent.INGOT), stack});
                }
                if (!m.autoGenerateComponent(Material.MaterialComponent.DUST) || (stack = m == Material.COAL ? new ItemStack(Items.field_151044_h) : (m == Material.CHARCOAL ? new ItemStack(Items.field_151044_h, 1, 1) : m.getOreDictionaryName(Material.MaterialComponent.INGOT))) == null) continue;
                MaterialsRecipes.addShapelessRecipe(m.getItemStack(Material.MaterialComponent.DUST), new ResourceLocation("lucraftcore", "ingot_to_dust"), new Object[]{new ItemStack(UtilitiesItems.HAMMER, 1, Short.MAX_VALUE), stack});
            }
            for (EnumDyeColor color : EnumDyeColor.values()) {
                String dye = "dye" + color.func_176762_d().substring(0, 1).toUpperCase() + color.func_176762_d().substring(1, color.func_176762_d().length());
                if (color == EnumDyeColor.SILVER) {
                    dye = "dyeLightGray";
                }
                MaterialsRecipes.addShapelessRecipe(new ItemStack((Item)UtilitiesItems.TRI_POLYMER.get(color)), new ResourceLocation("lucraftcore", "tri_polymer"), new Object[]{dye, "plateIron", Items.field_151116_aA});
            }
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesItems.HAMMER), " XX", "SSX", " XX", Character.valueOf('X'), "ingotIron", Character.valueOf('S'), "stickWood");
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesItems.INJECTION), "  N", "IP ", "PI ", Character.valueOf('P'), "plateTin", Character.valueOf('N'), "nuggetSilver", Character.valueOf('I'), "ingotIron");
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesItems.LV_CAPACITOR), new ResourceLocation("lucraftcore", "capacitor"), new Object[]{"IRI", "PLP", "PCP", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateIron", Character.valueOf('L'), "ingotLead", Character.valueOf('C'), "plateCopper"});
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesItems.MV_CAPACITOR), new ResourceLocation("lucraftcore", "capacitor"), new Object[]{"IRI", "PLP", "PCP", Character.valueOf('R'), "blockRedstone", Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateIron", Character.valueOf('L'), "ingotLead", Character.valueOf('C'), "plateOsmium"});
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesItems.HV_CAPACITOR), new ResourceLocation("lucraftcore", "capacitor"), new Object[]{"IRI", "PLP", "PCP", Character.valueOf('R'), "blockRedstone", Character.valueOf('I'), "ingotSteel", Character.valueOf('P'), "plateIron", Character.valueOf('L'), "blockLead", Character.valueOf('C'), "plateIntertium"});
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesItems.WIRE_CUTTER), " P ", "S S", Character.valueOf('P'), "plateIron", Character.valueOf('S'), "stickWood");
            MaterialsRecipes.addShapelessRecipe(Material.COPPER.getItemStack(Material.MaterialComponent.WIRING, 4), "plateCopper", UtilitiesItems.WIRE_CUTTER);
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesItems.SERVO_MOTOR), " P ", "WIW", " P ", Character.valueOf('P'), "plateIron", Character.valueOf('I'), "ingotIron", Character.valueOf('W'), "wireCopper");
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesItems.BASIC_CIRCUIT), new ResourceLocation("lucraftcore", "circuit"), new Object[]{"WWW", "RPR", "WWW", Character.valueOf('W'), "wireCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), "plateIron"});
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesItems.ADVANCED_CIRCUIT), new ResourceLocation("lucraftcore", "circuit"), new Object[]{"WCW", "RPR", "WCW", Character.valueOf('W'), "wireCopper", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), "circuitBasic", Character.valueOf('C'), UtilitiesItems.LV_CAPACITOR});
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesBlocks.CONSTRUCTION_TABLE), "PPP", "ICI", "IPI", Character.valueOf('P'), "plateIron", Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('I'), "ingotIron");
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesBlocks.SUIT_STAND), " I ", " A ", "PPP", Character.valueOf('P'), "plateIron", Character.valueOf('I'), "ingotIron", Character.valueOf('A'), Items.field_179565_cj);
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesBlocks.EXTRACTOR), "PIP", "BCB", "PXP", Character.valueOf('P'), "plateIron", Character.valueOf('I'), UtilitiesItems.INJECTION, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('C'), "circuitBasic", Character.valueOf('X'), UtilitiesItems.LV_CAPACITOR);
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesBlocks.BOILER), "PCP", "BXB", "PKP", Character.valueOf('P'), "plateIron", Character.valueOf('K'), Items.field_151066_bu, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('C'), "circuitBasic", Character.valueOf('X'), UtilitiesItems.LV_CAPACITOR);
            MaterialsRecipes.addShapedRecipe(new ItemStack(ModuleInfinity.INFINITY_GENERATOR), "PCP", "SNS", "PAP", Character.valueOf('P'), "plateDwarfStarAlloy", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('S'), "blockSteel", Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('A'), UtilitiesItems.HV_CAPACITOR);
            MaterialsRecipes.addShapedRecipe(new ItemStack(UtilitiesBlocks.FURNACE_GENERATOR), "CRC", "IBI", "IFI", Character.valueOf('C'), "ingotCopper", Character.valueOf('R'), "blockRedstone", Character.valueOf('I'), "plateIron", Character.valueOf('B'), UtilitiesItems.LV_CAPACITOR, Character.valueOf('F'), Blocks.field_150460_al);
            MaterialsRecipes.addShapelessRecipe(Material.STEEL.getItemStack(Material.MaterialComponent.DUST, 1), new ResourceLocation("lucraftcore", "alloys"), new Object[]{"dustIron", "dustCoal", "dustCoal", "dustCoal", "dustCoal"});
            MaterialsRecipes.addShapelessRecipe(Material.ADAMANTIUM.getItemStack(Material.MaterialComponent.DUST, 3), new ResourceLocation("lucraftcore", "alloys"), new Object[]{"dustSteel", "dustSteel", "dustVibranium"});
            MaterialsRecipes.addShapelessRecipe(Material.INTERTIUM.getItemStack(Material.MaterialComponent.DUST, 3), new ResourceLocation("lucraftcore", "alloys"), new Object[]{"dustIron", "dustIron", "dustOsmium"});
            MaterialsRecipes.addShapelessRecipe(Material.BRONZE.getItemStack(Material.MaterialComponent.DUST, 2), new ResourceLocation("lucraftcore", "alloys"), new Object[]{"dustCopper", "dustCopper", "dustCopper", "dustTin"});
            MaterialsRecipes.addShapelessRecipe(Material.GOLD_TITANIUM_ALLOY.getItemStack(Material.MaterialComponent.DUST, 3), new ResourceLocation("lucraftcore", "alloys"), new Object[]{"dustGold", "dustTitanium", "dustTitanium"});
            MaterialsRecipes.generateConstants();
        }
    }

    public static void init() {
        for (Material m : Material.getMaterials()) {
            for (Material.MaterialComponent mc : Material.MaterialComponent.values()) {
                if (mc == Material.MaterialComponent.ALL || mc == Material.MaterialComponent.FLUID || !m.autoGenerateComponent(mc)) continue;
                OreDictionary.registerOre((String)m.getOreDictionaryName(mc), (ItemStack)m.getItemStack(mc));
                if (mc != Material.MaterialComponent.WIRING) continue;
                OreDictionary.registerOre((String)m.getOreDictionaryName(mc).replace("wire", "wiring"), (ItemStack)m.getItemStack(mc));
            }
        }
    }

    public static void postInit() {
        for (Material m : Material.getMaterials()) {
            if (!m.getItemStack(Material.MaterialComponent.ORE).func_190926_b() && !m.getItemStack(Material.MaterialComponent.INGOT).func_190926_b()) {
                GameRegistry.addSmelting((ItemStack)m.getItemStack(Material.MaterialComponent.ORE), (ItemStack)m.getItemStack(Material.MaterialComponent.INGOT), (float)1.0f);
            }
            if (m.getItemStack(Material.MaterialComponent.DUST).func_190926_b() || m.getItemStack(Material.MaterialComponent.INGOT).func_190926_b()) continue;
            GameRegistry.addSmelting((ItemStack)m.getItemStack(Material.MaterialComponent.DUST), (ItemStack)m.getItemStack(Material.MaterialComponent.INGOT), (float)1.0f);
        }
        MaterialsRecipes.addAlloyRecipe("ingotTin", 1, "ingotCopper", 3, "ingotBronze", 4);
        MaterialsRecipes.addAlloyRecipe("ingotTin", 1, "dustCopper", 3, "ingotBronze", 4);
        MaterialsRecipes.addAlloyRecipe("dustTin", 1, "ingotCopper", 3, "ingotBronze", 4);
        MaterialsRecipes.addAlloyRecipe("dustTin", 1, "dustCopper", 3, "ingotBronze", 4);
        MaterialsRecipes.addAlloyRecipe("ingotSteel", 2, "ingotVibranium", 1, "ingotAdamantium", 3);
        MaterialsRecipes.addAlloyRecipe("ingotSteel", 2, "dustVibranium", 1, "ingotAdamantium", 3);
        MaterialsRecipes.addAlloyRecipe("dustSteel", 2, "ingotVibranium", 1, "ingotAdamantium", 3);
        MaterialsRecipes.addAlloyRecipe("dustSteel", 2, "dustVibranium", 1, "ingotAdamantium", 3);
        MaterialsRecipes.addAlloyRecipe("ingotIron", 2, "ingotOsmium", 1, "ingotIntertium", 3);
        MaterialsRecipes.addAlloyRecipe("ingotIron", 2, "dustOsmium", 1, "ingotIntertium", 3);
        MaterialsRecipes.addAlloyRecipe("dustIron", 2, "ingotOsmium", 1, "ingotIntertium", 3);
        MaterialsRecipes.addAlloyRecipe("dustIron", 2, "dustOsmium", 1, "ingotIntertium", 3);
        MaterialsRecipes.addAlloyRecipe("ingotGold", 1, "ingotTitanium", 2, "ingotGoldTitaniumAlloy", 3);
        MaterialsRecipes.addAlloyRecipe("ingotGold", 1, "dustGold", 2, "ingotGoldTitaniumAlloy", 3);
        MaterialsRecipes.addAlloyRecipe("dustGold", 1, "ingotTitanium", 2, "ingotGoldTitaniumAlloy", 3);
        MaterialsRecipes.addAlloyRecipe("dustGold", 1, "dustTitanium", 2, "ingotGoldTitaniumAlloy", 3);
        MaterialsRecipes.addAlloyRecipe("ingotIron", 2, "ingotNickel", 1, "ingotInvar", 3);
        MaterialsRecipes.addAlloyRecipe("ingotIron", 2, "dustIron", 1, "ingotInvar", 3);
        MaterialsRecipes.addAlloyRecipe("dustIron", 2, "ingotNickel", 1, "ingotInvar", 3);
        MaterialsRecipes.addAlloyRecipe("dustIron", 2, "dustNickel", 1, "ingotInvar", 3);
        MaterialsRecipes.addAlloyRecipe("ingotGold", 1, "ingotSilver", 1, "ingotElectrum", 2);
        MaterialsRecipes.addAlloyRecipe("ingotGold", 1, "dustGold", 1, "ingotElectrum", 2);
        MaterialsRecipes.addAlloyRecipe("dustGold", 1, "ingotSilver", 1, "ingotElectrum", 2);
        MaterialsRecipes.addAlloyRecipe("dustGold", 2, "dustSilver", 1, "ingotElectrum", 3);
        MaterialsRecipes.addAlloyRecipe("dustIron", 1, "dustCoal", 2, "ingotSteel", 1);
        MaterialsRecipes.addAlloyRecipe("dustIron", 1, "dustCharcoal", 4, "ingotSteel", 1);
        MaterialsRecipes.addAlloyRecipe("ingotIron", 1, "dustCoal", 2, "ingotSteel", 1);
        MaterialsRecipes.addAlloyRecipe("ingotIron", 1, "dustCharcoal", 4, "ingotSteel", 1);
        MaterialsRecipes.addAlloyRecipe("dustSteel", 1, "dustCoal", 2, "ingotSteel", 1);
        MaterialsRecipes.addAlloyRecipe("dustSteel", 1, "dustCharcoal", 2, "ingotSteel", 1);
    }

    public static void addAlloyRecipe(String ore1, int amount1, String ore2, int amount2, String output, int amountOutput) {
        for (ItemStack i1 : OreDictionary.getOres((String)ore1)) {
            for (ItemStack i2 : OreDictionary.getOres((String)ore2)) {
                for (ItemStack i3 : OreDictionary.getOres((String)output)) {
                    ItemStack ingredient1 = i1.func_77946_l();
                    ingredient1.func_190920_e(amount1);
                    ItemStack ingredient2 = i2.func_77946_l();
                    ingredient2.func_190920_e(amount2);
                    ItemStack outputStack = i3.func_77946_l();
                    outputStack.func_190920_e(amountOutput);
                    int amount = ingredient1.func_190916_E() + ingredient2.func_190916_E();
                    ThermalExpansionHelper.addSmelterRecipe(amount * 1200, ingredient1, ingredient2, outputStack);
                }
            }
        }
    }

    public static void setupDir() {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = new File("recipes");
        }
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
    }

    public static void addShapedRecipe(ItemStack result, Object ... components) {
        MaterialsRecipes.addShapedRecipe(result, null, components);
    }

    public static void addShapedRecipe(ItemStack result, ResourceLocation group, Object ... components) {
        int i;
        MaterialsRecipes.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<ResourceLocation> items = new ArrayList<ResourceLocation>();
        items.add(result.func_77973_b().getRegistryName());
        for (Object c : components) {
            ResourceLocation loc = null;
            if (c instanceof ItemStack) {
                loc = ((ItemStack)c).func_77973_b().getRegistryName();
            } else if (c instanceof Item) {
                loc = ((Item)c).getRegistryName();
            } else if (c instanceof Block) {
                loc = ((Block)c).getRegistryName();
            }
            if (items.contains(loc) || loc == null) continue;
            items.add(loc);
        }
        ArrayList conditions = new ArrayList();
        for (ResourceLocation rl : items) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", "minecraft:item_exists");
            map.put("item", rl.toString());
            conditions.add(map);
        }
        json.put("conditions", conditions.toArray(new Map[conditions.size()]));
        ArrayList<String> pattern = new ArrayList<String>();
        for (i = 0; i < components.length && components[i] instanceof String; ++i) {
            pattern.add((String)components[i]);
        }
        json.put("pattern", pattern);
        boolean isOreDict = false;
        HashMap<String, Map<String, Object>> key = new HashMap<String, Map<String, Object>>();
        Character curKey = null;
        while (i < components.length) {
            Object o = components[i];
            if (o instanceof Character) {
                if (curKey != null) {
                    throw new IllegalArgumentException("Provided two char ac_keys in a row");
                }
                curKey = (Character)o;
            } else {
                if (curKey == null) {
                    throw new IllegalArgumentException("Providing object without a char key");
                }
                if (o instanceof String) {
                    isOreDict = true;
                }
                key.put(Character.toString(curKey.charValue()), MaterialsRecipes.serializeItem(o));
                curKey = null;
            }
            ++i;
        }
        json.put("key", key);
        json.put("type", isOreDict ? "forge:ore_shaped" : "minecraft:crafting_shaped");
        json.put("result", MaterialsRecipes.serializeItem(result));
        if (group != null) {
            json.put("group", group.toString());
        }
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addShapelessRecipe(ItemStack result, Object ... components) {
        MaterialsRecipes.addShapelessRecipe(result, null, components);
    }

    public static void addShapelessRecipe(ItemStack result, ResourceLocation group, Object ... components) {
        MaterialsRecipes.setupDir();
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<ResourceLocation> items = new ArrayList<ResourceLocation>();
        items.add(result.func_77973_b().getRegistryName());
        for (Object c : components) {
            ResourceLocation loc = null;
            if (c instanceof ItemStack) {
                loc = ((ItemStack)c).func_77973_b().getRegistryName();
            } else if (c instanceof Item) {
                loc = ((Item)c).getRegistryName();
            } else if (c instanceof Block) {
                loc = ((Block)c).getRegistryName();
            }
            if (items.contains(loc) || loc == null) continue;
            items.add(loc);
        }
        ArrayList conditions = new ArrayList();
        for (ResourceLocation rl : items) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", "minecraft:item_exists");
            map.put("item", rl.toString());
            conditions.add(map);
        }
        json.put("conditions", conditions.toArray(new Map[conditions.size()]));
        boolean isOreDict = false;
        ArrayList<Map<String, Object>> ingredients = new ArrayList<Map<String, Object>>();
        for (Object o : components) {
            if (o instanceof String) {
                isOreDict = true;
            }
            ingredients.add(MaterialsRecipes.serializeItem(o));
        }
        json.put("ingredients", ingredients);
        json.put("type", isOreDict ? "forge:ore_shapeless" : "minecraft:crafting_shapeless");
        json.put("result", MaterialsRecipes.serializeItem(result));
        if (group != null) {
            json.put("group", group.toString());
        }
        String suffix = result.func_77973_b().func_77614_k() ? "_" + result.func_77952_i() : "";
        File f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        while (f.exists()) {
            suffix = suffix + "_alt";
            f = new File(RECIPE_DIR, result.func_77973_b().getRegistryName().func_110623_a() + suffix + ".json");
        }
        try (FileWriter w = new FileWriter(f);){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> serializeItem(Object thing) {
        if (thing instanceof Item) {
            return MaterialsRecipes.serializeItem(new ItemStack((Item)thing));
        }
        if (thing instanceof Block) {
            return MaterialsRecipes.serializeItem(new ItemStack((Block)thing));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77973_b().func_77614_k() || stack.func_77952_i() != 0) {
                ret.put("data", stack.func_77952_i());
            }
            if (stack.func_190916_E() > 1) {
                ret.put("count", stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                ret.put("type", "minecraft:item_nbt");
                ret.put("nbt", stack.func_77978_p().toString());
            }
            return ret;
        }
        if (thing instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_OD_NAMES.add((String)thing);
            ret.put("item", "#" + ((String)thing).toUpperCase(Locale.ROOT));
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    public static void generateConstants() {
        ArrayList json = new ArrayList();
        for (String s : USED_OD_NAMES) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", s.toUpperCase(Locale.ROOT));
            entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
            json.add(entry);
        }
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_constants.json"));){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

