/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.materials.fluids;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import lucraft.mods.lucraftcore.materials.Material;
import lucraft.mods.lucraftcore.materials.fluids.BlockMoltenMetal;
import lucraft.mods.lucraftcore.materials.fluids.FluidMoltenMetal;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MaterialsFluids {
    public static List<BlockMoltenMetal> FLUIDS = new ArrayList<BlockMoltenMetal>();

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> e) {
        for (Material m : Material.getMaterials()) {
            if (!m.autoGenerateComponent(Material.MaterialComponent.FLUID) || FluidRegistry.isFluidRegistered((String)m.getIdentifier().toLowerCase())) continue;
            FluidMoltenMetal fluid = new FluidMoltenMetal(m);
            FluidRegistry.registerFluid((Fluid)fluid);
            FluidRegistry.addBucketForFluid((Fluid)fluid);
            BlockMoltenMetal block = (BlockMoltenMetal)new BlockMoltenMetal(fluid).setRegistryName("molten_" + StringHelper.unlocalizedToResourceName(m.getIdentifier()));
            e.getRegistry().register((IForgeRegistryEntry)block);
            FLUIDS.add(block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent e) {
        for (BlockMoltenMetal blocks : FLUIDS) {
            FluidStateMapper mapper = new FluidStateMapper(blocks.getFluid());
            ModelLoader.setCustomStateMapper((Block)blocks, (IStateMapper)mapper);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRegisterTexture(TextureStitchEvent.Pre e) {
        e.getMap().func_174942_a(FluidMoltenMetal.ICON_METAL_STIL);
        e.getMap().func_174942_a(FluidMoltenMetal.ICON_METAL_FLOW);
    }

    @SideOnly(value=Side.CLIENT)
    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public FluidStateMapper(ModelResourceLocation location) {
            this.location = location;
        }

        public FluidStateMapper(Fluid fluid) {
            this(new ModelResourceLocation(new ResourceLocation("lucraftcore", "molten_metal"), fluid.getName()));
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

