/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.sizechanging.capabilities;

import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.LCConfig;
import lucraft.mods.lucraftcore.network.LCPacketDispatcher;
import lucraft.mods.lucraftcore.sizechanging.capabilities.CapabilitySizeChangingProvider;
import lucraft.mods.lucraftcore.sizechanging.capabilities.ISizeChanging;
import lucraft.mods.lucraftcore.sizechanging.entities.EntitySizeChanging;
import lucraft.mods.lucraftcore.sizechanging.events.EntityCanChangeInSizeEvent;
import lucraft.mods.lucraftcore.sizechanging.events.SizeChangeEvent;
import lucraft.mods.lucraftcore.sizechanging.network.MessageSyncSizeChanging;
import lucraft.mods.lucraftcore.sizechanging.sizechanger.SizeChanger;
import lucraft.mods.lucraftcore.superpowers.effects.EffectTrail;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapabilitySizeChanging
implements ISizeChanging {
    @CapabilityInject(value=ISizeChanging.class)
    public static final Capability<ISizeChanging> SIZE_CHANGING_CAP = null;
    public static final double MIN_SIZE = 0.1;
    public static final double MAX_SIZE = 16.0;
    public EntityLivingBase entity;
    protected float size;
    protected float sizePerTick;
    protected float prevSize;
    protected float estimatedSize;
    protected float origWidth;
    protected float origHeight;
    protected SizeChanger sizeChanger;
    protected List<EntitySizeChanging> entities;

    public CapabilitySizeChanging(EntityLivingBase entity) {
        this.entity = entity;
        this.entities = new ArrayList<EntitySizeChanging>();
    }

    @Override
    public void tick() {
        if (this.origWidth == 0.0f) {
            this.origWidth = this.entity.field_70130_N;
        }
        if (this.origHeight == 0.0f) {
            this.origHeight = this.entity.field_70131_O;
        }
        if (this.size == 0.0f) {
            this.size = 1.0f;
        }
        this.prevSize = this.size;
        if (this.sizePerTick != 0.0f) {
            this.size += this.sizePerTick;
            if (Math.abs(this.size - this.estimatedSize) < Math.abs(this.sizePerTick)) {
                this.sizePerTick = 0.0f;
                this.size = this.estimatedSize;
                this.getSizeChanger().end(this.entity, this, this.size);
                MinecraftForge.EVENT_BUS.post((Event)new SizeChangeEvent.Post(this.entity, this.size, this.sizeChanger));
            }
            this.getSizeChanger().onSizeChanged(this.entity, this, this.size);
        }
        this.size = (float)MathHelper.func_151237_a((double)this.size, (double)0.1, (double)16.0);
        this.updateHitbox();
        this.getSizeChanger().onUpdate(this.entity, this, this.size);
        if (this.entities.size() > 0) {
            ArrayList<EntitySizeChanging> copy = new ArrayList<EntitySizeChanging>(this.entities);
            for (EntitySizeChanging entity : copy) {
                if (entity != null && !entity.field_70128_L) continue;
                this.entities.remove((Object)entity);
            }
        }
    }

    public void updateHitbox() {
        float size = this.getRenderSize(FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? LCRenderHelper.renderTick : 1.0f);
        Vec3d pos = this.entity.func_174791_d();
        float w = size == 0.1f && this.origWidth == 0.6f ? 0.0625f : this.origWidth * size;
        float width = w / 2.0f;
        float height = this.origHeight * size;
        this.entity.field_70130_N = w;
        this.entity.field_70131_O = height;
        this.entity.func_174826_a(new AxisAlignedBB(pos.field_72450_a - (double)width, pos.field_72448_b, pos.field_72449_c - (double)width, pos.field_72450_a + (double)width, pos.field_72448_b + (double)height, pos.field_72449_c + (double)width));
        if (this.entity instanceof EntityPlayer) {
            ((EntityPlayer)this.entity).eyeHeight = ((EntityPlayer)this.entity).getDefaultEyeHeight() * size;
        }
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public float getRenderSize(float partialTick) {
        return this.prevSize + (this.size - this.prevSize) * partialTick;
    }

    @Override
    public boolean setSize(float size) {
        return this.setSize(size, this.getSizeChanger());
    }

    @Override
    public boolean setSize(float size, SizeChanger sizeChanger) {
        if (size != this.estimatedSize) {
            if (MinecraftForge.EVENT_BUS.post((Event)new SizeChangeEvent.Pre(this.entity, this.size, size, sizeChanger))) {
                return false;
            }
            if (!sizeChanger.start(this.entity, this, this.size, size)) {
                return false;
            }
            this.sizeChanger = sizeChanger;
            this.estimatedSize = size;
            this.sizePerTick = (this.estimatedSize - this.size) / (float)this.getSizeChanger().getSizeChangingTime(this.entity, this, this.estimatedSize);
            this.syncToAll();
            return true;
        }
        return false;
    }

    @Override
    public void setSizeDirectly(float size) {
        if (this.size != size) {
            this.size = (float)MathHelper.func_151237_a((double)size, (double)0.1, (double)16.0);
            this.estimatedSize = size;
            this.sizePerTick = 0.0f;
            this.syncToAll();
            this.updateHitbox();
        }
    }

    @Override
    public void changeSizeChanger(SizeChanger sizeChanger) {
        if (this.sizeChanger != sizeChanger && sizeChanger != null) {
            this.sizeChanger = sizeChanger;
            this.syncToAll();
        }
    }

    @Override
    public SizeChanger getSizeChanger() {
        return this.sizeChanger == null ? SizeChanger.DEFAULT_SIZE_CHANGER : this.sizeChanger;
    }

    @Override
    public void setOriginalSize(float width, float height) {
        this.origWidth = width;
        this.origHeight = height;
        this.syncToAll();
    }

    @Override
    public float getOriginalWidth() {
        return this.origHeight;
    }

    @Override
    public float getOriginalHeight() {
        return this.origWidth;
    }

    @Override
    public EntitySizeChanging spawnEntity(SizeChanger sizeChanger, int lifeTime, float size) {
        EntitySizeChanging entity = new EntitySizeChanging(this.entity.field_70170_p, this.entity, sizeChanger, size, lifeTime);
        this.entity.field_70170_p.func_72838_d((Entity)entity);
        this.entities.add(entity);
        return entity;
    }

    @Override
    public List<EntitySizeChanging> getEntities() {
        return this.entities;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("Size", this.size);
        nbt.func_74776_a("SizePerTick", this.sizePerTick);
        nbt.func_74776_a("EstimatedSize", this.estimatedSize);
        nbt.func_74776_a("OrigWidth", this.origWidth);
        nbt.func_74776_a("OrigHeight", this.origHeight);
        nbt.func_74778_a("SizeChanger", this.getSizeChanger().getRegistryName().toString());
        return nbt;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.size = nbt.func_74760_g("Size");
        this.sizePerTick = nbt.func_74760_g("SizePerTick");
        this.estimatedSize = nbt.func_74760_g("EstimatedSize");
        this.origWidth = nbt.func_74760_g("OrigWidth");
        this.origHeight = nbt.func_74760_g("OrigHeight");
        this.sizeChanger = (SizeChanger)SizeChanger.SIZE_CHANGER_REGISTRY.getValue(new ResourceLocation(nbt.func_74779_i("SizeChanger")));
    }

    @Override
    public void syncToPlayer(EntityPlayer receiver) {
        if (receiver instanceof EntityPlayerMP) {
            LCPacketDispatcher.sendTo(new MessageSyncSizeChanging((Entity)this.entity), (EntityPlayerMP)receiver);
        }
    }

    @Override
    public void syncToAll() {
        if (this.entity instanceof EntityPlayerMP) {
            this.syncToPlayer((EntityPlayer)((EntityPlayerMP)this.entity));
        }
        if (this.entity.field_70170_p instanceof WorldServer) {
            for (EntityPlayer players : ((WorldServer)this.entity.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this.entity)) {
                if (!(players instanceof EntityPlayerMP)) continue;
                LCPacketDispatcher.sendTo(new MessageSyncSizeChanging((Entity)this.entity), (EntityPlayerMP)players);
            }
        }
    }

    public static class Storage
    implements Capability.IStorage<ISizeChanging> {
        public NBTBase writeNBT(Capability<ISizeChanging> capability, ISizeChanging instance, EnumFacing side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<ISizeChanging> capability, ISizeChanging instance, EnumFacing side, NBTBase nbt) {
            instance.readNBT((NBTTagCompound)nbt);
        }
    }

    public static class EventHandler {
        public static boolean canChangeInSize(Entity entity) {
            if (!(entity instanceof EntityLivingBase) || entity instanceof EntitySizeChanging || entity instanceof EffectTrail.EntityTrail || MinecraftForge.EVENT_BUS.post((Event)new EntityCanChangeInSizeEvent((EntityLivingBase)entity))) {
                return false;
            }
            return !LCConfig.SizeChanging.isEntityBlacklisted((EntityLivingBase)entity);
        }

        @Optional.Method(modid="customnpcs")
        @SubscribeEvent
        public void onCanChangeInSize(EntityCanChangeInSizeEvent e) {
            if (e.getEntity().getClass().getCanonicalName().startsWith("noppes.npcs.entity")) {
                e.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            if (((Entity)evt.getObject()).hasCapability(SIZE_CHANGING_CAP, null) || !(evt.getObject() instanceof EntityLivingBase) || !EventHandler.canChangeInSize((Entity)evt.getObject())) {
                return;
            }
            evt.addCapability(new ResourceLocation("lucraftcore", "size_changing"), (ICapabilityProvider)new CapabilitySizeChangingProvider(new CapabilitySizeChanging((EntityLivingBase)evt.getObject())));
        }

        @SubscribeEvent
        public void onPlayerStartTracking(PlayerEvent.StartTracking e) {
            if (e.getTarget().hasCapability(SIZE_CHANGING_CAP, null)) {
                ((ISizeChanging)e.getTarget().getCapability(SIZE_CHANGING_CAP, null)).syncToPlayer(e.getEntityPlayer());
            }
        }

        @SubscribeEvent
        public void onPlayerClone(PlayerEvent.Clone e) {
            NBTTagCompound compound = (NBTTagCompound)SIZE_CHANGING_CAP.getStorage().writeNBT(SIZE_CHANGING_CAP, e.getOriginal().getCapability(SIZE_CHANGING_CAP, null), null);
            SIZE_CHANGING_CAP.getStorage().readNBT(SIZE_CHANGING_CAP, e.getEntityPlayer().getCapability(SIZE_CHANGING_CAP, null), null, (NBTBase)compound);
        }

        @SubscribeEvent
        public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
            if (!(e.getEntityLiving() instanceof EntityPlayer) && e.getEntityLiving().hasCapability(SIZE_CHANGING_CAP, null)) {
                ((ISizeChanging)e.getEntityLiving().getCapability(SIZE_CHANGING_CAP, null)).tick();
            }
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent e) {
            if (e.player.hasCapability(SIZE_CHANGING_CAP, null) && e.phase == TickEvent.Phase.END) {
                ((ISizeChanging)e.player.getCapability(SIZE_CHANGING_CAP, null)).tick();
            }
        }

        @SubscribeEvent
        public void onVisibility(PlayerEvent.Visibility e) {
            if (e.getEntityPlayer().hasCapability(SIZE_CHANGING_CAP, null)) {
                e.modifyVisibility((double)((ISizeChanging)e.getEntityPlayer().getCapability(SIZE_CHANGING_CAP, null)).getSize());
            }
        }

        @SubscribeEvent
        public void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
            if (e.player.hasCapability(SIZE_CHANGING_CAP, null)) {
                ((ISizeChanging)e.player.getCapability(SIZE_CHANGING_CAP, null)).setSizeDirectly(1.0f);
                ((ISizeChanging)e.player.getCapability(SIZE_CHANGING_CAP, null)).syncToAll();
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void pushOutOfBlock(PlayerSPPushOutOfBlocksEvent e) {
            if (((ISizeChanging)e.getEntityPlayer().getCapability(SIZE_CHANGING_CAP, null)).getSize() < 1.0f) {
                e.setCanceled(true);
                EntityPlayer player = e.getEntityPlayer();
                AxisAlignedBB axisalignedbb = e.getEntityBoundingBox();
                float size = ((ISizeChanging)e.getEntityPlayer().getCapability(SIZE_CHANGING_CAP, null)).getSize();
                EventHandler.pushPlayerSPOutOfBlocks(player, player.field_70165_t - (double)player.field_70130_N * 0.35, axisalignedbb.field_72338_b + Math.max(0.125, 0.5 * (double)Math.min(size, 1.0f)), player.field_70161_v + (double)player.field_70130_N * 0.35);
                EventHandler.pushPlayerSPOutOfBlocks(player, player.field_70165_t - (double)player.field_70130_N * 0.35, axisalignedbb.field_72338_b + Math.max(0.125, 0.5 * (double)Math.min(size, 1.0f)), player.field_70161_v - (double)player.field_70130_N * 0.35);
                EventHandler.pushPlayerSPOutOfBlocks(player, player.field_70165_t + (double)player.field_70130_N * 0.35, axisalignedbb.field_72338_b + Math.max(0.125, 0.5 * (double)Math.min(size, 1.0f)), player.field_70161_v - (double)player.field_70130_N * 0.35);
                EventHandler.pushPlayerSPOutOfBlocks(player, player.field_70165_t + (double)player.field_70130_N * 0.35, axisalignedbb.field_72338_b + Math.max(0.125, 0.5 * (double)Math.min(size, 1.0f)), player.field_70161_v + (double)player.field_70130_N * 0.35);
            }
        }

        private static void pushPlayerSPOutOfBlocks(EntityPlayer player, double x, double y, double z) {
            boolean inTranslucentBlock;
            if (player.field_70145_X) {
                return;
            }
            BlockPos blockpos = new BlockPos(x, y, z);
            double d0 = x - (double)blockpos.func_177958_n();
            double d1 = z - (double)blockpos.func_177952_p();
            int entHeight = Math.max((int)Math.ceil(player.field_70131_O), 1);
            boolean bl = inTranslucentBlock = !EventHandler.isHeadspaceFree(player.field_70170_p, blockpos, entHeight);
            if (inTranslucentBlock) {
                int i = -1;
                double d2 = 9999.0;
                if (EventHandler.isHeadspaceFree(player.field_70170_p, blockpos.func_177976_e(), entHeight) && d0 < d2) {
                    d2 = d0;
                    i = 0;
                }
                if (EventHandler.isHeadspaceFree(player.field_70170_p, blockpos.func_177974_f(), entHeight) && 1.0 - d0 < d2) {
                    d2 = 1.0 - d0;
                    i = 1;
                }
                if (EventHandler.isHeadspaceFree(player.field_70170_p, blockpos.func_177978_c(), entHeight) && d1 < d2) {
                    d2 = d1;
                    i = 4;
                }
                if (EventHandler.isHeadspaceFree(player.field_70170_p, blockpos.func_177968_d(), entHeight) && 1.0 - d1 < d2) {
                    d2 = 1.0 - d1;
                    i = 5;
                }
                float f = 0.1f;
                if (i == 0) {
                    player.field_70159_w = -0.1f;
                }
                if (i == 1) {
                    player.field_70159_w = 0.1f;
                }
                if (i == 4) {
                    player.field_70179_y = -0.1f;
                }
                if (i == 5) {
                    player.field_70179_y = 0.1f;
                }
            }
        }

        private static boolean isHeadspaceFree(World world, BlockPos pos, int height) {
            for (int y = 0; y < height; ++y) {
                if (EventHandler.isOpenBlockSpace(world, pos.func_177982_a(0, y, 0))) continue;
                return false;
            }
            return true;
        }

        private static boolean isOpenBlockSpace(World world, BlockPos pos) {
            IBlockState iblockstate = world.func_180495_p(pos);
            return !iblockstate.func_177230_c().isNormalCube(iblockstate, (IBlockAccess)world, pos);
        }
    }
}

