/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.sizechanging.commands;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.sizechanging.capabilities.CapabilitySizeChanging;
import lucraft.mods.lucraftcore.sizechanging.capabilities.ISizeChanging;
import lucraft.mods.lucraftcore.sizechanging.sizechanger.SizeChanger;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandSize
extends CommandBase {
    public String func_71517_b() {
        return "sizechange";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.size.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 3) {
            throw new WrongUsageException("commands.size.usage", new Object[0]);
        }
        if (args.length == 0) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                float size = ((ISizeChanging)player.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).getSize();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("commands.size.yoursize", new Object[]{Float.valueOf(size)}));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.size.notaplayer", new Object[0]));
            }
        } else {
            Entity entity = null;
            float size = 0.0f;
            try {
                entity = CommandSize.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            }
            catch (CommandException e) {
                size = (float)CommandSize.func_175756_a((String)args[0], (double)0.1, (double)16.0);
            }
            if (entity != null) {
                if (!CapabilitySizeChanging.EventHandler.canChangeInSize(entity)) {
                    throw new CommandException("commands.size.wrongentity", new Object[0]);
                }
                if (args.length == 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.size.entitysize", new Object[]{entity.func_145748_c_(), Float.valueOf(((ISizeChanging)entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).getSize())}));
                } else if (args.length > 1 && args.length < 4) {
                    size = (float)CommandSize.func_175756_a((String)args[1], (double)0.1, (double)16.0);
                    if (args.length == 2) {
                        ((ISizeChanging)entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).setSize(size);
                    } else {
                        SizeChanger sizeChanger = CommandSize.parseSizeChanger(args[2]);
                        ((ISizeChanging)entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).setSize(size, sizeChanger);
                    }
                }
            } else {
                if (!(sender instanceof EntityPlayer)) {
                    throw new CommandException("commands.size.notaplayer", new Object[0]);
                }
                EntityPlayer player = (EntityPlayer)sender;
                if (args.length == 2) {
                    SizeChanger sizeChanger = CommandSize.parseSizeChanger(args[1]);
                    ((ISizeChanging)player.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).setSize(size, sizeChanger);
                } else if (args.length == 1) {
                    ((ISizeChanging)player.getCapability(CapabilitySizeChanging.SIZE_CHANGING_CAP, null)).setSize(size);
                } else {
                    throw new WrongUsageException("commands.size.usage", new Object[0]);
                }
            }
        }
    }

    public static SizeChanger parseSizeChanger(String input) throws CommandException {
        SizeChanger sizeChanger = (SizeChanger)SizeChanger.SIZE_CHANGER_REGISTRY.getValue(new ResourceLocation(input));
        if (sizeChanger != null) {
            return sizeChanger;
        }
        throw new CommandException("commands.size.nosizechanger", new Object[0]);
    }

    public List<String> getSizeChangerStrings() {
        ArrayList<String> list = new ArrayList<String>();
        for (SizeChanger sc : SizeChanger.SIZE_CHANGER_REGISTRY.getValuesCollection()) {
            list.add(sc.getRegistryName().toString());
        }
        return list;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandSize.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            try {
                Entity entity = CommandSize.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            }
            catch (CommandException e) {
                return this.getSizeChangerStrings();
            }
        } else if (args.length == 3) {
            try {
                Entity entity = CommandSize.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
                return this.getSizeChangerStrings();
            }
            catch (CommandException commandException) {
                // empty catch block
            }
        }
        return args.length == 0 ? CommandSize.func_71530_a((String[])args, (String[])server.func_71213_z()) : super.func_184883_a(server, sender, args, targetPos);
    }
}

