/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityGenerator;
import lucraft.mods.lucraftcore.superpowers.effects.Effect;
import lucraft.mods.lucraftcore.superpowers.effects.EffectHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JsonSuperpower
extends Superpower {
    public JsonObject jsonOriginal;
    public ITextComponent name;
    public SuperpowerIconType iconType = null;
    public ItemStack iconStack = null;
    public ResourceLocation iconLoc = null;
    public int maxLevel;
    public int capsuleColor;
    public List<AbilityGenerator> abilityGenerators;
    public List<Effect> effects;
    public NBTTagCompound data;

    public JsonSuperpower(String name) {
        super(name);
    }

    @Override
    public String getDisplayName() {
        return this.name.func_150254_d();
    }

    @Override
    public boolean canLevelUp() {
        return this.maxLevel > 0;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public int getCapsuleColor() {
        return this.capsuleColor;
    }

    @Override
    public List<Effect> getEffects() {
        return this.effects;
    }

    @Override
    public NBTTagCompound getData() {
        return this.data;
    }

    @Override
    public Ability.AbilityMap addDefaultAbilities(EntityLivingBase entity, Ability.AbilityMap abilities, Ability.EnumAbilityContext context) {
        for (AbilityGenerator ab : this.abilityGenerators) {
            Ability ability = ab.create(entity, abilities);
            if (ability == null) continue;
            abilities.put(ab.key, ability);
        }
        return abilities;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderIcon(Minecraft mc, Gui gui, int x, int y) {
        if (this.iconType == SuperpowerIconType.ITEM) {
            float zLevel = Minecraft.func_71410_x().func_175599_af().field_77023_b;
            Minecraft.func_71410_x().func_175599_af().field_77023_b = -100.5f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            Minecraft.func_71410_x().func_175599_af().func_175042_a(this.iconStack, 0, 0);
            GlStateManager.func_179121_F();
            Minecraft.func_71410_x().func_175599_af().field_77023_b = zLevel;
        } else if (this.iconType == SuperpowerIconType.TEXTURE) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179152_a((float)0.125f, (float)0.125f, (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.iconLoc);
            gui.func_73729_b(0, 0, 0, 0, 256, 256);
            GlStateManager.func_179121_F();
        }
    }

    public JsonSuperpower deserialize(JsonObject jsonobject) throws Exception {
        this.name = ITextComponent.Serializer.func_150699_a((String)JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"name").toString());
        this.maxLevel = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"max_level", (int)0);
        this.capsuleColor = JsonUtils.func_151208_a((JsonObject)jsonobject, (String)"capsule_color", (int)15073794);
        if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"icon")) {
            JsonObject icon = JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"icon");
            String type = JsonUtils.func_151200_h((JsonObject)icon, (String)"type");
            SuperpowerIconType superpowerIconType = type.equalsIgnoreCase("item") ? SuperpowerIconType.ITEM : (this.iconType = type.equalsIgnoreCase("texture") ? SuperpowerIconType.TEXTURE : null);
            if (this.iconType == SuperpowerIconType.ITEM) {
                this.iconStack = JsonSuperpower.deserializeIcon(JsonUtils.func_152754_s((JsonObject)icon, (String)"item"));
            } else if (this.iconType == SuperpowerIconType.TEXTURE) {
                this.iconLoc = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)icon, (String)"texture"));
            }
        }
        this.abilityGenerators = JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"abilities") ? Ability.parseAbilityGenerators(jsonobject.get("abilities")) : new ArrayList();
        this.effects = new ArrayList<Effect>();
        if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"effects")) {
            JsonArray array = JsonUtils.func_151214_t((JsonObject)jsonobject, (String)"effects");
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                this.effects.add(EffectHandler.makeEffect(obj));
            }
        }
        if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"data")) {
            String s = JsonUtils.func_152754_s((JsonObject)jsonobject, (String)"data").toString();
            this.data = JsonToNBT.func_180713_a((String)s);
        }
        return this;
    }

    private static ItemStack deserializeIcon(JsonObject object) {
        if (!object.has("item")) {
            throw new JsonSyntaxException("Unsupported icon type, currently only items are supported (add 'item' key)");
        }
        Item item = JsonUtils.func_188180_i((JsonObject)object, (String)"item");
        int i = JsonUtils.func_151208_a((JsonObject)object, (String)"data", (int)0);
        ItemStack ret = new ItemStack(item, 1, i);
        ret.func_77982_d(net.minecraftforge.common.util.JsonUtils.readNBT((JsonObject)object, (String)"nbt"));
        return ret;
    }

    public static enum SuperpowerIconType {
        ITEM,
        TEXTURE;

    }
}

