/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lucraft.mods.lucraftcore.LCConfig;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityCommand;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityCommandHeld;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityCommandLoop;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityCommandToggle;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityDamageResistance;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityEnergyBlast;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityEntry;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityFallResistance;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityFirePunch;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityFireResistance;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityFlight;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityGenerator;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityHealing;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityHealth;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityHeld;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityInvisibility;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityJumpBoost;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityKnockbackResistance;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityPotionPunch;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityPunch;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilitySetPunch;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilitySizeChange;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilitySlowfall;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilitySprint;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityStepAssist;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityStrength;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityTeleport;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityToggle;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityTogglePower;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityToughLungs;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityWaterBreathing;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataBarColor;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataBoolean;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataIcon;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataInteger;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataManager;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataTextComponent;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityCondition;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionAbility;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionLevel;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionSuperpower;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainer;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilitySupplier;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.IAbilityProvider;
import lucraft.mods.lucraftcore.superpowers.capabilities.CapabilitySuperpower;
import lucraft.mods.lucraftcore.superpowers.capabilities.ISuperpowerCapability;
import lucraft.mods.lucraftcore.util.abilitybar.AbilityBarHandler;
import lucraft.mods.lucraftcore.util.abilitybar.EnumAbilityBarColor;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="lucraftcore")
public abstract class Ability
implements INBTSerializable<NBTTagCompound> {
    public static IForgeRegistry<AbilityEntry> ABILITY_REGISTRY;
    private static Map<EnumAbilityContext, AbilitySupplier> abilitySupplier;
    public static final AbilityData<Boolean> ENABLED;
    public static final AbilityData<Integer> MAX_COOLDOWN;
    public static final AbilityData<Integer> COOLDOWN;
    public static final AbilityData<Boolean> SHOW_IN_BAR;
    public static final AbilityData<Boolean> HIDDEN;
    public static final AbilityData<ITextComponent> TITLE;
    public static final AbilityData<AbilityDataIcon.Icon> ICON;
    public static final AbilityData<EnumAbilityBarColor> BAR_COLOR;
    protected final EntityLivingBase entity;
    protected final AbilityDataManager dataManager = new AbilityDataManager(this);
    protected int ticks;
    protected AbilityEntry entry;
    public EnumAbilityContext context;
    protected Ability parentAbility;
    protected List<AbilityCondition> conditions = new ArrayList<AbilityCondition>();
    public EnumSync sync = EnumSync.NONE;
    public boolean dirty;
    private String key;

    @SubscribeEvent
    public static void onRegisterNewRegistries(RegistryEvent.NewRegistry e) {
        ABILITY_REGISTRY = new RegistryBuilder().setName(new ResourceLocation("lucraftcore", "ability")).setType(AbilityEntry.class).setIDRange(0, 2048).create();
    }

    @SubscribeEvent
    public static void registerAbilities(RegistryEvent.Register<AbilityEntry> e) {
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityTogglePower.class, new ResourceLocation("lucraftcore", "toggle_power")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityHealth.class, new ResourceLocation("lucraftcore", "health")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityHealing.class, new ResourceLocation("lucraftcore", "healing")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityStrength.class, new ResourceLocation("lucraftcore", "strength")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityPunch.class, new ResourceLocation("lucraftcore", "punch")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilitySprint.class, new ResourceLocation("lucraftcore", "sprint")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityJumpBoost.class, new ResourceLocation("lucraftcore", "jump_boost")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityDamageResistance.class, new ResourceLocation("lucraftcore", "resistance")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityFallResistance.class, new ResourceLocation("lucraftcore", "fall_resistance")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityFireResistance.class, new ResourceLocation("lucraftcore", "fire_resistance")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityStepAssist.class, new ResourceLocation("lucraftcore", "step_assist")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilitySizeChange.class, new ResourceLocation("lucraftcore", "size_change")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityTeleport.class, new ResourceLocation("lucraftcore", "teleport")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityKnockbackResistance.class, new ResourceLocation("lucraftcore", "knockback_resistance")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityPotionPunch.class, new ResourceLocation("lucraftcore", "potion_punch")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilitySlowfall.class, new ResourceLocation("lucraftcore", "slowfall")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityEnergyBlast.class, new ResourceLocation("lucraftcore", "energy_blast")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityFirePunch.class, new ResourceLocation("lucraftcore", "fire_punch")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityFlight.class, new ResourceLocation("lucraftcore", "flight")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityWaterBreathing.class, new ResourceLocation("lucraftcore", "water_breathing")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityToughLungs.class, new ResourceLocation("lucraftcore", "tough_lungs")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityInvisibility.class, new ResourceLocation("lucraftcore", "invisibility")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityCommand.class, new ResourceLocation("lucraftcore", "command")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityCommandLoop.class, new ResourceLocation("lucraftcore", "command_loop")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityCommandToggle.class, new ResourceLocation("lucraftcore", "command_toggle")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilityCommandHeld.class, new ResourceLocation("lucraftcore", "command_held")));
        e.getRegistry().register((IForgeRegistryEntry)new AbilityEntry(AbilitySetPunch.class, new ResourceLocation("lucraftcore", "set_punch")));
    }

    @SideOnly(value=Side.CLIENT)
    public static void generateHtmlFile(File file) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write("<html><head><title>Abilities</title><style>\ntable{font-family:arial, sans-serif;border-collapse:collapse;}\ntd,th{border:1px solid #666666;text-align:left;padding:8px;min-width:45px;}\nth{background-color:#CCCCCC;}\np{margin:0;}\ntr:nth-child(even){background-color:#D8D8D8;}\ntr:nth-child(odd){background-color:#EEEEEE;}\ntd.true{background-color:#72FF85AA;}\ntd.false{background-color:#FF6666AA;}\ntd.other{background-color:#42A3FFAA;}\ntd.error{color:#FF0000;}\nth,td.true,td.false,td.other{text-align:center;}\n</style></head><body>");
            ArrayList<Ability> abilities = new ArrayList<Ability>();
            HashMap<String, List> sorted = new HashMap<String, List>();
            for (AbilityEntry entry : ABILITY_REGISTRY.getValuesCollection()) {
                try {
                    Ability ability = entry.getAbilityClass().getConstructor(EntityLivingBase.class).newInstance(new Object[]{null});
                    abilities.add(ability);
                    String modName = Ability.getModContainerFromId(entry.getRegistryName().func_110624_b()) != null ? Ability.getModContainerFromId(entry.getRegistryName().func_110624_b()).getName() : entry.getRegistryName().func_110624_b();
                    List<Ability> modsAbilities = sorted.containsKey(modName) ? (List)sorted.get(modName) : new ArrayList();
                    modsAbilities.add(ability);
                    sorted.put(modName, modsAbilities);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sorted.forEach((s, l) -> {
                try {
                    bw.write("<h1>" + s + "</h1>\n");
                    bw.write("<ul>\n");
                    for (Ability ability : l) {
                        bw.write("<li><a href=\"#" + ability.getAbilityEntry().getRegistryName().toString() + "\">" + StringUtils.func_76338_a((String)ability.getDisplayName()) + "</a></li>\n");
                    }
                    bw.write("</ul>\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            bw.write("\n");
            for (Ability ability : abilities) {
                String s2;
                String value;
                AbilityEntry entry = ability.getAbilityEntry();
                bw.write("<hr>\n");
                bw.write("<p><h1 id=\"" + entry.getRegistryName().toString() + "\">" + StringUtils.func_76338_a((String)ability.getDisplayName()) + "</h1>\n");
                bw.write("<h3>" + entry.getRegistryName().toString() + "</h3>\n");
                bw.write("Type: " + ability.getAbilityType().toString() + "</p><br>\n");
                List<AbilityData<?>> dataList = ability.getDataManager().getSettingData();
                bw.write("<p>Example:<br>\n");
                bw.write("<code>\"example_ability\": {<br>\n");
                bw.write("  \"ability\": \"" + entry.getRegistryName().toString() + "\",<br>\n");
                for (int i = 0; i < dataList.size(); ++i) {
                    AbilityData<?> abilityData = dataList.get(i);
                    value = abilityData.getDisplay(ability.getDataManager().getDefaultValue(abilityData));
                    s2 = abilityData.displayAsString(ability.getDataManager().getDefaultValue(abilityData)) ? "\"" + value.toString() + "\"" : value.toString() + "";
                    bw.write("  \"" + abilityData.getJsonKey() + "\": " + s2 + (i < dataList.size() - 1 ? "," : "") + "<br>\n");
                }
                bw.write("}</code>\n");
                bw.write("<table>\n<tr><th>Setting</th><th>Type</th><th>Default</th><th>Description</th></tr>\n");
                for (AbilityData<?> abilityData : dataList) {
                    value = abilityData.getDisplay(ability.getDataManager().getDefaultValue(abilityData));
                    s2 = abilityData.displayAsString(ability.getDataManager().getDefaultValue(abilityData)) ? "\"" + value.toString() + "\"" : value.toString() + "";
                    bw.write("<tr>\n<td><code>" + abilityData.getJsonKey() + "</code></td>\n<td><code>" + abilityData.getType().getTypeName().substring(abilityData.getType().getTypeName().lastIndexOf(".") + 1) + "</code></td>\n<td><code>" + s2 + "</code></td>\n<td><p>" + (abilityData.getDescription() == null || abilityData.getDescription().isEmpty() ? "/" : abilityData.getDescription()) + "</p>\n</td></tr><br>");
                }
                bw.write("</table>\n\n");
            }
            bw.write("</body></html>");
            bw.close();
            LucraftCore.LOGGER.info("Successfully generated abilities.html!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ModContainer getModContainerFromId(String modid) {
        for (ModContainer container : Loader.instance().getModList()) {
            if (!container.getModId().equals(modid)) continue;
            return container;
        }
        return null;
    }

    public Ability(EntityLivingBase entity) {
        this.entity = entity;
        for (AbilityEntry entries : ABILITY_REGISTRY.getValues()) {
            if (entries.getAbilityClass() != this.getClass()) continue;
            this.entry = entries;
        }
        this.registerData();
        this.ticks = 0;
        if (this.getAbilityType() == AbilityType.ACTION) {
            this.setCooldown(this.getMaxCooldown());
        } else {
            this.setCooldown(0);
        }
    }

    public void init(Map<String, Ability> abilities) {
    }

    public void registerData() {
        this.dataManager.register(ENABLED, false);
        if (this.getAbilityType() != AbilityType.CONSTANT) {
            this.dataManager.register(MAX_COOLDOWN, 0);
            this.dataManager.register(COOLDOWN, 0);
        }
        this.dataManager.register(SHOW_IN_BAR, this.getAbilityType() != AbilityType.CONSTANT);
        this.dataManager.register(HIDDEN, false);
        this.dataManager.register(TITLE, new TextComponentTranslation(this.getTranslationName(), new Object[0]));
        this.dataManager.register(ICON, new AbilityDataIcon.Icon(true));
        this.dataManager.register(BAR_COLOR, EnumAbilityBarColor.LIGHT_GRAY);
    }

    public AbilityDataManager getDataManager() {
        return this.dataManager;
    }

    public <T> Ability setDataValue(AbilityData<T> data, T value) {
        this.dataManager.set(data, value);
        return this;
    }

    public AbilityEntry getAbilityEntry() {
        return this.entry;
    }

    public String getKey() {
        return this.key;
    }

    public String getUnlocalizedName() {
        return ABILITY_REGISTRY.getKey((IForgeRegistryEntry)this.getAbilityEntry()).func_110623_a();
    }

    public String getModId() {
        return ABILITY_REGISTRY.getKey((IForgeRegistryEntry)this.getAbilityEntry()).func_110624_b();
    }

    public String getTranslationName() {
        return this.getModId() + ".abilities." + this.getUnlocalizedName() + ".name";
    }

    public String getTranslationDescription() {
        return this.getModId() + ".abilities." + this.getUnlocalizedName() + ".desc";
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        LCRenderHelper.drawIcon(mc, gui, x, y, 0, 4);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawIcon(Ability ab, Minecraft mc, Gui gui, int x, int y) {
        AbilityDataIcon.Icon icon = ab.getDataManager().get(ICON);
        if (icon.internal) {
            ab.drawIcon(mc, gui, x, y);
        } else if (icon.texture != null) {
            if (!icon.texture.func_110623_a().isEmpty()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)1.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(icon.texture);
                gui.func_73729_b(0, 0, 0, 0, 256, 256);
                GlStateManager.func_179121_F();
            }
        } else if (!icon.stack.func_190926_b()) {
            float zLevel = Minecraft.func_71410_x().func_175599_af().field_77023_b;
            Minecraft.func_71410_x().func_175599_af().field_77023_b = -100.5f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_175042_a(icon.stack, 0, 0);
            GlStateManager.func_179121_F();
            Minecraft.func_71410_x().func_175599_af().field_77023_b = zLevel;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawAdditionalInfo(Minecraft mc, Gui gui, int x, int y) {
        if (this.isEnabled() && (this.getAbilityType() == AbilityType.TOGGLE || this.getAbilityType() == AbilityType.HELD)) {
            mc.field_71446_o.func_110577_a(AbilityBarHandler.Renderer.HUD_TEX);
            mc.field_71456_v.func_73729_b(x + 12, y + 12, 24, 0, 6, 6);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderCooldown() {
        return this.hasCooldown();
    }

    @SideOnly(value=Side.CLIENT)
    public float getCooldownPercentage() {
        return 1.0f - (float)this.getCooldown() / (float)this.getMaxCooldown();
    }

    public String getDisplayName() {
        return this.dataManager.get(TITLE).func_150254_d();
    }

    public String getDisplayDescription() {
        String desc = TextFormatting.UNDERLINE + "" + TextFormatting.BOLD + this.getDisplayName() + "\n" + TextFormatting.RESET + StringHelper.translateToLocal(this.getTranslationDescription());
        if (this.conditions.size() > 0) {
            desc = desc + "\n";
        }
        for (AbilityCondition predicate : this.conditions) {
            ITextComponent conditionText = new TextComponentString(TextFormatting.DARK_GRAY + " - ").func_150257_a(predicate.getDisplayText().func_150259_f().func_150255_a(new Style().func_150238_a(predicate.test(this) ? TextFormatting.GREEN : TextFormatting.RED)));
            desc = desc + "\n" + conditionText.func_150254_d();
        }
        return desc;
    }

    public boolean isUnlocked() {
        if (this.conditions != null) {
            for (AbilityCondition condition : this.conditions) {
                if (condition.test(this)) continue;
                return false;
            }
        }
        return this.getParentAbility() == null || !(this.getParentAbility() instanceof AbilityToggle) && !(this.getParentAbility() instanceof AbilityHeld) || this.getParentAbility().isEnabled();
    }

    public boolean isEnabled() {
        if (this.getAbilityType() == AbilityType.ACTION) {
            return false;
        }
        return this.dataManager.get(ENABLED);
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            this.dataManager.set(ENABLED, enabled);
        }
    }

    public Ability getParentAbility() {
        return this.parentAbility;
    }

    public Ability setParentAbility(Ability ability) {
        this.parentAbility = ability;
        return this;
    }

    public Ability addCondition(AbilityCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public List<AbilityCondition> getConditions() {
        return this.conditions;
    }

    public boolean hasCooldown() {
        return this.dataManager.has(MAX_COOLDOWN) && this.dataManager.get(MAX_COOLDOWN) > 0;
    }

    public int getCooldown() {
        if (!this.dataManager.has(MAX_COOLDOWN)) {
            return 0;
        }
        return MathHelper.func_76125_a((int)this.dataManager.get(COOLDOWN), (int)0, (int)this.getMaxCooldown());
    }

    public void setCooldown(int cooldown) {
        if (this.dataManager.has(MAX_COOLDOWN)) {
            this.dataManager.set(COOLDOWN, MathHelper.func_76125_a((int)cooldown, (int)0, (int)this.getMaxCooldown()));
        }
    }

    public int getMaxCooldown() {
        if (!this.dataManager.has(MAX_COOLDOWN)) {
            return 0;
        }
        return this.dataManager.get(MAX_COOLDOWN);
    }

    public Ability setMaxCooldown(int maxCooldown) {
        if (!this.dataManager.has(MAX_COOLDOWN)) {
            return this;
        }
        this.dataManager.set(MAX_COOLDOWN, maxCooldown);
        if (this.getAbilityType() == AbilityType.ACTION) {
            this.setCooldown(this.getMaxCooldown());
        } else {
            this.setCooldown(0);
        }
        return this;
    }

    public int getTicks() {
        return this.ticks;
    }

    public boolean isCoolingdown() {
        return this.hasCooldown() && this.getCooldown() > 0 && (this.getAbilityType() != AbilityType.ACTION || !this.isEnabled());
    }

    public abstract AbilityType getAbilityType();

    public boolean isHidden() {
        return this.dataManager.get(HIDDEN);
    }

    public void setHidden(boolean hidden) {
        this.dataManager.set(HIDDEN, hidden);
    }

    public Ability setCustomTitle(ITextComponent title) {
        this.dataManager.set(TITLE, title);
        return this;
    }

    public void markDirty() {
        this.dirty = true;
    }

    public abstract void onUpdate();

    public void firstTick() {
    }

    public void updateTick() {
    }

    public void lastTick() {
    }

    public boolean action() {
        return false;
    }

    public abstract void onKeyPressed();

    public abstract void onKeyReleased();

    public boolean showInAbilityBar() {
        return this.dataManager.get(SHOW_IN_BAR);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Ability", this.getAbilityEntry().getRegistryName().toString());
        nbt.func_74782_a("Data", (NBTBase)this.dataManager.serializeNBT());
        nbt.func_74768_a("Ticks", this.ticks);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.dataManager.deserializeNBT(nbt.func_74775_l("Data"));
        this.ticks = nbt.func_74762_e("Ticks");
    }

    public NBTTagCompound serializeNBTSync() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Data", (NBTBase)this.dataManager.serializeNBTSync());
        nbt.func_74768_a("Ticks", this.ticks);
        return nbt;
    }

    public void deserializeNBTSync(NBTTagCompound nbt) {
        this.dataManager.deserializeNBTSync(nbt.func_74775_l("Data"));
        this.ticks = nbt.func_74762_e("Ticks");
    }

    public void onAttacked(LivingAttackEvent e) {
    }

    public void onEntityHurt(LivingHurtEvent e) {
    }

    public void onHurt(LivingHurtEvent e) {
    }

    public void onAttackEntity(AttackEntityEvent e) {
    }

    public void onBreakSpeed(PlayerEvent.BreakSpeed e) {
    }

    public void readFromAddonPack(JsonObject data, AbilityMap abilities) {
        for (AbilityData<?> abilityData : this.dataManager.getData()) {
            this.dataManager.set(abilityData, abilityData.parseValue(data, this.dataManager.getDefaultValue(abilityData)));
        }
        if (JsonUtils.func_151204_g((JsonObject)data, (String)"required_level")) {
            this.addCondition(new AbilityConditionLevel(JsonUtils.func_151203_m((JsonObject)data, (String)"required_level")));
        }
        if (JsonUtils.func_151204_g((JsonObject)data, (String)"required_ability")) {
            for (Ability ab : abilities.values()) {
                if (!ab.key.equals(JsonUtils.func_151200_h((JsonObject)data, (String)"required_ability"))) continue;
                this.addCondition(new AbilityConditionAbility(ab));
            }
        }
        if (JsonUtils.func_151204_g((JsonObject)data, (String)"required_superpower")) {
            this.addCondition(new AbilityConditionSuperpower((Superpower)SuperpowerHandler.SUPERPOWER_REGISTRY.getValue(new ResourceLocation(JsonUtils.func_151200_h((JsonObject)data, (String)"required_superpower")))));
        }
        if (JsonUtils.func_151204_g((JsonObject)data, (String)"parent_ability")) {
            for (Ability ab : abilities.values()) {
                if (!ab.key.equals(JsonUtils.func_151200_h((JsonObject)data, (String)"parent_ability"))) continue;
                this.setParentAbility(ab);
            }
        }
        if (JsonUtils.func_151204_g((JsonObject)data, (String)"conditions")) {
            JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)data, (String)"conditions");
            for (int i = 0; i < jsonArray.size(); ++i) {
                AbilityCondition condition = AbilityCondition.ConditionFactory.parseCondition(jsonArray.get(i).getAsJsonObject(), this, abilities);
                if (condition == null) continue;
                this.addCondition(condition);
            }
        }
    }

    @Deprecated
    public static <T extends Ability> T getAbilityFromClass(List<Ability> list, Class<T> abilityClass) {
        for (Ability ab : list) {
            if (ab.getClass() != abilityClass) continue;
            return (T)ab;
        }
        return null;
    }

    public static <T extends Ability> List<T> getAbilitiesFromClass(List<Ability> list, Class<T> abilityClass) {
        ArrayList<Ability> abilities = new ArrayList<Ability>();
        for (Ability ab : list) {
            if (ab.getClass() != abilityClass) continue;
            abilities.add(ab);
        }
        return abilities;
    }

    public static List<Ability> getAbilities(EntityLivingBase entity) {
        ArrayList<Ability> abilities = new ArrayList<Ability>();
        for (EnumAbilityContext context : EnumAbilityContext.values()) {
            AbilityContainer container = ((ISuperpowerCapability)entity.getCapability(CapabilitySuperpower.SUPERPOWER_CAP, null)).getAbilityContainer(context);
            if (container == null) continue;
            abilities.addAll(container.getAbilities());
        }
        return abilities;
    }

    public static boolean hasAbility(EntityLivingBase entity, Class<? extends Ability> ability) {
        for (Ability ab : Ability.getAbilities(entity)) {
            if (ab.getClass() != ability) continue;
            return true;
        }
        return false;
    }

    public static AbilityEntry getAbilityEntryFromClass(Class<? extends Ability> clazz) {
        for (AbilityEntry entries : ABILITY_REGISTRY.getValues()) {
            if (!entries.getAbilityClass().equals(clazz)) continue;
            return entries;
        }
        return null;
    }

    public static boolean isAbilityEnabled(Ability ability) {
        return Ability.isAbilityEnabled(ability.getClass());
    }

    public static boolean isAbilityEnabled(Class<? extends Ability> clz) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (String s : LCConfig.superpowers.disabledAbilities) {
            list.add(new ResourceLocation(s));
        }
        return !list.contains(ABILITY_REGISTRY.getKey((IForgeRegistryEntry)Ability.getAbilityEntryFromClass(clz)));
    }

    public static void addAbilityContext(String name) {
        EnumHelper.addEnum(EnumAbilityContext.class, (String)name, (Class[])new Class[0], (Object[])new Object[0]);
    }

    public static void registerSupplier(EnumAbilityContext context, Function<EntityLivingBase, IAbilityProvider> providerSupplier, AbilitySupplier.AbilityContainerFactory containerFactory) {
        abilitySupplier.put(context, new AbilitySupplier(providerSupplier, containerFactory));
    }

    public static AbilitySupplier getAbilitySupplier(EnumAbilityContext context) {
        return abilitySupplier.get((Object)context);
    }

    public static IAbilityProvider getAbilityProvider(EntityLivingBase entity, EnumAbilityContext context) {
        return abilitySupplier.containsKey((Object)context) ? Ability.abilitySupplier.get((Object)((Object)context)).providerSupplier.apply(entity) : null;
    }

    public static AbilityContainer getAbilityContainer(EnumAbilityContext context, EntityLivingBase entity) {
        return ((ISuperpowerCapability)entity.getCapability(CapabilitySuperpower.SUPERPOWER_CAP, null)).getAbilityContainer(context);
    }

    public static List<AbilityGenerator> parseAbilityGenerators(JsonElement element) {
        ArrayList<AbilityGenerator> list = new ArrayList<AbilityGenerator>();
        if (element.isJsonArray()) {
            JsonArray array = (JsonArray)element;
            for (int i = 0; i < array.size(); ++i) {
                if (!(array.get(i) instanceof JsonObject)) continue;
                JsonObject o = (JsonObject)array.get(i);
                ResourceLocation loc = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)o, (String)"ability"));
                list.add(new AbilityGenerator(loc, Ability.generateAbilityKey(loc, list), o));
            }
        } else if (element.isJsonObject()) {
            JsonObject object = (JsonObject)element;
            object.entrySet().forEach(e -> {
                if (e.getValue() instanceof JsonObject) {
                    JsonObject o = (JsonObject)e.getValue();
                    ResourceLocation loc = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)o, (String)"ability"));
                    list.add(new AbilityGenerator(loc, (String)e.getKey(), o));
                }
            });
        }
        return list;
    }

    private static String generateAbilityKey(ResourceLocation abilityLoc, List<AbilityGenerator> list) {
        String name = abilityLoc.func_110623_a();
        boolean inList = true;
        while (inList) {
            inList = false;
            for (AbilityGenerator generator : list) {
                if (!generator.key.equalsIgnoreCase(name)) continue;
                inList = true;
                name = name + "_";
            }
        }
        return name;
    }

    static {
        abilitySupplier = new HashMap<EnumAbilityContext, AbilitySupplier>();
        ENABLED = new AbilityDataBoolean("enabled").disableSaving();
        MAX_COOLDOWN = new AbilityDataInteger("max_cooldown").disableSaving().setSyncType(EnumSync.SELF).enableSetting("cooldown", "Maximum cooldown for using this ability");
        COOLDOWN = new AbilityDataInteger("cooldown").setSyncType(EnumSync.SELF);
        SHOW_IN_BAR = new AbilityDataBoolean("show_in_bar").disableSaving().setSyncType(EnumSync.SELF).enableSetting("show_in_bar", "Determines if this ability should be displayed in the ability bar");
        HIDDEN = new AbilityDataBoolean("hidden").setSyncType(EnumSync.SELF);
        TITLE = new AbilityDataTextComponent("title").disableSaving().setSyncType(EnumSync.SELF).enableSetting("title", "Allows you to set a custom title for this ability");
        ICON = new AbilityDataIcon("icon").disableSaving().setSyncType(EnumSync.SELF).enableSetting("icon", "Lets you customize the icon for the ability");
        BAR_COLOR = new AbilityDataBarColor("bar_color").disableSaving().setSyncType(EnumSync.SELF).enableSetting("bar_color", "Lets you choose the color of the ability bar frame for this ability. Available options: " + AbilityDataBarColor.values());
    }

    public static class AbilityMap
    extends LinkedHashMap<String, Ability> {
        @Override
        public Ability put(String key, Ability value) {
            value.key = key;
            return super.put(key, value);
        }
    }

    public static enum EnumAbilityContext {
        SUPERPOWER,
        SUIT,
        COMBAT,
        MAIN_HAND,
        OFF_HAND;


        public static EnumAbilityContext fromString(String name) {
            for (EnumAbilityContext context : EnumAbilityContext.values()) {
                if (!context.toString().equals(name)) continue;
                return context;
            }
            return null;
        }
    }

    public static enum AbilityType {
        ACTION,
        HELD,
        TOGGLE,
        CONSTANT;

    }
}

