/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.abilities.supplier;

import java.util.UUID;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainer;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.IAbilityProvider;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;

public class AbilityContainerItem
extends AbilityContainer {
    public final EntityEquipmentSlot slot;
    protected ItemStack stack = ItemStack.field_190927_a.func_77946_l();
    private ItemStack cacheStack = ItemStack.field_190927_a.func_77946_l();

    public AbilityContainerItem(EntityLivingBase entity, Ability.EnumAbilityContext context, EntityEquipmentSlot slot) {
        super(entity, context);
        this.slot = slot;
    }

    @Override
    public void onUpdate() {
        ItemStack currentStack = this.getItemStackIfProvider();
        if (!currentStack.func_190926_b()) {
            if (!currentStack.func_77942_o()) {
                currentStack.func_77982_d(new NBTTagCompound());
            }
            if (!currentStack.func_77978_p().func_74764_b("AbilityUUID")) {
                currentStack.func_77978_p().func_74782_a("AbilityUUID", (NBTBase)NBTUtil.func_186862_a((UUID)UUID.randomUUID()));
            }
        }
        if (this.stack.func_190926_b() != currentStack.func_190926_b() || !currentStack.func_190926_b() && this.stack.func_77942_o() && !NBTUtil.func_186860_b((NBTTagCompound)currentStack.func_77978_p().func_74775_l("AbilityUUID")).equals(NBTUtil.func_186860_b((NBTTagCompound)this.stack.func_77978_p().func_74775_l("AbilityUUID")))) {
            this.cacheStack = currentStack;
            this.switchProvider(currentStack.func_190926_b() ? null : (IAbilityProvider)currentStack.func_77973_b());
        }
        boolean dirty = false;
        for (Ability ab : this.getAbilities()) {
            ab.onUpdate();
            if (ab.sync != null) {
                this.sync = this.sync.add(ab.sync);
                ab.sync = EnumSync.NONE;
            }
            if (!ab.dirty) continue;
            dirty = dirty || ab.dirty;
            ab.dirty = false;
        }
        if (dirty) {
            this.save();
        }
        if (this.sync != EnumSync.NONE) {
            this.sync();
            this.sync = EnumSync.NONE;
        }
    }

    @Override
    public void switchProvider(IAbilityProvider provider) {
        for (Ability ab : this.getAbilities()) {
            if (!ab.isUnlocked()) continue;
            ab.lastTick();
        }
        if (this.provider != null && !this.stack.func_190926_b()) {
            this.save();
        }
        this.provider = provider;
        this.stack = this.cacheStack;
        this.cacheStack = ItemStack.field_190927_a;
        if (this.provider != null && !this.stack.func_190926_b()) {
            this.abilities = this.filterAbilities(provider.addDefaultAbilities(this.entity, new Ability.AbilityMap(), this.context));
            this.load();
        } else {
            this.abilities.clear();
        }
        this.sync = this.sync.add(EnumSync.EVERYONE);
    }

    public ItemStack getItemStackIfProvider() {
        ItemStack stack = this.entity.func_184582_a(this.slot);
        return stack.func_77973_b() instanceof IAbilityProvider ? stack : ItemStack.field_190927_a;
    }

    @Override
    public void save() {
        if (!this.stack.func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
            if (!this.stack.func_77942_o()) {
                this.stack.func_77982_d(new NBTTagCompound());
            }
            this.stack.func_77978_p().func_74782_a("ItemAbilities", (NBTBase)this.serializeNBT());
        }
    }

    @Override
    public void load() {
        if (!this.stack.func_190926_b()) {
            NBTTagCompound nbt = this.stack.func_77942_o() ? this.stack.func_77978_p() : new NBTTagCompound();
            this.deserializeNBT(nbt.func_74775_l("ItemAbilities"));
        }
    }
}

