/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.render;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import lucraft.mods.lucraftcore.superpowers.Superpower;
import lucraft.mods.lucraftcore.superpowers.SuperpowerHandler;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.effects.EffectFlickering;
import lucraft.mods.lucraftcore.superpowers.effects.EffectGlow;
import lucraft.mods.lucraftcore.superpowers.effects.EffectGlowingHand;
import lucraft.mods.lucraftcore.superpowers.effects.EffectHandler;
import lucraft.mods.lucraftcore.superpowers.effects.EffectSkinOverlay;
import lucraft.mods.lucraftcore.superpowers.effects.EffectVibrating;
import lucraft.mods.lucraftcore.superpowers.render.RenderSuperpowerLayerEvent;
import lucraft.mods.lucraftcore.superpowers.render.SuperpowerRenderer;
import lucraft.mods.lucraftcore.superpowers.suitsets.SuitSet;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SuperpowerRenderLayer
implements LayerRenderer<EntityPlayer> {
    public RenderPlayer renderer;
    public static Minecraft mc = Minecraft.func_71410_x();
    public static final ResourceLocation WHITE_TEX = new ResourceLocation("lucraftcore", "textures/models/white.png");

    public SuperpowerRenderLayer(RenderPlayer renderer) {
        this.renderer = renderer;
    }

    public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelPlayer model;
        if (player.func_70660_b(MobEffects.field_76441_p) != null) {
            return;
        }
        Superpower superpower = SuperpowerHandler.getSuperpower((EntityLivingBase)player);
        if (superpower != null && superpower.getPlayerRenderer() != null) {
            superpower.getPlayerRenderer().onRenderPlayer((RenderLivingBase<?>)this.renderer, mc, player, superpower, Ability.getAbilityContainer(Ability.EnumAbilityContext.SUPERPOWER, (EntityLivingBase)player), limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
        }
        for (EffectSkinOverlay effects : EffectHandler.getEffectsByClass(player, EffectSkinOverlay.class)) {
            if (!EffectHandler.canEffectBeDisplayed(effects, player)) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            model = new ModelPlayer(effects.size, PlayerHelper.hasSmallArms(player));
            model.func_178686_a((ModelBase)this.renderer.func_177087_b());
            Minecraft.func_71410_x().field_71446_o.func_110577_a(effects.texture);
            if (effects.glow) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                LCRenderHelper.setLightmapTextureCoords(240.0f, 240.0f);
            }
            SuperpowerRenderer.overrideSkin = false;
            model.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            SuperpowerRenderer.overrideSkin = true;
            if (effects.glow) {
                GlStateManager.func_179145_e();
                GlStateManager.func_179084_k();
                LCRenderHelper.restoreLightmapTextureCoords();
            }
            GlStateManager.func_179121_F();
        }
        SuperpowerRenderLayer.mc.field_71446_o.func_110577_a(WHITE_TEX);
        for (EffectGlow glow : EffectHandler.getEffectsByClass(player, EffectGlow.class)) {
            if (!EffectHandler.canEffectBeDisplayed(glow, player)) continue;
            GlStateManager.func_179094_E();
            model = new ModelPlayer(glow.size, PlayerHelper.hasSmallArms(player));
            model.field_78091_s = false;
            model.func_178686_a((ModelBase)this.renderer.func_177087_b());
            LCRenderHelper.setLightmapTextureCoords(240.0f, 240.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)((float)glow.color.getRed() / 255.0f), (float)((float)glow.color.getGreen() / 255.0f), (float)((float)glow.color.getBlue() / 255.0f), (float)glow.opacity);
            SuperpowerRenderer.overrideSkin = false;
            model.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            SuperpowerRenderer.overrideSkin = true;
            LCRenderHelper.restoreLightmapTextureCoords();
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (EffectVibrating.isVibrating((Entity)player) && !SuitSet.hasSuitSetOn((EntityLivingBase)player)) {
            SuperpowerRenderLayer.mc.field_71446_o.func_110577_a(this.renderer.func_110775_a((AbstractClientPlayer)player));
            for (int i = 0; i < 10; ++i) {
                GlStateManager.func_179094_E();
                Random rand = new Random();
                GlStateManager.func_179109_b((float)((rand.nextFloat() - 0.5f) / 15.0f), (float)0.0f, (float)((rand.nextFloat() - 0.5f) / 15.0f));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                this.renderer.func_177087_b().func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                GlStateManager.func_179121_F();
            }
        }
        List<EffectFlickering> flickerings = EffectHandler.getEffectsByClass(player, EffectFlickering.class);
        for (int i = 0; i < flickerings.size(); ++i) {
            EffectFlickering flicker = flickerings.get(i);
            LCRenderHelper.setupRenderLightning();
            GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
            if (EffectHandler.canEffectBeDisplayed(flicker, player)) {
                AxisAlignedBB box = new AxisAlignedBB((double)(-player.field_70130_N) / 2.0, 0.0, (double)(-player.field_70130_N) / 2.0, (double)player.field_70130_N / 2.0, (double)player.field_70131_O, (double)player.field_70130_N / 2.0);
                float thickness = 0.001f;
                LCRenderHelper.drawRandomLightningCoordsInAABB(thickness, flickerings.get(i).getColor(player), box, new Random(i + player.field_70173_aa / 2));
            }
            LCRenderHelper.finishRenderLightning();
        }
        for (EffectGlowingHand effects : EffectHandler.getEffectsByClass(player, EffectGlowingHand.class)) {
            if (!EffectHandler.canEffectBeDisplayed(effects, player)) continue;
            Color color = effects.color;
            Minecraft mc = Minecraft.func_71410_x();
            Random rand = new Random(2L);
            float f = 0.2f;
            for (int j = 0; j < 2; ++j) {
                LCRenderHelper.setupRenderLightning();
                if (j == 0) {
                    this.renderer.func_177087_b().field_178723_h.func_78794_c(scale);
                } else {
                    this.renderer.func_177087_b().field_178724_i.func_78794_c(scale);
                }
                GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
                GlStateManager.func_179152_a((float)effects.size, (float)effects.size, (float)effects.size);
                GlStateManager.func_179114_b((float)(((float)mc.field_71439_g.field_70173_aa + LCRenderHelper.renderTick) / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                for (int i = 0; i < 30; ++i) {
                    GlStateManager.func_179114_b((float)(((float)mc.field_71439_g.field_70173_aa + LCRenderHelper.renderTick) * (float)i / 70.0f), (float)1.0f, (float)1.0f, (float)0.0f);
                    LCRenderHelper.drawGlowingLine(new Vec3d((double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f)), new Vec3d((double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f), (double)(-f / 2.0f + rand.nextFloat() * f)), 0.1f, color, 0.0f);
                }
                LCRenderHelper.finishRenderLightning();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderSuperpowerLayerEvent(player, this.renderer, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale));
    }

    public boolean func_177142_b() {
        return false;
    }
}

