/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.superpowers.suitsets;

import java.util.List;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.IAbilityProvider;
import lucraft.mods.lucraftcore.superpowers.effects.Effect;
import lucraft.mods.lucraftcore.superpowers.effects.EffectVibrating;
import lucraft.mods.lucraftcore.superpowers.models.ModelBipedSuitSet;
import lucraft.mods.lucraftcore.superpowers.suitsets.ItemSuitSetArmor;
import lucraft.mods.lucraftcore.util.creativetabs.CreativeTabRegistry;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.util.render.ModelCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SuitSet
extends IForgeRegistryEntry.Impl<SuitSet>
implements IAbilityProvider {
    public static final RegistryNamespaced<ResourceLocation, SuitSet> REGISTRY = new RegistryNamespaced();
    private String name;
    protected Item helmet;
    protected Item chestplate;
    protected Item legs;
    protected Item boots;

    public SuitSet(String name) {
        this.name = name;
    }

    public void registerItems(RegistryEvent.Register<Item> e) {
        this.helmet = this.createItem(this, EntityEquipmentSlot.HEAD);
        e.getRegistry().register((IForgeRegistryEntry)this.helmet);
        this.chestplate = this.createItem(this, EntityEquipmentSlot.CHEST);
        e.getRegistry().register((IForgeRegistryEntry)this.chestplate);
        this.legs = this.createItem(this, EntityEquipmentSlot.LEGS);
        e.getRegistry().register((IForgeRegistryEntry)this.legs);
        this.boots = this.createItem(this, EntityEquipmentSlot.FEET);
        e.getRegistry().register((IForgeRegistryEntry)this.boots);
    }

    public ItemSuitSetArmor createItem(SuitSet suitSet, EntityEquipmentSlot slot) {
        return (ItemSuitSetArmor)new ItemSuitSetArmor(suitSet, slot).setRegistryName(suitSet.getRegistryName().func_110624_b(), suitSet.getRegistryName().func_110623_a() + (slot == EntityEquipmentSlot.HEAD ? "_helmet" : (slot == EntityEquipmentSlot.CHEST ? "_chest" : (slot == EntityEquipmentSlot.LEGS ? "_legs" : "_boots"))));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        this.registerModel(this.getHelmet(), EntityEquipmentSlot.HEAD);
        this.registerModel(this.getChestplate(), EntityEquipmentSlot.CHEST);
        this.registerModel(this.getLegs(), EntityEquipmentSlot.LEGS);
        this.registerModel(this.getBoots(), EntityEquipmentSlot.FEET);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, EntityEquipmentSlot slot) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(this.getRegistryName().func_110624_b(), this.getRegistryName().func_110623_a() + "_suit"), slot.toString().toLowerCase()));
        }
    }

    public String getUnlocalizedName() {
        return this.name;
    }

    public boolean canOpenArmor(EntityEquipmentSlot slot) {
        return false;
    }

    public void onArmorToggled(Entity entity, ItemStack stack, EntityEquipmentSlot slot, boolean open) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketCustomSound(SoundEvents.field_187725_r.getRegistryName().toString(), entity.func_184176_by(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0f, 1.0f));
        }
    }

    public String getDisplayName() {
        return StringHelper.translateToLocal(this.getModId().toLowerCase() + ".suit." + this.getUnlocalizedName() + ".name");
    }

    @Deprecated
    public String getModId() {
        return this.getRegistryName().func_110624_b();
    }

    public String getDisplayNameForItem(Item item, ItemStack stack, EntityEquipmentSlot armorType, String origName) {
        return origName;
    }

    public String getArmorTexturePath(ItemStack stack, Entity entity, EntityEquipmentSlot slot, boolean light, boolean smallArms, boolean open) {
        String tex;
        String string = slot == EntityEquipmentSlot.HEAD ? "helmet" : (slot == EntityEquipmentSlot.CHEST ? "chestplate" : (tex = slot == EntityEquipmentSlot.LEGS ? "legs" : "boots"));
        if (slot == EntityEquipmentSlot.CHEST && smallArms) {
            tex = tex + "_smallarms";
        }
        if (this.canOpenArmor(slot) && open) {
            tex = tex + "_open";
        }
        if (light) {
            tex = tex + "_lights";
        }
        return this.getModId() + ":textures/models/armor/" + this.getRegistryName().func_110623_a() + "/" + tex + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(SuitSet suitSet, ItemStack stack, Entity entity, EntityEquipmentSlot slot, boolean light, boolean smallArms, boolean open) {
        String key = suitSet.getRegistryName().toString() + "_" + suitSet.getArmorModelScale(slot) + "_" + suitSet.getArmorTexturePath(stack, entity, slot, false, smallArms, open) + "_" + suitSet.getArmorTexturePath(stack, entity, slot, true, smallArms, open) + "_" + slot.toString() + "_" + smallArms + "_" + EffectVibrating.isVibrating(entity);
        ModelBase model = ModelCache.getModel(key);
        if (model != null && model instanceof ModelBiped) {
            return (ModelBiped)model;
        }
        return (ModelBiped)ModelCache.storeModel(key, (ModelBase)new ModelBipedSuitSet(suitSet.getArmorModelScale(slot), suitSet.getArmorTexturePath(stack, entity, slot, false, smallArms, open), suitSet.getArmorTexturePath(stack, entity, slot, true, smallArms, open), suitSet, slot, smallArms, EffectVibrating.isVibrating(entity)));
    }

    @SideOnly(value=Side.CLIENT)
    public void bindArmorTexture(SuitSet suitSet, Entity entity, float f, float f1, float f2, float f3, float f4, float f5, ResourceLocation normalTex, ResourceLocation glowTex, boolean glow, EntityEquipmentSlot slot, boolean smallArms) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(glow ? glowTex : normalTex);
    }

    public ItemArmor.ArmorMaterial getArmorMaterial(EntityEquipmentSlot slot) {
        return ItemArmor.ArmorMaterial.IRON;
    }

    public boolean hasGlowyThings(EntityLivingBase entity, EntityEquipmentSlot slot) {
        return false;
    }

    public float getGlowOpacity(SuitSet suitSet, EntityLivingBase entity, EntityEquipmentSlot slot) {
        return 1.0f;
    }

    public boolean showInCreativeTab() {
        return this.getCreativeTab() != null;
    }

    public CreativeTabs getCreativeTab() {
        return CreativeTabRegistry.getOrCreateCreativeTab("addon_packs", this.getRepresentativeItem());
    }

    public boolean hasArmorOn(EntityLivingBase entity) {
        boolean hasArmorOn = true;
        if (this.getHelmet() != null && (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() || entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() != this.getHelmet())) {
            hasArmorOn = false;
        }
        if (this.getLegs() != null && (entity.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() || entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() != this.getLegs())) {
            hasArmorOn = false;
        }
        if (this.getBoots() != null && (entity.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b() || entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() != this.getBoots())) {
            hasArmorOn = false;
        }
        return hasArmorOn;
    }

    public Item getHelmet() {
        return this.helmet;
    }

    public Item getChestplate() {
        return this.chestplate;
    }

    public Item getLegs() {
        return this.legs;
    }

    public Item getBoots() {
        return this.boots;
    }

    public ItemStack getRepresentativeItem() {
        return new ItemStack(this.getChestplate());
    }

    public List<Effect> getEffects() {
        return null;
    }

    public NBTTagCompound getData() {
        return null;
    }

    public float getArmorModelScale(EntityEquipmentSlot armorSlot) {
        if (armorSlot == EntityEquipmentSlot.HEAD) {
            return 0.5f;
        }
        if (armorSlot == EntityEquipmentSlot.CHEST || armorSlot == EntityEquipmentSlot.FEET) {
            return 0.252f;
        }
        return 0.25f;
    }

    public boolean hasExtraDescription(ItemStack stack) {
        return this.getExtraDescription(stack) != null && this.getExtraDescription(stack).size() > 0;
    }

    public List<String> getExtraDescription(ItemStack stack) {
        return null;
    }

    public static SuitSet getSuitSet(EntityLivingBase entity) {
        return SuitSet.hasSuitSetOn(entity) ? SuitSet.getSuitSet(entity.func_184582_a(EntityEquipmentSlot.CHEST)) : null;
    }

    @Override
    public Ability.AbilityMap addDefaultAbilities(EntityLivingBase entity, Ability.AbilityMap abilities, Ability.EnumAbilityContext context) {
        return abilities;
    }

    public void onEquip(SuitSet suitSet, EntityLivingBase player) {
    }

    public void onUnequip(SuitSet suitSet, EntityLivingBase player) {
    }

    public void onUpdate(SuitSet suitSet, EntityLivingBase player) {
    }

    public static SuitSet getSuitSet(ItemStack stack) {
        if (stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemSuitSetArmor) {
            return ((ItemSuitSetArmor)stack.func_77973_b()).getSuitSet();
        }
        return null;
    }

    public static boolean hasSuitSetOn(EntityLivingBase entity) {
        if (!entity.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemSuitSetArmor) {
            return ((ItemSuitSetArmor)entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b()).getSuitSet().hasArmorOn(entity);
        }
        return false;
    }

    public ItemStack getRepairItem(ItemStack toRepair) {
        return ItemStack.field_190927_a;
    }

    public boolean getIsRepairable(ItemStack toRepair, ItemStack repair) {
        if (!this.getRepairItem(toRepair).func_190926_b()) {
            return this.getRepairItem(toRepair).func_77973_b() == repair.func_77973_b() && this.getRepairItem(toRepair).func_77952_i() == repair.func_77952_i();
        }
        return false;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
    }
}

