/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.attributes;

import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="lucraftcore")
public class LCAttributes {
    public static final IAttribute STEP_HEIGHT = new RangedAttribute((IAttribute)null, "lucraftcore.stepHeight", 0.5, 0.0, 20.0).func_111117_a("Step Height").func_111112_a(true);
    public static final IAttribute PUNCH_DAMAGE = new RangedAttribute((IAttribute)null, "lucraftcore.extraPunchDamage", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Extra Punch Damage").func_111112_a(true);
    public static final IAttribute FALL_RESISTANCE = new RangedAttribute((IAttribute)null, "lucraftcore.fallResistance", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Fall Resistance").func_111112_a(true);
    public static final IAttribute JUMP_HEIGHT = new RangedAttribute((IAttribute)null, "lucraftcore.jumpHeight", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Jump Height").func_111112_a(true);
    public static final IAttribute SPRINT_SPEED = new RangedAttribute((IAttribute)null, "lucraftcore.sprintSpeed", 0.0, 0.0, Double.MAX_VALUE).func_111117_a("Sprint Speed").func_111112_a(true);
    public static final UUID sprintUUID = UUID.fromString("11faf62f-c271-4601-809e-83d982687b69");
    public static float stepHeight;

    @SubscribeEvent
    public static void onConstruct(EntityEvent.EntityConstructing e) {
        if (e.getEntity() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)e.getEntity();
            if (((EntityLivingBase)e.getEntity()).func_110140_aT().func_111152_a(STEP_HEIGHT.func_111108_a()) == null) {
                entity.func_110140_aT().func_111150_b(STEP_HEIGHT).func_111128_a(1.0);
            }
            if (((EntityLivingBase)e.getEntity()).func_110140_aT().func_111152_a(PUNCH_DAMAGE.func_111108_a()) == null) {
                entity.func_110140_aT().func_111150_b(PUNCH_DAMAGE);
            }
            if (((EntityLivingBase)e.getEntity()).func_110140_aT().func_111152_a(FALL_RESISTANCE.func_111108_a()) == null) {
                entity.func_110140_aT().func_111150_b(FALL_RESISTANCE);
            }
            if (((EntityLivingBase)e.getEntity()).func_110140_aT().func_111152_a(JUMP_HEIGHT.func_111108_a()) == null) {
                entity.func_110140_aT().func_111150_b(JUMP_HEIGHT);
            }
            if (((EntityLivingBase)e.getEntity()).func_110140_aT().func_111152_a(SPRINT_SPEED.func_111108_a()) == null) {
                entity.func_110140_aT().func_111150_b(SPRINT_SPEED);
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent e) {
        for (AttributeModifier modifier : e.getEntityLiving().func_110140_aT().func_111151_a(FALL_RESISTANCE).func_111122_c()) {
            if (modifier.func_111169_c() != 0) continue;
            e.setDistance((float)((double)e.getDistance() - modifier.func_111164_d()));
        }
        for (AttributeModifier modifier : e.getEntityLiving().func_110140_aT().func_111151_a(FALL_RESISTANCE).func_111122_c()) {
            if (modifier.func_111169_c() != 1) continue;
            e.setDistance((float)((double)e.getDistance() * modifier.func_111164_d()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDamage(LivingHurtEvent e) {
        if (e.getSource() instanceof EntityDamageSource && ((EntityDamageSource)e.getSource()).func_76364_f() != null && ((EntityDamageSource)e.getSource()).func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase player = (EntityLivingBase)((EntityDamageSource)e.getSource()).func_76364_f();
            float f = e.getAmount();
            if (!player.func_184614_ca().func_190926_b()) {
                return;
            }
            for (AttributeModifier modifier : player.func_110140_aT().func_111151_a(PUNCH_DAMAGE).func_111122_c()) {
                if (modifier.func_111169_c() != 0) continue;
                f = (float)((double)f + modifier.func_111164_d());
            }
            for (AttributeModifier modifier : player.func_110140_aT().func_111151_a(PUNCH_DAMAGE).func_111122_c()) {
                if (modifier.func_111169_c() != 1) continue;
                f = (float)((double)f * modifier.func_111164_d());
            }
            e.setAmount(f);
        }
    }

    @SubscribeEvent
    public static void onFall(LivingEvent.LivingJumpEvent e) {
        if (!e.getEntityLiving().func_70093_af()) {
            float f = 0.0f;
            for (AttributeModifier modifier : e.getEntityLiving().func_110140_aT().func_111151_a(JUMP_HEIGHT).func_111122_c()) {
                if (modifier.func_111169_c() != 0) continue;
                f = (float)((double)f + modifier.func_111164_d());
            }
            for (AttributeModifier modifier : e.getEntityLiving().func_110140_aT().func_111151_a(JUMP_HEIGHT).func_111122_c()) {
                if (modifier.func_111169_c() != 1) continue;
                if (f == 0.0f) {
                    f = 1.0f;
                }
                f = (float)((double)f * modifier.func_111164_d());
            }
            e.getEntityLiving().field_70181_x += 0.1 * (double)f;
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (e.player.field_70173_aa > 20 && e.player.field_70170_p.field_72995_K) {
                e.player.field_70138_W = stepHeight;
            }
            return;
        }
        if (e.player.field_70173_aa > 20 && e.player.field_70170_p.field_72995_K) {
            stepHeight = e.player.field_70138_W;
            for (AttributeModifier mod : e.player.func_110140_aT().func_111151_a(STEP_HEIGHT).func_111130_a(0)) {
                e.player.field_70138_W = (float)((double)e.player.field_70138_W + mod.func_111164_d());
            }
            for (AttributeModifier mod : e.player.func_110140_aT().func_111151_a(STEP_HEIGHT).func_111130_a(1)) {
                e.player.field_70138_W = (float)((double)e.player.field_70138_W * mod.func_111164_d());
            }
            for (AttributeModifier mod : e.player.func_110140_aT().func_111151_a(STEP_HEIGHT).func_111130_a(2)) {
                e.player.field_70138_W = (float)((double)e.player.field_70138_W * mod.func_111164_d());
            }
        }
        e.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_188479_b(sprintUUID);
        if (e.player.func_70051_ag() && e.player.func_110140_aT().func_111151_a(SPRINT_SPEED).func_111122_c().size() > 0) {
            double amount = 1.0;
            for (AttributeModifier mod : e.player.func_110140_aT().func_111151_a(SPRINT_SPEED).func_111122_c()) {
                amount += mod.func_111164_d();
            }
            e.player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(sprintUUID, "Sprint modifier", amount, 1));
        }
    }
}

