/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.fluids;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class LCFluidUtil {
    public static ItemStack transferFluidFromItemToTank(ItemStack fluidContainer, FluidTank fluidTank, ItemStackHandler itemHandler) {
        FluidActionResult result;
        if (!fluidContainer.func_190926_b() && LCFluidUtil.isDrainableFilledContainer(fluidContainer) && (fluidTank.getFluid() == null || fluidTank.getFluid().isFluidEqual(FluidUtil.getFluidContained((ItemStack)fluidContainer))) && (result = FluidUtil.tryEmptyContainerAndStow((ItemStack)fluidContainer, (IFluidHandler)fluidTank, (IItemHandler)itemHandler, (int)fluidTank.getCapacity(), null, (boolean)true)).isSuccess()) {
            return result.getResult();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack transferFluidFromTankToItem(ItemStack fluidContainer, FluidTank fluidTank, ItemStackHandler itemHandler) {
        FluidActionResult result;
        if (!fluidContainer.func_190926_b() && LCFluidUtil.isFillableEmptyContainer(fluidContainer) && fluidTank.getFluid() != null && fluidTank.getFluid().amount > 0 && (result = FluidUtil.tryFillContainerAndStow((ItemStack)fluidContainer, (IFluidHandler)fluidTank, (IItemHandler)itemHandler, (int)fluidTank.getCapacity(), null, (boolean)true)).isSuccess()) {
            return result.getResult();
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isDrainableFilledContainer(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents != null && contents.amount != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFillableEmptyContainer(ItemStack empty) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents == null || contents.amount < properties.getCapacity()) continue;
            return false;
        }
        return true;
    }

    public static FluidStack parseFromJson(JsonObject jsonObject) {
        if (!FluidRegistry.isFluidRegistered((String)JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid"))) {
            throw new RuntimeException("Fluid '" + JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid") + "' is not registered!");
        }
        Fluid fluid = FluidRegistry.getFluid((String)JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid"));
        int amount = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"amount");
        return new FluidStack(fluid, amount);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getFormattedFluidInfo(int amount, int capacity) {
        return StringHelper.translateToLocal("lucraftcore.info.fluidtank_display", amount, capacity, "mB");
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getFormattedFluidInfo(FluidTank fluidTank) {
        ArrayList<String> list = new ArrayList<String>();
        if (fluidTank.getFluid() != null) {
            list.add(fluidTank.getFluid().getLocalizedName());
        }
        list.add(TextFormatting.GRAY + StringHelper.translateToLocal("lucraftcore.info.fluidtank_display", fluidTank.getFluidAmount(), fluidTank.getCapacity(), "mB"));
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTooltip(FluidTank fluidTank, GuiContainer gui, int x, int y, int width, int height, int mouseX, int mouseY) {
        if (mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height) {
            gui.func_146283_a(LCFluidUtil.getFormattedFluidInfo(fluidTank), mouseX + 10, mouseY);
        }
    }
}

