/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util.updatechecker;

import java.io.IOException;
import java.net.URL;
import java.util.Scanner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class UpdateChecker {
    protected String currentVersion;
    protected String prefix;
    protected String website;
    protected String updateFile;
    protected String newestVersion;
    protected String updateStatus = "NULL";
    protected boolean show = false;

    public UpdateChecker(String currentVersion, String prefix, String website, String updateFile) {
        this.currentVersion = currentVersion;
        this.prefix = prefix;
        this.website = website;
        this.updateFile = updateFile;
        this.setNewestVersion();
        if (this.newestVersion != null && !this.newestVersion.equalsIgnoreCase(currentVersion)) {
            this.show = true;
            this.updateStatus = "New version is available!";
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setNewestVersion() {
        try {
            URL url = new URL(this.updateFile);
            Scanner s = new Scanner(url.openStream());
            this.newestVersion = s.next();
            s.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onWorldJoin(PlayerEvent.PlayerLoggedInEvent e) {
        if (this.show) {
            this.sendInfoMessage(e.player, "lucraftcore.info.newupdateavailable");
            this.sendDownloadMessageToPlayer(e.player);
            this.show = false;
        }
    }

    public void sendDownloadMessageToPlayer(EntityPlayer player) {
        TextComponentString chat = new TextComponentString("");
        Style download = new Style();
        download.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("lucraftcore.info.clickdownload", new Object[0])));
        chat.func_150258_a(TextFormatting.DARK_GREEN + "[");
        Style data = download.func_150232_l();
        data.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, this.website));
        chat.func_150257_a(new TextComponentString(TextFormatting.GREEN + "Download").func_150255_a(data));
        chat.func_150258_a(TextFormatting.DARK_GREEN + "] ");
        chat.func_150257_a((ITextComponent)new TextComponentString(TextFormatting.GRAY + this.newestVersion));
        player.func_145747_a((ITextComponent)chat);
    }

    public void sendInfoMessage(EntityPlayer player, String msg) {
        TextComponentString text = new TextComponentString(this.prefix + " " + TextFormatting.GRAY);
        text.func_150257_a((ITextComponent)new TextComponentTranslation(msg, new Object[0]));
        player.func_145747_a((ITextComponent)text);
    }
}

