/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.items;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.LucraftCore;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.util.items.ItemBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInjection
extends ItemBase {
    private static HashMap<ResourceLocation, Injection> injections = new HashMap();
    private static HashMap<Injection, ResourceLocation> injectionsLocs = new HashMap();

    public ItemInjection(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77637_a(LucraftCore.CREATIVE_TAB);
        this.func_185043_a(new ResourceLocation("injection"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                Injection injection = ItemInjection.getInjection(stack);
                return injection == null ? 0.0f : 1.0f;
            }
        });
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase playerIn) {
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer && timeLeft <= 71980) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            Injection injection = ItemInjection.getInjection(stack);
            if (injection == null) {
                int chance = 0;
                Injection in = null;
                for (Injection i : injections.values()) {
                    int x = i.priorityForRemoving(player, stack);
                    if (x <= chance) continue;
                    chance = x;
                    in = i;
                }
                if (chance > 0 && in != null) {
                    ItemInjection.setInjection(in.removeFromPlayer(player, stack), in);
                }
            } else {
                int chance = injection.chanceForInjection(player, stack);
                if (new Random().nextInt(100) >= 100 - chance) {
                    ItemInjection.setInjection(injection.inject(player, stack), null);
                } else {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 2));
                }
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        for (Injection in : injections.values()) {
            ItemStack stack = new ItemStack((Item)this);
            ItemInjection.setInjection(stack, in);
            items.add((Object)stack);
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        Injection injection = ItemInjection.getInjection(itemStack);
        if (injection != null) {
            return injectionsLocs.get(injection).func_110624_b();
        }
        return super.getCreatorModId(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Injection in = ItemInjection.getInjection(stack);
        if (in != null) {
            tooltip.add(in.getDisplayName());
            tooltip.add(StringHelper.translateToLocal("lucraftcore.info.injectionsuccess").replace("%s", "" + in.chanceForInjection((EntityPlayer)Minecraft.func_71410_x().field_71439_g, stack)));
        }
    }

    public static Injection getInjection(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemInjection) || !stack.func_77942_o()) {
            return null;
        }
        ResourceLocation loc = new ResourceLocation(stack.func_77978_p().func_74779_i("Injection"));
        return injections.containsKey(loc) ? injections.get(loc) : null;
    }

    public static void setInjection(ItemStack stack, Injection injection) {
        NBTTagCompound nbt;
        if (stack == null || stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemInjection)) {
            return;
        }
        NBTTagCompound nBTTagCompound = nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (injection == null) {
            nbt.func_74778_a("Injection", "");
        } else {
            ResourceLocation loc = null;
            for (ResourceLocation locs : injections.keySet()) {
                if (injections.get(locs) != injection) continue;
                loc = locs;
            }
            if (loc != null) {
                nbt.func_74778_a("Injection", loc.toString());
            } else {
                nbt.func_74778_a("Injection", "");
            }
        }
        stack.func_77982_d(nbt);
    }

    public static void registerInjection(Injection injection, ResourceLocation loc) {
        injections.put(loc, injection);
        injectionsLocs.put(injection, loc);
    }

    @SideOnly(value=Side.CLIENT)
    public static class InjectionItemColor
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int tintIndex) {
            int i = 0xFFFFFF;
            Injection in = ItemInjection.getInjection(stack);
            if (in == null || tintIndex != 1) {
                return i;
            }
            return in.getColor();
        }
    }

    public static abstract class Injection {
        private String name;

        public Injection(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return StringHelper.translateToLocal("injection." + this.name + ".name");
        }

        public abstract int chanceForInjection(EntityPlayer var1, ItemStack var2);

        public abstract ItemStack inject(EntityPlayer var1, ItemStack var2);

        public abstract int priorityForRemoving(EntityPlayer var1, ItemStack var2);

        public abstract ItemStack removeFromPlayer(EntityPlayer var1, ItemStack var2);

        public abstract int getColor();
    }
}

