/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.utilities.jei.boiler;

import java.util.List;
import javax.annotation.Nonnull;
import lucraft.mods.lucraftcore.util.helper.StringHelper;
import lucraft.mods.lucraftcore.utilities.jei.LCJEIPlugin;
import lucraft.mods.lucraftcore.utilities.jei.boiler.BoilerRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraftforge.fluids.FluidStack;

public class BoilerRecipeCategory
implements IRecipeCategory<BoilerRecipeWrapper> {
    private final IDrawable background;
    private final IDrawableStatic tankOverlay;
    private final String title;

    public BoilerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(LCJEIPlugin.TEXTURE, 0, 98, 134, 62);
        this.tankOverlay = guiHelper.createDrawable(LCJEIPlugin.TEXTURE, 176, 1, 16, 60);
        this.title = "tile.boiler.name";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public String getTitle() {
        return StringHelper.translateToLocal(this.title);
    }

    public String getUid() {
        return "lucraftcore.boiler";
    }

    public String getModName() {
        return "Lucraft: Core";
    }

    public void setRecipe(IRecipeLayout recipeLayout, BoilerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 1, 1, 16, 60, 5000, true, (IDrawable)this.tankOverlay);
        fluidStacks.init(1, false, 117, 1, 16, 60, 5000, true, (IDrawable)this.tankOverlay);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = x + y * 3;
                itemStacks.init(index, true, 24 + x * 18, 0 + y * 18);
            }
        }
        itemStacks.set(ingredients);
        fluidStacks.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        fluidStacks.set(1, (List)ingredients.getOutputs(FluidStack.class).get(0));
    }
}

