/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.blocks;

import java.util.List;
import lucraft.mods.lucraftcore.EnumMetalTypes;
import lucraft.mods.lucraftcore.items.ItemBlockMetal;
import lucraft.mods.lucraftcore.proxies.LucraftCoreProxy;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class BlockMetal
extends Block {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", EnumMetalTypes.class);

    public BlockMetal() {
        super(Material.field_151576_e);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(LucraftCoreProxy.tabMetals);
        String name = "block";
        GameRegistry.registerBlock((Block)this, ItemBlockMetal.class, (String)name);
        for (EnumMetalTypes type : EnumMetalTypes.values()) {
            LucraftCoreUtil.registerBlockModel(this, type.getId(), name + type.getMetalName());
            OreDictionary.registerOre((String)(name + type.getMetalName()), (ItemStack)new ItemStack((Block)this, 1, type.getId()));
        }
    }

    public float func_176195_g(World world, BlockPos pos) {
        EnumMetalTypes metal = EnumMetalTypes.getTypeFromMetadata(world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)));
        return metal.getResistance() / 2.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        EnumMetalTypes metal = EnumMetalTypes.getTypeFromMetadata(world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)));
        return metal.getResistance();
    }

    public EnumMetalTypes getMetalType(IBlockState state) {
        return (EnumMetalTypes)((Object)state.func_177229_b((IProperty)TYPE));
    }

    public int getHarvestLevel(IBlockState state) {
        return this.getMetalType(state).getHarvestLevel() * 2;
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int func_180651_a(IBlockState state) {
        return this.getMetalType(state).getId();
    }

    public void func_149666_a(Item item, CreativeTabs creativetab, List list) {
        for (EnumMetalTypes type : EnumMetalTypes.values()) {
            list.add(new ItemStack(item, 1, type.getId()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)EnumMetalTypes.getTypeFromMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        int typebits = this.getMetalType(state).getId();
        return typebits;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE});
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.getMetalType(state).isRadioActive() && entity instanceof EntityLivingBase && !world.field_72995_K) {
            EntityLivingBase base = (EntityLivingBase)entity;
            base.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 120, 2, false, false));
            base.func_70690_d(new PotionEffect(Potion.field_76431_k.func_76396_c(), 120, 2, false, false));
        }
    }
}

