/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.entity;

import lucraft.mods.lucraftcore.entity.SuperpowerPlayerData;
import lucraft.mods.lucraftcore.util.IFakePlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LCEntityEvents {
    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        NBTTagCompound compound = new NBTTagCompound();
        SuperpowerPlayerData.get(event.original).saveNBTData(compound);
        SuperpowerPlayerData.get(event.entityPlayer).loadNBTData(compound);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (LCEntityEvents.isEntityAvailable(event.entity) && SuperpowerPlayerData.get((EntityPlayer)event.entity) == null) {
            SuperpowerPlayerData.register((EntityPlayer)event.entity);
        }
        if (LCEntityEvents.isEntityAvailable(event.entity) && event.entity.getExtendedProperties("LucraftCore") == null) {
            event.entity.registerExtendedProperties("LucraftCore", (IExtendedEntityProperties)new SuperpowerPlayerData((EntityPlayer)event.entity));
        }
    }

    @SubscribeEvent
    public void onUpdate(TickEvent.PlayerTickEvent e) {
        if (LCEntityEvents.isEntityAvailable((Entity)e.player)) {
            SuperpowerPlayerData.get(e.player).onUpdate(e.phase);
        }
    }

    public static boolean isEntityAvailable(Entity entity) {
        return entity != null && entity instanceof EntityPlayer && !(entity instanceof IFakePlayerEntity);
    }
}

