/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.integration.jei.pulverizer;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lucraft.mods.lucraftcore.integration.jei.LucraftCoreRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class PulverizerRecipe
extends LucraftCoreRecipeWrapper {
    @Nonnull
    private final List<List<ItemStack>> input;
    @Nonnull
    private final List<ItemStack> outputs;
    @Nullable
    private final String experienceString;

    public PulverizerRecipe(@Nonnull List<ItemStack> input, @Nonnull ItemStack output, float experience) {
        this.input = Collections.singletonList(input);
        this.outputs = Collections.singletonList(output);
        this.experienceString = (double)experience > 0.0 ? Translator.translateToLocalFormatted((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)}) : null;
    }

    @Nonnull
    public List<List<ItemStack>> getInputs() {
        return this.input;
    }

    @Nonnull
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.experienceString != null) {
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            int stringWidth = fontRendererObj.func_78256_a(this.experienceString);
            fontRendererObj.func_78276_b(this.experienceString, recipeWidth - stringWidth, 0, Color.gray.getRGB());
        }
    }
}

