/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.items;

import java.util.List;
import lucraft.mods.lucraftcore.config.LCConfig;
import lucraft.mods.lucraftcore.entity.SuperpowerPlayerData;
import lucraft.mods.lucraftcore.items.ItemBase;
import lucraft.mods.lucraftcore.superpower.Superpower;
import lucraft.mods.lucraftcore.superpower.SuperpowerHandler;
import lucraft.mods.lucraftcore.util.LucraftCoreUtil;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ItemSuperpowerCapsule
extends ItemBase {
    public ItemSuperpowerCapsule(String name) {
        super(name);
        this.func_77625_d(1);
        LucraftCoreUtil.registerItemModel(this, 0, name + "_0");
        LucraftCoreUtil.registerItemModel(this, 1, name + "_1");
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        stack.func_77982_d(new NBTTagCompound());
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        return stack;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        return itemStackIn;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityPlayer playerIn, int timeLeft) {
        if (timeLeft <= 71980) {
            SuperpowerPlayerData data;
            Superpower power;
            if (stack.func_77952_i() == 0) {
                SuperpowerPlayerData data2 = SuperpowerPlayerData.get(playerIn);
                Superpower power2 = data2.getSuperpower();
                if (power2 != null) {
                    NBTTagCompound nbt = stack.func_77978_p();
                    if (nbt == null) {
                        nbt = new NBTTagCompound();
                    }
                    nbt.func_74778_a("power", power2.getUnlocalizedName());
                    data2.removeSuperpower();
                    stack.func_77982_d(nbt);
                    stack.func_77964_b(1);
                    playerIn.func_70606_j(playerIn.func_110143_aJ() - 6.0f);
                }
            } else if (stack.func_77952_i() == 1 && (power = (data = SuperpowerPlayerData.get(playerIn)).getSuperpower()) == null) {
                Superpower newPower;
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                if ((newPower = SuperpowerHandler.getSuperpowerFromName(nbt.func_74779_i("power"))) != null) {
                    data.setSuperpower(newPower);
                    nbt.func_74778_a("power", "");
                    stack.func_77964_b(0);
                    playerIn.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 2));
                } else {
                    nbt.func_74778_a("power", "");
                    stack.func_77964_b(0);
                }
                stack.func_77982_d(nbt);
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Superpower power;
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        if (stack.func_77978_p() != null && (power = SuperpowerHandler.getSuperpowerFromName(stack.func_77978_p().func_74779_i("power"))) != null) {
            tooltip.add(power.getDisplayName());
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        EntityPlayer target;
        SuperpowerPlayerData data;
        Superpower power;
        if (stack.func_77952_i() == 0 && LCConfig.stealSuperpower && entity instanceof EntityPlayer) {
            EntityPlayer target2 = (EntityPlayer)entity;
            SuperpowerPlayerData data2 = SuperpowerPlayerData.get(target2);
            Superpower power2 = data2.getSuperpower();
            if (power2 != null) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                nbt.func_74778_a("power", power2.getUnlocalizedName());
                data2.removeSuperpower();
                stack.func_77982_d(nbt);
                stack.func_77964_b(1);
                target2.func_70606_j(target2.func_110143_aJ() - 6.0f);
            }
        } else if (stack.func_77952_i() == 1 && LCConfig.giveSuperpower && entity instanceof EntityPlayer && (power = (data = SuperpowerPlayerData.get(target = (EntityPlayer)entity)).getSuperpower()) == null) {
            Superpower newPower;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if ((newPower = SuperpowerHandler.getSuperpowerFromName(nbt.func_74779_i("power"))) != null) {
                data.setSuperpower(newPower);
                nbt.func_74778_a("power", "");
                stack.func_77964_b(0);
                target.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 2));
            } else {
                nbt.func_74778_a("power", "");
                stack.func_77964_b(0);
            }
            stack.func_77982_d(nbt);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn));
        for (Superpower power : SuperpowerHandler.getSuperpowers()) {
            ItemStack stack = new ItemStack(itemIn);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("power", power.getUnlocalizedName());
            stack.func_77982_d(nbt);
            stack.func_77964_b(1);
            subItems.add(stack);
        }
    }
}

