/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import lucraft.mods.lucraftcore.events.PlayerLeftClickEvent;
import lucraft.mods.lucraftcore.network.AbstractServerMessageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSendInfoToServer
implements IMessage {
    public InfoType type;
    public int info;
    public static HashMap<Integer, InfoType> ids = new HashMap();

    public MessageSendInfoToServer() {
    }

    public MessageSendInfoToServer(InfoType type) {
        this.type = type;
        this.info = 0;
    }

    public MessageSendInfoToServer(InfoType type, int i) {
        this.type = type;
        this.info = i;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = InfoType.getInfoTypeFromId(buf.readInt());
        this.info = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.info);
    }

    public static enum InfoType {
        ATTACK;


        private InfoType() {
            ids.put(this.ordinal(), this);
        }

        public static InfoType getInfoTypeFromId(int id) {
            return ids.get(id);
        }
    }

    public static class Handler
    extends AbstractServerMessageHandler<MessageSendInfoToServer> {
        @Override
        public IMessage handleServerMessage(EntityPlayer player, MessageSendInfoToServer message, MessageContext ctx) {
            InfoType type = message.type;
            switch (type) {
                case ATTACK: {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerLeftClickEvent(player));
                    break;
                }
            }
            return null;
        }
    }
}

