/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.network;

import io.netty.buffer.ByteBuf;
import lucraft.mods.lucraftcore.entity.SuperpowerPlayerData;
import lucraft.mods.lucraftcore.network.AbstractClientMessageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSyncPlayerData
implements IMessage {
    private int entityId;
    private NBTTagCompound data;

    public MessageSyncPlayerData() {
    }

    public MessageSyncPlayerData(EntityPlayer player) {
        this.entityId = player.func_145782_y();
        this.data = new NBTTagCompound();
        SuperpowerPlayerData.get(player).saveNBTData(this.data);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class Handler
    extends AbstractClientMessageHandler<MessageSyncPlayerData> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, MessageSyncPlayerData message, MessageContext ctx) {
            EntityPlayer en;
            if (player != null && message != null && ctx != null && (en = (EntityPlayer)player.field_70170_p.func_73045_a(message.entityId)) != null) {
                SuperpowerPlayerData.get(en).loadNBTData(message.data);
            }
            return null;
        }
    }
}

