/*
 * Decompiled with CFR 0.152.
 */
package lucraft.mods.lucraftcore.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import lucraft.mods.lucraftcore.util.ModelBoxDetails;
import lucraft.mods.lucraftcore.util.ObfHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityModelUtil {
    public static Random rand = new Random();
    public static HashMap<Class<? extends Render>, ArrayList<ModelRenderer>> classToModelRendererMap = new HashMap();

    public static ArrayList<ModelRenderer> getCopiedModelCubes(ArrayList<ModelRenderer> modelList, ModelBase base, Entity ent) {
        if (Minecraft.func_71410_x().func_175598_ae().field_78724_e != null && Minecraft.func_71410_x().func_175598_ae().field_78734_h != null && ent != null) {
            for (int i = 0; i < modelList.size(); ++i) {
                ModelRenderer cube = modelList.get(i);
                if (!((Boolean)ReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)cube, (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.compiled)})).booleanValue()) continue;
                GLAllocation.func_74523_b((int)((Integer)ReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)cube, (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.displayList)})));
                ReflectionHelper.setPrivateValue(ModelRenderer.class, (Object)cube, (Object)false, (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.compiled)});
            }
            Minecraft.func_71410_x().func_175598_ae().func_78713_a(ent).func_76986_a(ent, 0.0, -500.0, 0.0, 0.0f, 1.0f);
            ArrayList<ModelRenderer> modelListCopy = new ArrayList<ModelRenderer>(modelList);
            ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
            for (int i = modelListCopy.size() - 1; i >= 0; --i) {
                ModelRenderer cube = modelListCopy.get(i);
                if (((Boolean)ReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)cube, (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.compiled)})).booleanValue()) continue;
                modelListCopy.remove(i);
            }
            for (ModelRenderer cube : modelListCopy) {
                list.add(EntityModelUtil.getModelRendererCopy(cube, base, 0, true, false));
            }
            return list;
        }
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (int i = 0; i < modelList.size(); ++i) {
            ModelRenderer cube = modelList.get(i);
            list.add(EntityModelUtil.getModelRendererCopy(cube, base, 0, true, false));
        }
        return list;
    }

    public static ModelBoxDetails createModelBoxDetails(ModelRenderer rend, ModelBox box, String name) {
        TextureOffset textureoffset;
        ModelBoxDetails info = new ModelBoxDetails(name);
        info.dimensions[0] = (int)Math.abs(box.field_78248_d - box.field_78252_a);
        info.dimensions[1] = (int)Math.abs(box.field_78249_e - box.field_78250_b);
        info.dimensions[2] = (int)Math.abs(box.field_78246_f - box.field_78251_c);
        info.position[0] = rend.field_78800_c;
        info.position[1] = rend.field_78797_d;
        info.position[2] = rend.field_78798_e;
        info.offset[0] = box.field_78252_a;
        info.offset[1] = box.field_78250_b;
        info.offset[2] = box.field_78251_c;
        info.rotation[0] = Math.toDegrees(rend.field_78795_f);
        info.rotation[1] = Math.toDegrees(rend.field_78796_g);
        info.rotation[2] = Math.toDegrees(rend.field_78808_h);
        info.scale[2] = 1.0;
        info.scale[1] = 1.0;
        info.scale[0] = 1.0;
        TexturedQuad[] quadList = (TexturedQuad[])ReflectionHelper.getPrivateValue(ModelBox.class, (Object)box, (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.quadList)});
        PositionTextureVertex[] vertices = quadList[1].field_78239_a;
        info.txMirror = (vertices[info.txMirror ? 1 : 2].field_78243_a.field_72448_b - vertices[info.txMirror ? 3 : 0].field_78243_a.field_72448_b - (double)info.dimensions[1]) / 2.0 < 0.0;
        info.txOffset[0] = (int)(vertices[info.txMirror ? 2 : 1].field_78241_b * rend.field_78801_a);
        info.txOffset[1] = (int)(vertices[info.txMirror ? 2 : 1].field_78242_c * rend.field_78799_b) - info.dimensions[2];
        float f = vertices[info.txMirror ? 2 : 1].field_78242_c;
        int n = info.txMirror ? 1 : 2;
        if (f > vertices[n].field_78242_c) {
            info.txMirror = !info.txMirror;
            info.txOffset[0] = (int)(vertices[info.txMirror ? 2 : 1].field_78241_b * rend.field_78801_a);
            info.txOffset[1] = (int)(vertices[info.txMirror ? 2 : 1].field_78242_c * rend.field_78799_b) - info.dimensions[2];
        }
        if (box.field_78247_g != null && (textureoffset = ((ModelBase)ReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)rend, (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.baseModel)})).func_78084_a(box.field_78247_g)) != null) {
            info.txOffset[0] = textureoffset.field_78783_a;
            info.txOffset[1] = textureoffset.field_78782_b;
        }
        info.mcScale = (vertices[info.txMirror ? 1 : 2].field_78243_a.field_72448_b - vertices[info.txMirror ? 3 : 0].field_78243_a.field_72448_b - (double)info.dimensions[1]) / 2.0;
        return info;
    }

    public static ModelRenderer getModelRendererCopy(ModelRenderer original, ModelBase copyBase, int depth, boolean hasFullModelBox, boolean isEmpty) {
        int txOffsetX = (Integer)ReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)original, (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.textureOffsetX)});
        int txOffsetY = (Integer)ReflectionHelper.getPrivateValue(ModelRenderer.class, (Object)original, (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.textureOffsetY)});
        ModelRenderer cubeCopy = new ModelRenderer(copyBase, txOffsetX, txOffsetY);
        cubeCopy.field_78799_b = original.field_78799_b;
        cubeCopy.field_78801_a = original.field_78801_a;
        for (int j = 0; j < original.field_78804_l.size(); ++j) {
            ModelBox box = (ModelBox)original.field_78804_l.get(j);
            ModelBoxDetails info = EntityModelUtil.createModelBoxDetails(original, box, box.field_78247_g != null ? box.field_78247_g.substring(box.field_78247_g.lastIndexOf(".") + 1) : "");
            cubeCopy.field_78809_i = info.txMirror;
            ReflectionHelper.setPrivateValue(ModelRenderer.class, (Object)cubeCopy, (Object)info.txOffset[0], (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.textureOffsetX)});
            ReflectionHelper.setPrivateValue(ModelRenderer.class, (Object)cubeCopy, (Object)info.txOffset[1], (String[])new String[]{ObfHelper.getFieldNames(ObfHelper.textureOffsetY)});
            if (isEmpty) {
                info.dimensions[2] = 0;
                info.dimensions[1] = 0;
                info.dimensions[0] = 0;
                info.offset[1] = info.offset[2] = (double)0;
                info.offset[0] = info.offset[2];
            }
            if (hasFullModelBox) {
                cubeCopy.func_78790_a((float)info.offset[0], (float)info.offset[1], (float)info.offset[2], info.dimensions[0], info.dimensions[1], info.dimensions[2], (float)info.mcScale);
                continue;
            }
            ModelBox randBox = (ModelBox)original.field_78804_l.get(rand.nextInt(original.field_78804_l.size()));
            float x = randBox.field_78252_a + (randBox.field_78248_d - randBox.field_78252_a > 0.0f ? (float)rand.nextInt((int)(randBox.field_78248_d - randBox.field_78252_a) > 0 ? (int)(randBox.field_78248_d - randBox.field_78252_a) : 1) : 0.0f);
            float y = randBox.field_78250_b + (randBox.field_78249_e - randBox.field_78250_b > 0.0f ? (float)rand.nextInt((int)(randBox.field_78249_e - randBox.field_78250_b) > 0 ? (int)(randBox.field_78249_e - randBox.field_78250_b) : 1) : 0.0f);
            float z = randBox.field_78251_c + (randBox.field_78246_f - randBox.field_78251_c > 0.0f ? (float)rand.nextInt((int)(randBox.field_78246_f - randBox.field_78251_c) > 0 ? (int)(randBox.field_78246_f - randBox.field_78251_c) : 1) : 0.0f);
            cubeCopy.func_78790_a(x, y, z, info.dimensions[0], info.dimensions[1], info.dimensions[2], (float)info.mcScale);
        }
        cubeCopy.field_78809_i = original.field_78809_i;
        if (original.field_78805_m != null && depth < 20) {
            for (int i = 0; i < original.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)original.field_78805_m.get(i);
                cubeCopy.func_78792_a(EntityModelUtil.getModelRendererCopy(child, copyBase, depth + 1, hasFullModelBox, isEmpty));
            }
        }
        cubeCopy.func_78793_a(original.field_78800_c, original.field_78797_d, original.field_78798_e);
        cubeCopy.field_78795_f = original.field_78795_f;
        cubeCopy.field_78796_g = original.field_78796_g;
        cubeCopy.field_78808_h = original.field_78808_h;
        return cubeCopy;
    }

    public static ArrayList<ModelRenderer> getModelCubes(ModelBase parent) {
        return new ArrayList<ModelRenderer>(EntityModelUtil.getNamedModelCubes(parent).values());
    }

    public static HashMap<String, ModelRenderer> getNamedModelCubes(ModelBase parent) {
        HashMap<String, ModelRenderer> list = new HashMap<String, ModelRenderer>();
        HashMap<String, ModelRenderer[]> list1 = new HashMap<String, ModelRenderer[]>();
        if (parent != null) {
            for (Class<?> clz = parent.getClass(); clz != ModelBase.class && ModelBase.class.isAssignableFrom(clz); clz = clz.getSuperclass()) {
                try {
                    Field[] fields;
                    for (Field f : fields = clz.getDeclaredFields()) {
                        ModelRenderer[] rend;
                        f.setAccessible(true);
                        if (f.getType() == ModelRenderer.class || ModelRenderer.class.isAssignableFrom(f.getType())) {
                            rend = (ModelRenderer[])f.get(parent);
                            if (rend == null) continue;
                            String name = f.getName();
                            if (rend.field_78802_n != null) {
                                name = rend.field_78802_n;
                                while (list.containsKey(name)) {
                                    name = name + "_";
                                }
                            }
                            list.put(name, (ModelRenderer)rend);
                            continue;
                        }
                        if (f.getType() != ModelRenderer[].class && !ModelRenderer[].class.isAssignableFrom(f.getType()) || (rend = (ModelRenderer[])f.get(parent)) == null) continue;
                        list1.put(f.getName(), rend);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
                }
            }
        }
        for (Map.Entry e : list1.entrySet()) {
            int count = 1;
            for (ModelRenderer cube : (ModelRenderer[])e.getValue()) {
                if (cube == null || list.containsValue(cube)) continue;
                list.put((String)e.getKey() + count, cube);
                ++count;
            }
        }
        ArrayList<ModelRenderer> children = new ArrayList<ModelRenderer>();
        for (Map.Entry e : list.entrySet()) {
            ModelRenderer cube = (ModelRenderer)e.getValue();
            for (ModelRenderer child : EntityModelUtil.getChildren(cube, true, 0)) {
                if (children.contains(child)) continue;
                children.add(child);
            }
        }
        for (ModelRenderer child : children) {
            Iterator<Map.Entry<String, ModelRenderer>> ite = list.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, ModelRenderer> e = ite.next();
                if (e.getValue() != child) continue;
                ite.remove();
            }
        }
        return list;
    }

    public static ArrayList<ModelRenderer> getMultiModelCubes(ArrayList<ModelBase> parent) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (ModelBase base : parent) {
            list.addAll(EntityModelUtil.getModelCubes(base));
        }
        return list;
    }

    public static ArrayList<ModelRenderer> getChildren(ModelRenderer parent, boolean recursive, int depth) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        if (parent.field_78805_m != null && depth < 20) {
            for (int i = 0; i < parent.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)parent.field_78805_m.get(i);
                if (recursive) {
                    ArrayList<ModelRenderer> children = EntityModelUtil.getChildren(child, recursive, depth + 1);
                    for (ModelRenderer child1 : children) {
                        if (list.contains(child1)) continue;
                        list.add(child1);
                    }
                }
                if (list.contains(child)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public static ModelBase getPossibleModel(Render rend) {
        ArrayList models = new ArrayList();
        if (rend != null) {
            try {
                for (Class<?> clz = rend.getClass(); clz != Render.class; clz = clz.getSuperclass()) {
                    Field[] fields;
                    ArrayList<ModelBase> priorityLevel = new ArrayList<ModelBase>();
                    for (Field f : fields = clz.getDeclaredFields()) {
                        ModelBase[] modelBases;
                        f.setAccessible(true);
                        if (ModelBase.class.isAssignableFrom(f.getType())) {
                            ModelBase base = (ModelBase)f.get(rend);
                            if (base == null) continue;
                            priorityLevel.add(base);
                            continue;
                        }
                        if (!ModelBase[].class.isAssignableFrom(f.getType()) || (modelBases = (ModelBase[])f.get(rend)) == null) continue;
                        priorityLevel.addAll(Arrays.asList(modelBases));
                    }
                    models.add(priorityLevel);
                    if (clz != RendererLivingEntity.class) continue;
                    ArrayList<ModelBase> topPriority = new ArrayList<ModelBase>();
                    for (Field f : fields) {
                        ModelBase base;
                        f.setAccessible(true);
                        if (!ModelBase.class.isAssignableFrom(f.getType()) || !f.getName().equalsIgnoreCase("field_77045_g") && !f.getName().equalsIgnoreCase("mainModel") || (base = (ModelBase)f.get(rend)) == null) continue;
                        topPriority.add(base);
                    }
                    models.add(topPriority);
                }
            }
            catch (Exception e) {
                throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
            }
        }
        ModelBase base1 = null;
        int priorityLevel = -1;
        int size = -1;
        int currentPriority = 0;
        for (ArrayList arrayList : models) {
            for (ModelBase base : arrayList) {
                ArrayList<ModelRenderer> mrs = EntityModelUtil.getModelCubes(base);
                if (mrs.size() <= size && (mrs.size() != size || currentPriority <= priorityLevel)) continue;
                size = mrs.size();
                base1 = base;
                priorityLevel = currentPriority;
            }
            ++currentPriority;
        }
        return base1;
    }

    public static ArrayList<ModelRenderer> getModelCubes(Entity entity) {
        return EntityModelUtil.getModelCubes(Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity));
    }

    public static ArrayList<ModelRenderer> getModelCubes(Render rend) {
        ArrayList<ModelRenderer> map = classToModelRendererMap.get(rend.getClass());
        if (map == null) {
            map = EntityModelUtil.getModelCubes(EntityModelUtil.getPossibleModel(rend));
            classToModelRendererMap.put(rend.getClass(), map);
        }
        return map;
    }
}

