/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.handler;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.handler.OMLibNetworkingHandler;
import omtteam.omlib.handler.OwnerShareHandler;
import omtteam.omlib.items.IDrawOutline;
import omtteam.omlib.items.IDrawOutlineBase;
import omtteam.omlib.network.messages.MessageSetSharePlayerList;
import omtteam.omlib.util.RenderUtil;

public class EventHandler {
    private static EventHandler instance;

    private EventHandler() {
    }

    public static EventHandler getInstance() {
        if (instance == null) {
            instance = new EventHandler();
        }
        return instance;
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        OwnerShareHandler.loadFromDisk();
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        OwnerShareHandler.saveToDisk();
    }

    @SubscribeEvent
    public void playerJoinEvent(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            OMLibNetworkingHandler.sendMessageToPlayer(new MessageSetSharePlayerList(OwnerShareHandler.getInstance()), (EntityPlayerMP)event.getEntity());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawBlockOutline(DrawBlockHighlightEvent event) {
        if (event.getTarget() != null && event.getTarget().field_178784_b != null && event.getPlayer().func_184614_ca() != null && event.getPlayer().func_184614_ca().func_77973_b() instanceof IDrawOutline) {
            EnumFacing facing;
            BlockPos blockpos = event.getTarget().func_178782_a().func_177972_a(event.getTarget().field_178784_b);
            IDrawOutline item = (IDrawOutline)event.getPlayer().func_184614_ca().func_77973_b();
            if (item instanceof IDrawOutlineBase && ((IDrawOutlineBase)item).getBaseFacing(event.getPlayer().func_130014_f_(), blockpos) != null) {
                facing = ((IDrawOutlineBase)item).getBaseFacing(event.getPlayer().func_130014_f_(), blockpos);
            } else {
                if (item instanceof IDrawOutlineBase) {
                    return;
                }
                facing = event.getTarget().field_178784_b.func_176734_d();
            }
            AxisAlignedBB alignedBB = item.getRenderOutline(facing, event.getPlayer().func_130014_f_(), blockpos);
            EntityPlayer player = event.getPlayer();
            double partialTicks = event.getPartialTicks();
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * partialTicks;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
            float[] color = new float[3];
            if (event.getPlayer().func_130014_f_().func_175623_d(blockpos)) {
                color[0] = 0.0f;
                color[1] = 1.0f;
                color[2] = 1.0f;
            } else {
                color[0] = 1.0f;
                color[1] = 0.0f;
                color[2] = 0.0f;
            }
            alignedBB = alignedBB.func_72317_d(-d0, -d1, -d2);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            RenderUtil.drawHighlightBox(vertexbuffer, alignedBB.field_72340_a, alignedBB.field_72338_b, alignedBB.field_72339_c, alignedBB.field_72336_d, alignedBB.field_72337_e, alignedBB.field_72334_f, color[0], color[1], color[2], 0.5f);
            tessellator.func_78381_a();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }
}

