/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util.command;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import omtteam.omlib.compatibility.minecraft.CompatCommandBase;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.compat.ChatTools;

public class CommandChangeOwner
extends CompatCommandBase {
    @Override
    @Nonnull
    public String getName() {
        return "omchangeowner";
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public String getUsage(ICommandSender sender) {
        return "<dimension> <x> <y> <z> <new owner>";
    }

    @ParametersAreNonnullByDefault
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] params) {
        if (params.length != 5) {
            ChatTools.addChatMessage(sender, (ITextComponent)new TextComponentString(this.getUsage(sender)));
            return;
        }
        try {
            int dimension = Integer.parseInt(params[0]);
            int x = Integer.parseInt(params[1]);
            int y = Integer.parseInt(params[2]);
            int z = Integer.parseInt(params[3]);
            String ownerName = params[4];
            if (DimensionManager.getWorld((int)dimension) == null) {
                ChatTools.addChatMessage(sender, (ITextComponent)new TextComponentString("Invalid dimension"));
                return;
            }
            WorldServer worldserver = server.func_71218_a(dimension);
            TileEntity tileEntity = worldserver.func_175625_s(new BlockPos(x, y, z));
            if (tileEntity instanceof TileEntityOwnedBlock) {
                TileEntityOwnedBlock turret = (TileEntityOwnedBlock)tileEntity;
                turret.setOwner(ownerName);
                ChatTools.addChatMessage(sender, (ITextComponent)new TextComponentString("Block ownership has been updated"));
            } else {
                ChatTools.addChatMessage(sender, (ITextComponent)new TextComponentString("No ownable block was found at that location"));
            }
        }
        catch (NumberFormatException e) {
            ChatTools.addChatMessage(sender, (ITextComponent)new TextComponentString("Dimension and coordinates must be numbers"));
        }
    }
}

