/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityTools {
    public static String fixEntityId(String id) {
        return id;
    }

    public static String findEntityIdByClass(Class<? extends Entity> clazz) {
        return (String)EntityList.field_75626_c.get(clazz);
    }

    public static String findEntityUnlocNameByClass(Class<? extends Entity> clazz) {
        return (String)EntityList.field_75626_c.get(clazz);
    }

    public static Stream<String> getEntities() {
        return EntityList.field_75625_b.keySet().stream();
    }

    public static String findEntityLocNameByClass(Class<? extends Entity> clazz) {
        return I18n.func_74838_a((String)((String)EntityList.field_75626_c.get(clazz)));
    }

    public static String getEntityName(Entity entity) {
        if (entity instanceof EntitySkeleton && ((EntitySkeleton)entity).func_189771_df() == SkeletonType.WITHER) {
            return "Wither Skeleton";
        }
        if (entity instanceof EntitySkeleton && ((EntitySkeleton)entity).func_189771_df() == SkeletonType.STRAY) {
            return "Stray Skeleton";
        }
        if (entity instanceof EntityPigZombie) {
            return "Zombie Pigman";
        }
        return entity.func_70005_c_();
    }

    public static Class<? extends Entity> findClassById(String id) {
        return (Class)EntityList.field_75625_b.get(id);
    }

    public static EntityLiving createEntity(World world, String mobId) {
        Class clazz = "WitherSkeleton".equals(mobId) ? EntitySkeleton.class : ("StraySkeleton".equals(mobId) ? EntitySkeleton.class : EntityTools.findClassById(mobId));
        EntityLiving entityLiving = null;
        try {
            entityLiving = (EntityLiving)clazz.getConstructor(World.class).newInstance(world);
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if ("WitherSkeleton".equals(mobId)) {
            ((EntitySkeleton)entityLiving).func_189768_a(SkeletonType.WITHER);
        } else if ("StraySkeleton".equals(mobId)) {
            ((EntitySkeleton)entityLiving).func_189768_a(SkeletonType.STRAY);
        } else if (entityLiving instanceof EntitySkeleton) {
            ((EntitySkeleton)entityLiving).func_189768_a(SkeletonType.NORMAL);
        }
        return entityLiving;
    }

    public static String findId(Class<? extends Entity> clazz, Entity entity) {
        if (entity instanceof EntitySkeleton) {
            EntitySkeleton skeleton = (EntitySkeleton)entity;
            if (skeleton.func_189771_df() == SkeletonType.WITHER) {
                return "WitherSkeleton";
            }
            if (skeleton.func_189771_df() == SkeletonType.STRAY) {
                return "StraySkeleton";
            }
        }
        return (String)EntityList.field_75626_c.get(clazz);
    }

    public static void setSpawnerEntity(@Nonnull World world, @Nonnull TileEntityMobSpawner spawner, @Nonnull ResourceLocation resourceLocation, @Nonnull String entityName) {
        MobSpawnerBaseLogic mobspawnerbaselogic = spawner.func_145881_a();
        mobspawnerbaselogic.func_98272_a(entityName);
        spawner.func_70296_d();
    }

    public static void moveEntity(Entity entity, double x, double y, double z) {
        entity.func_70091_d(x, y, z);
    }

    public static void registerModEntity(ResourceLocation resourceLocation, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public static void registerModEntity(ResourceLocation resourceLocation, Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)eggPrimary, (int)eggSecondary);
    }
}

