/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import omtteam.omlib.blocks.BlockAbstract;
import omtteam.omlib.tileentity.TileEntityContainerElectric;
import omtteam.omlib.util.compat.ItemStackTools;

@MethodsReturnNonnullByDefault
public abstract class BlockAbstractTileEntity
extends BlockAbstract {
    protected BlockAbstractTileEntity(Material material) {
        super(material);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    @Override
    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected void dropItems(World worldIn, BlockPos pos) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityContainerElectric) {
            TileEntityContainerElectric entity = (TileEntityContainerElectric)worldIn.func_175625_s(pos);
            Random rand = new Random();
            for (int i = 0; i < entity.func_70302_i_(); ++i) {
                ItemStack item = entity.func_70301_a(i);
                if (item == null || ItemStackTools.getStackSize(item) <= 0) continue;
                float rx = rand.nextFloat() * 0.8f + 0.1f;
                float ry = rand.nextFloat() * 0.8f + 0.1f;
                float rz = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityItem = new EntityItem(worldIn, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), new ItemStack(item.func_77973_b(), ItemStackTools.getStackSize(item), item.func_77952_i()));
                if (item.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
                }
                float factor = 0.05f;
                entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
                entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
                entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
                worldIn.func_72838_d((Entity)entityItem);
                ItemStackTools.setStackSize(item, 0);
            }
        }
    }
}

