/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.tileentity;

import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import omtteam.omlib.compatibility.ModCompatibility;
import omtteam.omlib.handler.ConfigHandler;
import omtteam.omlib.power.OMEnergyStorage;
import omtteam.omlib.power.tesla.BaseOMTeslaContainerWrapper;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;
import omtteam.omlib.util.MathUtil;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="cofhapi")})
@MethodsReturnNonnullByDefault
public abstract class TileEntityElectric
extends TileEntityOwnedBlock
implements IEnergyReceiver,
ITickable,
IEnergySink {
    protected OMEnergyStorage storage;
    protected Object teslaContainer;
    protected double storageEU = 0.0;
    protected double maxStorageEU = 40000.0;
    protected boolean wasAddedToEnergyNet = false;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("maxStorage", this.storage.getMaxEnergyStored());
        nbtTagCompound.func_74768_a("energyStored", this.storage.getEnergyStored());
        nbtTagCompound.func_74768_a("maxIO", this.storage.getMaxReceive());
        nbtTagCompound.func_74780_a("storageEU", this.storageEU);
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.storage.setCapacity(nbtTagCompound.func_74762_e("maxStorage"));
        this.storage.setEnergyStored(nbtTagCompound.func_74762_e("energyStored"));
        this.storage.setMaxReceive(nbtTagCompound.func_74762_e("maxIO"));
        this.storageEU = nbtTagCompound.func_74769_h("storageEU");
    }

    public void func_73660_a() {
        if (ModCompatibility.IC2Loaded && ConfigHandler.EUSupport && !this.wasAddedToEnergyNet && !this.func_145831_w().field_72995_K) {
            this.addToIc2EnergyNetwork();
            this.wasAddedToEnergyNet = true;
        }
        if (!this.func_145831_w().field_72995_K && ModCompatibility.IC2Loaded && this.func_145831_w().func_82737_E() % 5L == 1L) {
            this.moveEnergyFromIC2ToStorage();
        }
    }

    @Optional.Method(modid="cofhapi")
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        this.func_70296_d();
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Optional.Method(modid="cofhapi")
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Optional.Method(modid="cofhapi")
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Optional.Method(modid="cofhapi")
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int getEnergyLevel(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyLevel(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public void setMaxEnergyStored(int maxStorage) {
        this.storage.setCapacity(maxStorage);
    }

    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
        this.func_70296_d();
    }

    public void removeEnergy(int energy) {
        this.storage.extractEnergy(energy, false);
        this.func_70296_d();
    }

    public double getStorageEU() {
        return this.storageEU;
    }

    public double getMaxStorageEU() {
        return this.maxStorageEU;
    }

    public void moveEnergyFromIC2ToStorage() {
        double requiredEnergy = (double)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) / ConfigHandler.EUtoRFRatio;
        if (this.storageEU >= requiredEnergy) {
            this.storageEU -= requiredEnergy;
            this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(requiredEnergy * ConfigHandler.EUtoRFRatio));
        } else {
            this.storage.modifyEnergyStored(MathUtil.truncateDoubleToInt(this.storageEU * ConfigHandler.EUtoRFRatio));
            this.storageEU = 0.0;
        }
        this.func_70296_d();
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing facing, double v, double v1) {
        this.storageEU += v;
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        if (ConfigHandler.EUSupport) {
            return Math.max(80000.0 - this.storageEU, 0.0);
        }
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter tileEntity, EnumFacing facing) {
        return true;
    }

    @Optional.Method(modid="ic2")
    protected void addToIc2EnergyNetwork() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyTileLoadEvent event = new EnergyTileLoadEvent((IEnergyTile)this);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    @Optional.Method(modid="ic2")
    private void removeFromIc2EnergyNetwork() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.wasAddedToEnergyNet && ModCompatibility.IC2Loaded) {
            this.removeFromIc2EnergyNetwork();
            this.wasAddedToEnergyNet = false;
        }
    }

    @Optional.Method(modid="tesla")
    private BaseOMTeslaContainerWrapper getTeslaContainer() {
        if (this.teslaContainer instanceof BaseOMTeslaContainerWrapper) {
            return (BaseOMTeslaContainerWrapper)this.teslaContainer;
        }
        this.teslaContainer = new BaseOMTeslaContainerWrapper(this, EnumFacing.DOWN);
        return (BaseOMTeslaContainerWrapper)this.teslaContainer;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (ModCompatibility.TeslaLoaded && this.hasTeslaCapability(capability, facing) && this.getTeslaCapability(capability, facing) != null) {
            return this.getTeslaCapability(capability, facing);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.storage;
        }
        return (T)super.getCapability(capability, facing);
    }

    @ParametersAreNonnullByDefault
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (ModCompatibility.TeslaLoaded && this.hasTeslaCapability(capability, facing)) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Optional.Method(modid="tesla")
    private boolean hasTeslaCapability(Capability<?> capability, EnumFacing facing) {
        return capability == TeslaCapabilities.CAPABILITY_CONSUMER;
    }

    @Optional.Method(modid="tesla")
    @Nullable
    private <T> T getTeslaCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == TeslaCapabilities.CAPABILITY_CONSUMER) {
            return (T)this.getTeslaContainer();
        }
        return null;
    }
}

