/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util.command;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import omtteam.omlib.compatibility.minecraft.CompatCommandBase;
import omtteam.omlib.handler.ConfigHandler;
import omtteam.omlib.handler.OwnerShareHandler;
import omtteam.omlib.util.Player;
import omtteam.omlib.util.PlayerUtil;
import omtteam.omlib.util.compat.ChatTools;

public class CommandShareOwner
extends CompatCommandBase {
    @Nonnull
    public String func_71517_b() {
        return "omshareowner";
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_71518_a(ICommandSender sender) {
        return "'<add|del> <name to share>' or list";
    }

    @ParametersAreNonnullByDefault
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] params) {
        if (params.length != 2) {
            ChatTools.addChatMessage(sender, (ITextComponent)new TextComponentString(this.func_71518_a(sender)));
            return;
        }
        try {
            String shareName = params[1];
            String command = params[0];
            if (command.equals("add")) {
                if (!ConfigHandler.offlineModeSupport && PlayerUtil.getPlayerUUID(shareName) != null) {
                    Player sharePlayer = new Player(PlayerUtil.getPlayerUUID(shareName), shareName);
                    Player owner = new Player(PlayerUtil.getPlayerUUID(sender.func_70005_c_()), sender.func_70005_c_());
                    OwnerShareHandler.getInstance().addSharePlayer(owner, sharePlayer, sender);
                }
            } else if (command.equals("del")) {
                if (!ConfigHandler.offlineModeSupport && PlayerUtil.getPlayerUUID(shareName) != null) {
                    Player sharePlayer = new Player(PlayerUtil.getPlayerUUID(shareName), shareName);
                    Player owner = new Player(PlayerUtil.getPlayerUUID(sender.func_70005_c_()), sender.func_70005_c_());
                    OwnerShareHandler.getInstance().removeSharePlayer(owner, sharePlayer, sender);
                }
            } else if (command.equals("list")) {
                Player owner = new Player(PlayerUtil.getPlayerUUID(sender.func_70005_c_()), sender.func_70005_c_());
                OwnerShareHandler.getInstance().printSharePlayers(owner, sender);
            }
        }
        catch (NumberFormatException e) {
            ChatTools.addChatMessage(sender, (ITextComponent)new TextComponentString("Please supply a valid name and command"));
        }
    }

    public int func_82362_a() {
        return 0;
    }
}

