/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.network;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import omtteam.omlib.api.network.OMLibNetwork;
import omtteam.omlib.handler.OMLibEventHandler;
import omtteam.omlib.util.world.WorldUtil;

public interface INetworkTile {
    public OMLibNetwork getNetwork();

    public void setNetwork(OMLibNetwork var1);

    @Nonnull
    public String getDeviceName();

    @Nonnull
    public BlockPos getPosition();

    default public void recursAddDevice(World world, OMLibNetwork network, BlockPos pos, @Nullable EnumFacing from) {
        if (world.func_175667_e(pos)) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                OMLibNetwork remoteNetwork;
                TileEntity te = world.func_175625_s(pos.func_177972_a(facing));
                if (facing.equals((Object)from) || !(te instanceof INetworkTile & te != null) || (remoteNetwork = ((INetworkTile)te).getNetwork()) == null || remoteNetwork.getUuid().equals(network.getUuid())) continue;
                remoteNetwork.mergeNetwork(network);
            }
        }
    }

    default public OMLibNetwork createNetwork(World world) {
        OMLibNetwork network = new OMLibNetwork(world);
        network.addDevice(this);
        this.recursAddDevice(world, network, this.getPosition(), null);
        OMLibEventHandler.getInstance().registerNetwork(network);
        return network;
    }

    default public void scan(World world, BlockPos pos, String networkName) {
        OMLibNetwork network;
        List<INetworkTile> list = this.getTouchingNetworkTiles(world, pos);
        ArrayList<OMLibNetwork> networks = new ArrayList<OMLibNetwork>();
        for (INetworkTile tile : list) {
            if (tile.getNetwork() == null || networks.contains(tile.getNetwork())) continue;
            networks.add(tile.getNetwork());
        }
        if (networks.isEmpty()) {
            network = this.createNetwork(world);
            network.addDevice(this);
            this.setNetwork(network);
        } else if (networks.size() == 1) {
            network = (OMLibNetwork)networks.get(0);
            if (network.addDevice(this)) {
                this.setNetwork(network);
            }
        } else {
            network = (OMLibNetwork)networks.get(0);
            for (int i = 1; i < networks.size(); ++i) {
                network.mergeNetwork((OMLibNetwork)networks.get(i));
                if (!network.addDevice(this)) continue;
                this.setNetwork(network);
            }
        }
        if (!networkName.isEmpty()) {
            network.setName(networkName);
        }
    }

    default public List<INetworkTile> getTouchingNetworkTiles(World world, BlockPos pos) {
        return WorldUtil.getTouchingTileEntitiesByClass(world, pos, INetworkTile.class);
    }
}

