/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.permission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import omtteam.omlib.OMLib;
import omtteam.omlib.api.permission.IOwnerShareRegister;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageSetSharePlayerList;
import omtteam.omlib.util.player.Player;

@Mod.EventBusSubscriber(modid="omlib")
public class OwnerShareRegister
implements ICapabilityProvider,
IOwnerShareRegister {
    @Nonnull
    public static final OwnerShareRegister instance = new OwnerShareRegister();
    @Nonnull
    private static final ResourceLocation CAP_KEY = new ResourceLocation("omlib", "owner_share");
    @CapabilityInject(value=IOwnerShareRegister.class)
    public static Capability<IOwnerShareRegister> OWNER_SHARE_REGISTER = null;
    private HashMap<Player, ArrayList<Player>> ownerShareMap = new HashMap();

    private OwnerShareRegister() {
    }

    @SubscribeEvent
    public static void onWorldCaps(AttachCapabilitiesEvent<World> event) {
        if (OWNER_SHARE_REGISTER != null && !((World)event.getObject()).field_72995_K && ((World)event.getObject()).field_73011_w.getDimension() == 0) {
            event.addCapability(CAP_KEY, (ICapabilityProvider)instance);
        }
    }

    public static void preInit() {
        CapabilityManager.INSTANCE.register(IOwnerShareRegister.class, (Capability.IStorage)new Capability.IStorage<IOwnerShareRegister>(){

            public NBTBase writeNBT(Capability<IOwnerShareRegister> capability, IOwnerShareRegister instanceIn, EnumFacing side) {
                return instanceIn.serializeNBT();
            }

            public void readNBT(Capability<IOwnerShareRegister> capability, IOwnerShareRegister instanceIn, EnumFacing side, NBTBase nbt) {
                instanceIn.deserializeNBT(nbt);
            }
        }, () -> instance);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == OWNER_SHARE_REGISTER;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == OWNER_SHARE_REGISTER ? this : null);
    }

    public NBTBase serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList listPlayers = new NBTTagList();
            entry.getKey().writeToNBT(tag);
            for (Player player : entry.getValue()) {
                listPlayers.func_74742_a((NBTBase)player.writeToNBT(new NBTTagCompound()));
            }
            tag.func_74782_a("share_players", (NBTBase)listPlayers);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("list", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTBase nbtIn) {
        if (nbtIn instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)nbtIn;
            NBTTagList list = nbt.func_150295_c("list", (int)nbt.func_74732_a());
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                Player player = Player.readFromNBT(tag);
                NBTTagList playerTagList = tag.func_150295_c("share_players", (int)tag.func_74732_a());
                ArrayList<Player> sharePlayers = new ArrayList<Player>();
                for (int j = 0; j < playerTagList.func_74745_c(); ++j) {
                    Player tempPlayer = Player.readFromNBT(playerTagList.func_150305_b(j));
                    sharePlayers.add(tempPlayer);
                }
                this.ownerShareMap.put(player, sharePlayers);
            }
        } else {
            OMLib.getLogger().debug("failed to deserialize NBT");
        }
    }

    public HashMap<Player, ArrayList<Player>> getOwnerShareMap() {
        return this.ownerShareMap;
    }

    public void setOwnerShareMap(@Nullable HashMap<Player, ArrayList<Player>> ownerShareMap) {
        if (ownerShareMap != null) {
            this.ownerShareMap = ownerShareMap;
        }
    }

    @Nullable
    public Map.Entry<Player, ArrayList<Player>> getEntryFromName(String name) {
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    private Map.Entry<Player, ArrayList<Player>> getEntry(Player player) {
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().equals(player)) continue;
            return entry;
        }
        return null;
    }

    public void addSharePlayer(Player owner, Player sharePlayer, @Nullable ICommandSender sender) {
        Map.Entry<Player, ArrayList<Player>> entryFound = null;
        if (owner.equals(sharePlayer)) {
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Cannot add yourself to the list!"));
            }
            return;
        }
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().equals(owner)) continue;
            entryFound = entry;
        }
        if (entryFound == null) {
            ArrayList<Player> list = new ArrayList<Player>();
            list.add(sharePlayer);
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Added player " + sharePlayer.getName() + " to your Share List!"));
            }
            this.ownerShareMap.put(owner, list);
        } else if (!((ArrayList)entryFound.getValue()).contains(sharePlayer)) {
            ((ArrayList)entryFound.getValue()).add(sharePlayer);
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Added player " + sharePlayer.getName() + " to your Share List!"));
            }
        } else if (sender != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Error while adding " + sharePlayer.getName() + " to your Share List! Already on list!"));
        }
        OMLibNetworkingHandler.sendMessageToAllPlayers(new MessageSetSharePlayerList(this));
    }

    public void removeSharePlayer(Player owner, Player sharePlayer, @Nullable ICommandSender sender) {
        Map.Entry<Player, ArrayList<Player>> entryFound = null;
        if (owner.equals(sharePlayer)) {
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You cannot add/remove yourself to/from your Share List!"));
            }
            return;
        }
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().equals(owner)) continue;
            entryFound = entry;
        }
        if (entryFound != null) {
            int sizeBefore = ((ArrayList)entryFound.getValue()).size();
            Predicate<Player> predicate = p -> p.equals(sharePlayer);
            entryFound.getValue().removeIf(predicate);
            if (sender != null) {
                if (entryFound.getValue().size() < sizeBefore) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Removed player " + sharePlayer.getName() + " from your Share List!"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Could not remove player " + sharePlayer.getName() + " from your Share List!"));
                }
            }
        } else if (sender != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Could not remove player " + sharePlayer.getName() + " from your Share List!"));
        }
        OMLibNetworkingHandler.sendMessageToAllPlayers(new MessageSetSharePlayerList(this));
    }

    public void printSharePlayers(Player owner, ICommandSender sender) {
        StringBuilder playerList = new StringBuilder();
        Map.Entry<Player, ArrayList<Player>> entryFound = null;
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().equals(owner)) continue;
            entryFound = entry;
        }
        if (entryFound != null) {
            ArrayList list = (ArrayList)entryFound.getValue();
            for (int i = 0; i < list.size(); ++i) {
                Player player = (Player)list.get(i);
                if (i < list.size() - 1) {
                    playerList.append(player.getName());
                    playerList.append(", ");
                    continue;
                }
                playerList.append(player.getName());
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Players on your share list: " + playerList.toString()));
    }

    public boolean isPlayerSharedOwner(Player owner, Player shareCheck) {
        Map.Entry<Player, ArrayList<Player>> entry = this.getEntry(owner);
        if (entry != null) {
            for (Player player : entry.getValue()) {
                if (!player.equals(shareCheck)) continue;
                return true;
            }
        }
        return false;
    }
}

