/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.permission;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.tileentity.TileEntity;
import omtteam.omlib.api.permission.GlobalTrustRegister;
import omtteam.omlib.api.permission.ITrustedPlayersManager;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.handler.OMConfig;
import omtteam.omlib.util.DebugHandler;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;

public class TrustedPlayersManager
implements ITrustedPlayersManager {
    protected List<TrustedPlayer> trustedPlayers = new ArrayList<TrustedPlayer>();
    Player owner;
    boolean useGlobal;
    TileEntity tile;

    public TrustedPlayersManager(Player owner) {
        this.owner = owner;
        this.useGlobal = false;
    }

    public TrustedPlayersManager(Player owner, TileEntity tile) {
        this.owner = owner;
        this.useGlobal = false;
        this.tile = tile;
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    public void setOwner(Player owner) {
        this.owner = owner;
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean addTrustedPlayer(String name) {
        Player player = PlayerUtil.getPlayerFromUsernameCache(name);
        if (player == null && !OMConfig.GENERAL.offlineModeSupport) {
            DebugHandler.getInstance().sendMessageToDebugChat("Did not find player named " + name + "in the username cache.");
            return false;
        }
        if (player == null) {
            DebugHandler.getInstance().sendMessageToDebugChat("Invalid player!");
            return false;
        }
        TrustedPlayer trustedPlayer = new TrustedPlayer(player.getName());
        trustedPlayer.setUuid(player.getUuid());
        if (trustedPlayer.getUuid() != null || OMConfig.GENERAL.offlineModeSupport) {
            for (TrustedPlayer existPlayer : this.trustedPlayers) {
                if (OMConfig.GENERAL.offlineModeSupport) {
                    if (!existPlayer.getName().toLowerCase().equals(name.toLowerCase())) continue;
                    DebugHandler.getInstance().sendMessageToDebugChat("Already on trust list!");
                    return false;
                }
                if (!existPlayer.getName().toLowerCase().equals(name.toLowerCase()) && !trustedPlayer.getUuid().equals(existPlayer.getUuid())) continue;
                return false;
            }
            DebugHandler.getInstance().sendMessageToDebugChat("Sucessfully added " + name + ".");
            this.trustedPlayers.add(trustedPlayer);
            return true;
        }
        return false;
    }

    @Override
    public TrustedPlayer getTrustedPlayer(String name) {
        if (this.useGlobal) {
            return GlobalTrustRegister.instance.getTrustedPlayer(this.owner, name);
        }
        return ITrustedPlayersManager.super.getTrustedPlayer(name);
    }

    @Override
    public TrustedPlayer getTrustedPlayer(UUID uuid) {
        if (this.useGlobal) {
            return GlobalTrustRegister.instance.getTrustedPlayer(this.owner, uuid);
        }
        return ITrustedPlayersManager.super.getTrustedPlayer(uuid);
    }

    @Override
    public TrustedPlayer getTrustedPlayer(Player player) {
        if (this.useGlobal) {
            return GlobalTrustRegister.instance.getTrustedPlayer(this.owner, player);
        }
        return ITrustedPlayersManager.super.getTrustedPlayer(player);
    }

    @Override
    public List<TrustedPlayer> getTrustedPlayers() {
        return this.trustedPlayers;
    }

    @Override
    public void setTrustedPlayers(List<TrustedPlayer> trustedPlayers) {
        this.trustedPlayers = trustedPlayers;
    }

    @Override
    public boolean useGlobal() {
        return this.useGlobal;
    }

    @Override
    public void setUseGlobal(boolean useGlobal) {
        this.useGlobal = useGlobal;
    }

    @Override
    public boolean hasTile() {
        return this.tile != null;
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }
}

