/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.client.gui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import omtteam.omlib.OMLib;
import omtteam.omlib.api.gui.GuiParameters;
import omtteam.omlib.api.gui.IHasTooltips;
import omtteam.omlib.api.gui.ISupportsBackSystem;
import omtteam.omlib.api.network.ISyncableTE;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.tile.IHasTargetingSettings;
import omtteam.omlib.handler.GUIBackSystem;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageCloseGUITile;
import omtteam.omlib.network.messages.MessageOpenGUITile;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.player.PlayerUtil;
import org.lwjgl.opengl.GL11;

public class TargetSettingsGUI
extends GuiScreen
implements IHasTooltips,
ISupportsBackSystem {
    protected final int xSize = 176;
    protected final int ySize = 205;
    private final EntityPlayer player;
    private final IHasTargetingSettings targetHandler;
    private final ISyncableTE syncHandler;
    protected int guiLeft;
    protected int guiTop;
    private int mouseX;
    private int mouseY;
    private boolean addedToSyncList;
    private int accessLevel = 0;

    public TargetSettingsGUI(InventoryPlayer inventoryPlayer, Object input) {
        this.targetHandler = (IHasTargetingSettings)input;
        this.syncHandler = input instanceof ISyncableTE ? (ISyncableTE)input : null;
        this.player = inventoryPlayer.field_70458_d;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void buttonInit() {
        if (PlayerUtil.canPlayerChangeSetting(this.player, (IHasOwner)this.targetHandler)) {
            String mobsButton = GeneralUtil.safeLocalize("gui.omtteam.omlib:attack_mobs") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo(this.targetHandler.getTargetingSettings().isTargetMobs());
            String neutralsButton = GeneralUtil.safeLocalize("gui.omtteam.omlib:attack_neutrals") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo(this.targetHandler.getTargetingSettings().isTargetPassive());
            String playersButton = GeneralUtil.safeLocalize("gui.omtteam.omlib:attack_players") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo(this.targetHandler.getTargetingSettings().isTargetPlayers());
            this.field_146292_n.add(new GuiButton(0, this.guiLeft + 10, this.guiTop + 20, 155, 20, mobsButton));
            this.field_146292_n.add(new GuiButton(1, this.guiLeft + 10, this.guiTop + 40, 155, 20, neutralsButton));
            this.field_146292_n.add(new GuiButton(2, this.guiLeft + 10, this.guiTop + 60, 155, 20, playersButton));
        }
        this.field_146292_n.add(new GuiButton(3, this.guiLeft + 185, this.guiTop + 20, 80, 20, GeneralUtil.safeLocalize("gui.omtteam.omlib:back")));
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        if (!this.addedToSyncList && this.syncHandler != null) {
            OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)new MessageOpenGUITile(this.syncHandler.getTE()));
            this.addedToSyncList = true;
        }
        this.accessLevel = PlayerUtil.getPlayerAccessLevel(this.player, this.targetHandler).ordinal();
        if (this.accessLevel < 2) {
            this.player.func_71053_j();
        }
        this.field_146292_n.clear();
        this.buttonInit();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.mouseX = par1;
        this.mouseY = par2;
        this.func_146276_q_();
        if (this.accessLevel != PlayerUtil.getPlayerAccessLevel(this.player, this.targetHandler).ordinal() && !PlayerUtil.isPlayerOwner(this.player, (IHasOwner)this.targetHandler)) {
            this.accessLevel = PlayerUtil.getPlayerAccessLevel(this.player, this.targetHandler).ordinal();
            if (this.accessLevel != 0) {
                this.func_73866_w_();
            }
        }
        ResourceLocation texture = new ResourceLocation("omlib:textures/gui/targeting_settings.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b((this.field_146294_l - 176) / 2, (this.field_146295_m - 205) / 2, 0, 0, 176, 205);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize("gui.omtteam.omlib:targeting_options") + ": ", this.guiLeft + 10, this.guiTop + 9, 0);
        ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = GeneralUtil.safeLocalize("gui.omtteam.omlib:attack_mobs") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo(this.targetHandler.getTargetingSettings().isTargetMobs());
        ((GuiButton)this.field_146292_n.get((int)1)).field_146126_j = GeneralUtil.safeLocalize("gui.omtteam.omlib:attack_neutrals") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo(this.targetHandler.getTargetingSettings().isTargetPassive());
        ((GuiButton)this.field_146292_n.get((int)2)).field_146126_j = GeneralUtil.safeLocalize("gui.omtteam.omlib:attack_players") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo(this.targetHandler.getTargetingSettings().isTargetPlayers());
        super.func_73863_a(par1, par2, par3);
        this.drawTooltips();
    }

    @ParametersAreNonnullByDefault
    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 0) {
            if (PlayerUtil.canPlayerChangeSetting(this.player, (IHasOwner)this.targetHandler)) {
                this.targetHandler.getTargetingSettings().setTargetMobs(!this.targetHandler.getTargetingSettings().isTargetMobs());
                this.targetHandler.informUpdate();
            } else {
                PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("text.omtteam.omlib:status_permission")));
            }
        }
        if (guibutton.field_146127_k == 1) {
            if (PlayerUtil.canPlayerChangeSetting(this.player, (IHasOwner)this.targetHandler)) {
                this.targetHandler.getTargetingSettings().setTargetPassive(!this.targetHandler.getTargetingSettings().isTargetPassive());
                this.targetHandler.informUpdate();
            } else {
                PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("text.omtteam.omlib:status_permission")));
            }
        }
        if (guibutton.field_146127_k == 2) {
            if (PlayerUtil.canPlayerChangeSetting(this.player, (IHasOwner)this.targetHandler)) {
                this.targetHandler.getTargetingSettings().setTargetPlayers(!this.targetHandler.getTargetingSettings().isTargetPlayers());
                this.targetHandler.informUpdate();
            } else {
                PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("text.omtteam.omlib:status_permission")));
            }
        }
        if (guibutton.field_146127_k == 3) {
            GUIBackSystem.getInstance().openLastGui(this.player);
        }
    }

    @Override
    public void drawTooltips() {
        int k = (this.field_146294_l - this.xSize) / 2;
        int l = (this.field_146295_m - this.ySize) / 2;
        int tooltipToDraw = this.field_146292_n.stream().filter(GuiButton::func_146115_a).mapToInt(s -> s.field_146127_k).sum();
        ArrayList<String> tooltip = new ArrayList<String>();
        switch (tooltipToDraw) {
            case 0: {
                if (!((GuiButton)this.field_146292_n.get(0)).func_146115_a()) break;
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:target_mobs"));
                break;
            }
            case 1: {
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:target_neutrals"));
                break;
            }
            case 2: {
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:target_players"));
                break;
            }
            case 3: {
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:trusted_player_gui"));
                break;
            }
        }
        if (!tooltip.isEmpty()) {
            this.drawHoveringText(tooltip, this.guiLeft + this.mouseX - k, this.guiTop + this.mouseY - l, Minecraft.func_71410_x().field_71466_p);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_146281_b() {
        OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)new MessageCloseGUITile(this.syncHandler.getTE()));
        super.func_146281_b();
    }

    @Override
    @Nullable
    public GuiParameters getGuiParameters() {
        return new GuiParameters(OMLib.instance, 1, this.player.func_130014_f_(), this.syncHandler.getTE().func_174877_v().func_177958_n(), this.syncHandler.getTE().func_174877_v().func_177956_o(), this.syncHandler.getTE().func_174877_v().func_177952_p());
    }
}

