/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import omtteam.omlib.OMLib;
import omtteam.omlib.api.gui.GuiParameters;
import omtteam.omlib.api.gui.IHasTooltips;
import omtteam.omlib.api.gui.ISupportsBackSystem;
import omtteam.omlib.api.gui.StringListBox;
import omtteam.omlib.api.permission.GlobalTrustRegister;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.permission.ITrustedPlayersManager;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.api.permission.TrustedPlayersManager;
import omtteam.omlib.api.tile.IHasTrustManager;
import omtteam.omlib.handler.GUIBackSystem;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageAddTrustedPlayer;
import omtteam.omlib.network.messages.MessageCloseGUITile;
import omtteam.omlib.network.messages.MessageModifyPermissions;
import omtteam.omlib.network.messages.MessageOpenGUITile;
import omtteam.omlib.network.messages.MessageRemoveTrustedPlayer;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;
import org.lwjgl.opengl.GL11;

public class TrustedPlayersGUI
extends GuiScreen
implements IHasTooltips,
ISupportsBackSystem {
    protected final int xSize = 256;
    protected final int ySize = 256;
    private final ITrustedPlayersManager tpm;
    private final EntityPlayer player;
    protected int guiLeft;
    protected int guiTop;
    private GuiTextField textFieldAddTrustedPlayer;
    private int mouseX;
    private int mouseY;
    private int waitForServerTrustedPlayers = -1;
    private boolean addedToSyncList;
    private int accessLevel = 0;
    private boolean isGlobal;
    private List<String> trustedPlayers = new ArrayList<String>();
    private StringListBox listBox;

    public TrustedPlayersGUI(InventoryPlayer inventoryPlayer, IHasTrustManager tile) {
        this.tpm = tile.getTrustManager();
        this.isGlobal = !this.tpm.hasTile();
        this.player = inventoryPlayer.field_70458_d;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        this.getClass();
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.getClass();
        this.guiTop = (this.field_146295_m - 256) / 2;
        if (!this.addedToSyncList) {
            if (this.tpm.hasTile()) {
                OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)new MessageOpenGUITile(this.tpm.getTile()));
            }
            this.addedToSyncList = true;
        }
        this.accessLevel = PlayerUtil.getPlayerAccessLevel(this.player, (IHasTrustManager)this.tpm.getTile()).ordinal();
        if (this.accessLevel < 2) {
            this.player.func_71053_j();
        }
        for (TrustedPlayer trustedPlayer : this.tpm.getTrustedPlayers()) {
            this.trustedPlayers.add(trustedPlayer.getName() + ", " + trustedPlayer.getAccessLevel().getLocalizedName());
        }
        this.field_146292_n.clear();
        this.textFieldAddTrustedPlayer = null;
        this.buttonInit();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.mouseX = par1;
        this.mouseY = par2;
        this.func_146276_q_();
        if (this.accessLevel != PlayerUtil.getPlayerAccessLevel(this.player, (IHasTrustManager)this.tpm.getTile()).ordinal() && !PlayerUtil.isPlayerOwner(this.player, (IHasOwner)((IHasTrustManager)this.tpm.getTile()))) {
            this.accessLevel = PlayerUtil.getPlayerAccessLevel(this.player, (IHasTrustManager)this.tpm.getTile()).ordinal();
        }
        if (!PlayerUtil.isPlayerOwner(this.player, (IHasOwner)((IHasTrustManager)this.tpm.getTile())) && this.accessLevel < 3) {
            this.player.func_71053_j();
        }
        ResourceLocation texture = new ResourceLocation("omlib:textures/gui/trusted_players.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b((this.field_146294_l - 256) / 2, (this.field_146295_m - 256) / 2, 0, 0, 256, 256);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize("gui.omtteam.omlib:add_trusted_player") + ": ", this.guiLeft + 10, this.guiTop + 220, 0);
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize("gui.omtteam.omlib:permissions"), this.guiLeft + 186, this.guiTop + 220, 0);
        super.func_73863_a(par1, par2, par3);
        if (this.textFieldAddTrustedPlayer != null) {
            this.textFieldAddTrustedPlayer.func_146194_f();
        }
        this.drawTooltips();
    }

    @Override
    public void drawTooltips() {
        this.getClass();
        int k = (this.field_146294_l - 256) / 2;
        this.getClass();
        int l = (this.field_146295_m - 256) / 2;
        int tooltipToDraw = this.field_146292_n.stream().filter(GuiButton::func_146115_a).mapToInt(s -> s.field_146127_k).sum();
        if (tooltipToDraw == 0) {
            int n = tooltipToDraw = this.isMouseOverTextField(this.textFieldAddTrustedPlayer, this.mouseX, this.mouseY) ? 25 : 0;
        }
        if (tooltipToDraw == 0 && this.mouseX > this.guiLeft + 95 && this.mouseX < this.guiLeft + 115 && this.mouseY > this.guiTop + 135 && this.mouseY < this.guiTop + 155) {
            tooltipToDraw = 20;
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        switch (tooltipToDraw) {
            case 1: {
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:add_trusted_player"));
                break;
            }
            case 2: {
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:remove_trusted_player"));
                break;
            }
            case 3: {
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:tp_decrease_access"));
                break;
            }
            case 4: {
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:tp_increase_access"));
                break;
            }
            case 20: {
                if (this.listBox.selectedItem >= 0 && this.tpm.getTrustedPlayers().size() > this.listBox.selectedItem) {
                    TrustedPlayer trustedPlayer = this.tpm.getTrustedPlayers().get(this.listBox.selectedItem);
                    if (trustedPlayer != null) {
                        switch (trustedPlayer.getAccessLevel()) {
                            case ADMIN: {
                                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:tp_can_administer"));
                                break;
                            }
                            case CHANGE_SETTINGS: {
                                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:tp_can_change_settings"));
                                break;
                            }
                            case OPEN_GUI: {
                                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:tp_can_open_gui"));
                                break;
                            }
                            case NONE: {
                                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:tp_none"));
                            }
                        }
                    }
                    break;
                }
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:info_access_level"));
                break;
            }
            case 25: {
                tooltip.add(GeneralUtil.safeLocalize("tooltip.omtteam.omlib:tp_text_field"));
            }
        }
        if (!tooltip.isEmpty()) {
            this.drawHoveringText(tooltip, this.guiLeft + this.mouseX - k, this.guiTop + this.mouseY - l, Minecraft.func_71410_x().field_71466_p);
        }
    }

    protected void buttonInit() {
        if (PlayerUtil.isPlayerAdmin(this.player, (IHasOwner)((IHasTrustManager)this.tpm.getTile()))) {
            this.textFieldAddTrustedPlayer = new GuiTextField(0, Minecraft.func_71410_x().field_71466_p, this.guiLeft + 11, this.guiTop + 231, 100, 18);
            this.listBox = new StringListBox(5, this.guiLeft + 5, this.guiTop + 5, 246, 212, this.trustedPlayers);
            this.field_146292_n.add(new GuiButton(1, this.guiLeft + 114, this.guiTop + 230, 33, 20, "+"));
            this.field_146292_n.add(new GuiButton(2, this.guiLeft + 148, this.guiTop + 230, 33, 20, "-"));
            this.field_146292_n.add(new GuiButton(3, this.guiLeft + 185, this.guiTop + 230, 23, 20, "-"));
            this.field_146292_n.add(new GuiButton(4, this.guiLeft + 226, this.guiTop + 230, 23, 20, "+"));
            this.field_146292_n.add(new GuiButton(6, this.guiLeft + 261, this.guiTop + 10, 80, 20, GeneralUtil.safeLocalize("gui.omtteam.omlib:back")));
            this.field_146292_n.add(this.listBox);
        }
    }

    public void updateList() {
        this.trustedPlayers.clear();
        for (TrustedPlayer trustedPlayer : this.tpm.getTrustedPlayers()) {
            this.trustedPlayers.add(trustedPlayer.getName() + ", " + trustedPlayer.getAccessLevel().getLocalizedName());
        }
        if (this.listBox != null) {
            this.listBox.updateList(this.trustedPlayers);
        }
    }

    public void func_73876_c() {
        Map.Entry<Player, TrustedPlayersManager> entry;
        super.func_73876_c();
        if (this.waitForServerTrustedPlayers >= 0 && this.tpm.getTrustedPlayers().size() > 0) {
            this.waitForServerTrustedPlayers = -1;
        } else if (this.waitForServerTrustedPlayers >= 0) {
            --this.waitForServerTrustedPlayers;
        }
        this.updateList();
        if (this.isGlobal && (entry = GlobalTrustRegister.instance.getEntryFromName(this.tpm.getOwner().getName())) != null) {
            this.tpm.setTrustedPlayers(entry.getValue().getTrustedPlayers());
        }
    }

    public void func_73864_a(int i, int j, int k) {
        if (this.isMouseOverTextField(this.textFieldAddTrustedPlayer, i, j)) {
            if (this.textFieldAddTrustedPlayer.func_146206_l()) {
                this.textFieldAddTrustedPlayer.func_146192_a(i, j, k);
            } else {
                this.textFieldAddTrustedPlayer.func_146195_b(true);
            }
        } else {
            try {
                super.func_73864_a(i, j, k);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.textFieldAddTrustedPlayer == null || !this.textFieldAddTrustedPlayer.func_146206_l()) {
            try {
                super.func_73869_a(typedChar, keyCode);
            }
            catch (IOException iOException) {}
        } else if (this.textFieldAddTrustedPlayer != null) {
            if (typedChar != '\u001b') {
                this.textFieldAddTrustedPlayer.func_146201_a(typedChar, keyCode);
            } else {
                this.textFieldAddTrustedPlayer.func_146195_b(false);
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 1) {
            if (PlayerUtil.isPlayerAdmin(this.player, (IHasOwner)((IHasTrustManager)this.tpm.getTile()))) {
                if (!this.textFieldAddTrustedPlayer.func_146179_b().equals("") || !this.textFieldAddTrustedPlayer.func_146179_b().isEmpty()) {
                    this.sendChangeToServerAddTrusted();
                    this.textFieldAddTrustedPlayer.func_146180_a("");
                    this.waitForServerTrustedPlayers = 20;
                }
            } else {
                PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("status.ownership")));
            }
        }
        if (guibutton.field_146127_k == 2) {
            if (this.tpm.getTrustedPlayers().size() < this.listBox.selectedItem) {
                return;
            }
            if (this.tpm.getTrustedPlayers().size() > 0) {
                if (this.tpm.getTrustedPlayers().get(this.listBox.selectedItem) != null && PlayerUtil.isPlayerAdmin(this.player, (IHasOwner)((IHasTrustManager)this.tpm.getTile()))) {
                    this.sendChangeToServerRemoveTrusted();
                    this.tpm.removeTrustedPlayer(this.tpm.getTrustedPlayers().get(this.listBox.selectedItem).getName());
                    if (!this.player.func_110124_au().equals(this.tpm.getOwner().getUuid()) && (this.tpm.getTrustedPlayers().size() == 0 || PlayerUtil.isPlayerAdmin(this.player, (IHasOwner)((IHasTrustManager)this.tpm.getTile())))) {
                        this.field_146297_k.func_147108_a(null);
                        return;
                    }
                    this.func_73866_w_();
                } else {
                    PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("status.ownership")));
                }
            }
        }
        if (guibutton.field_146127_k == 3) {
            if (this.tpm.getTrustedPlayers().size() < this.listBox.selectedItem) {
                return;
            }
            if (this.tpm.getTrustedPlayers().size() > 0) {
                if (PlayerUtil.isPlayerAdmin(this.player, (IHasOwner)((IHasTrustManager)this.tpm.getTile())) && this.tpm.getTrustedPlayers().get(this.listBox.selectedItem) != null) {
                    this.sendChangeToServerModifyPermissions(this.tpm.getTrustedPlayers().get(this.listBox.selectedItem).getName(), -1);
                } else {
                    PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("status.ownership")));
                }
            }
        }
        if (guibutton.field_146127_k == 4) {
            if (this.tpm.getTrustedPlayers().size() < this.listBox.selectedItem) {
                return;
            }
            if (this.tpm.getTrustedPlayers().size() > 0) {
                if (PlayerUtil.isPlayerAdmin(this.player, (IHasOwner)((IHasTrustManager)this.tpm.getTile())) && this.tpm.getTrustedPlayers().get(this.listBox.selectedItem) != null) {
                    this.sendChangeToServerModifyPermissions(this.tpm.getTrustedPlayers().get(this.listBox.selectedItem).getName(), 1);
                } else {
                    PlayerUtil.addChatMessage((ICommandSender)this.player, (ITextComponent)new TextComponentString(GeneralUtil.safeLocalize("status.ownership")));
                }
            }
        }
        if (guibutton.field_146127_k == 6) {
            GUIBackSystem.getInstance().openLastGui(this.player);
        }
    }

    private void sendChangeToServerAddTrusted() {
        MessageAddTrustedPlayer message = new MessageAddTrustedPlayer(this.textFieldAddTrustedPlayer.func_146179_b(), this.tpm.getTile(), this.isGlobal, this.tpm.getOwner());
        OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendChangeToServerRemoveTrusted() {
        MessageRemoveTrustedPlayer message = new MessageRemoveTrustedPlayer(this.tpm.getTrustedPlayers().get(this.listBox.selectedItem).getName(), this.tpm.getTile(), this.isGlobal, this.tpm.getOwner());
        OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendChangeToServerModifyPermissions(String player, Integer change) {
        MessageModifyPermissions message = new MessageModifyPermissions(player, this.tpm.getTile(), this.isGlobal, this.tpm.getOwner(), change);
        OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    public void func_146281_b() {
        if (!this.isGlobal) {
            OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)new MessageCloseGUITile(this.tpm.getTile()));
        }
        super.func_146281_b();
    }

    @Override
    @Nullable
    public GuiParameters getGuiParameters() {
        if (this.tpm.hasTile()) {
            return new GuiParameters(OMLib.instance, 0, this.player.func_130014_f_(), this.tpm.getTile().func_174877_v().func_177958_n(), this.tpm.getTile().func_174877_v().func_177956_o(), this.tpm.getTile().func_174877_v().func_177952_p());
        }
        return null;
    }
}

