/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.network.messages.render;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import omtteam.omlib.proxy.ClientProxy;
import omtteam.omlib.util.RandomUtil;

public class MessageSpawnParticleQuad
implements IMessage {
    private double x;
    private double y;
    private double z;
    private double xRange;
    private double yRange;
    private double zRange;
    private double speedFactor;
    private int amount;
    private int id;
    private int dimensionId;

    public MessageSpawnParticleQuad() {
    }

    public MessageSpawnParticleQuad(int id, int dimensionId, double x, double y, double z, double xRange, double yRange, double zRange, double speedFactor, int amount) {
        this.id = id;
        this.dimensionId = dimensionId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xRange = xRange;
        this.yRange = yRange;
        this.zRange = zRange;
        this.speedFactor = speedFactor;
        this.amount = amount;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.dimensionId = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.xRange = buf.readDouble();
        this.yRange = buf.readDouble();
        this.zRange = buf.readDouble();
        this.speedFactor = buf.readDouble();
        this.amount = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.dimensionId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.xRange);
        buf.writeDouble(this.yRange);
        buf.writeDouble(this.zRange);
        buf.writeDouble(this.speedFactor);
        buf.writeInt(this.amount);
    }

    public static class MessageHandlerSpawnParticleQuad
    implements IMessageHandler<MessageSpawnParticleQuad, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageSpawnParticleQuad messageIn, MessageContext ctx) {
            MessageSpawnParticleQuad message = messageIn;
            Minecraft.func_71410_x().func_152344_a(() -> {
                World world = ClientProxy.getWorld(FMLClientHandler.instance().getClient());
                if (world.field_73011_w.getDimension() != message.dimensionId) {
                    return;
                }
                for (int i = 0; i <= message.amount; ++i) {
                    try {
                        world.func_175688_a(Objects.requireNonNull(EnumParticleTypes.func_179342_a((int)message.id)), message.x + (RandomUtil.random.nextDouble() - 0.5) * message.xRange, message.y + (RandomUtil.random.nextDouble() - 0.5) * message.yRange, message.z + (RandomUtil.random.nextDouble() - 0.5) * message.zRange, (RandomUtil.random.nextDouble() - 0.5) * message.speedFactor, (RandomUtil.random.nextDouble() - 0.5) * message.speedFactor, (RandomUtil.random.nextDouble() - 0.5) * message.speedFactor, new int[0]);
                        continue;
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            });
            return null;
        }
    }
}

