/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.util;

import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TargetingSettings {
    private boolean targetPlayers;
    private boolean targetMobs;
    private boolean targetPassive;
    private int range;
    private int maxRange;

    private TargetingSettings() {
    }

    public TargetingSettings(boolean targetPlayers, boolean targetMobs, boolean targetPassive, int range, int maxRange) {
        this.targetPlayers = targetPlayers;
        this.targetMobs = targetMobs;
        this.targetPassive = targetPassive;
        this.range = range;
        this.maxRange = maxRange;
    }

    public static TargetingSettings readFromNBT(NBTTagCompound nbtTagCompound) {
        TargetingSettings settings = new TargetingSettings();
        if (nbtTagCompound.func_74764_b("targetingSettings")) {
            NBTTagCompound nbt = nbtTagCompound.func_74775_l("targetingSettings");
            settings.targetPlayers = nbt.func_74767_n("targetPlayers");
            settings.targetMobs = nbt.func_74767_n("targetMobs");
            settings.targetPassive = nbt.func_74767_n("targetPassive");
            settings.range = nbt.func_74762_e("range");
            settings.maxRange = nbt.func_74762_e("maxRange");
        } else {
            settings.targetPlayers = nbtTagCompound.func_74767_n("attacksPlayers");
            settings.targetMobs = nbtTagCompound.func_74767_n("attacksMobs");
            settings.targetPassive = nbtTagCompound.func_74767_n("attacksNeutrals");
            settings.range = nbtTagCompound.func_74762_e("currentMaxRange");
            settings.maxRange = nbtTagCompound.func_74762_e("upperBoundMaxRange");
        }
        return settings;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("targetPlayers", this.targetPlayers);
        nbt.func_74757_a("targetMobs", this.targetMobs);
        nbt.func_74757_a("targetPassive", this.targetPassive);
        nbt.func_74768_a("range", this.range);
        nbt.func_74768_a("maxRange", this.maxRange);
        nbtTagCompound.func_74782_a("targetingSettings", (NBTBase)nbt);
        return nbtTagCompound;
    }

    public boolean isTargetPlayers() {
        return this.targetPlayers;
    }

    public TargetingSettings setTargetPlayers(boolean targetPlayers) {
        this.targetPlayers = targetPlayers;
        return this;
    }

    public boolean isTargetMobs() {
        return this.targetMobs;
    }

    public TargetingSettings setTargetMobs(boolean targetMobs) {
        this.targetMobs = targetMobs;
        return this;
    }

    public boolean isTargetPassive() {
        return this.targetPassive;
    }

    public TargetingSettings setTargetPassive(boolean targetPassive) {
        this.targetPassive = targetPassive;
        return this;
    }

    public int getRange() {
        return this.range;
    }

    public TargetingSettings setRange(int range) {
        if (range <= this.maxRange && range > -1) {
            this.range = range;
        }
        return this;
    }

    public int getMaxRange() {
        return this.maxRange;
    }

    public TargetingSettings setMaxRange(int maxRange) {
        this.maxRange = maxRange;
        if (this.maxRange < this.range) {
            this.range = this.maxRange;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetingSettings that = (TargetingSettings)o;
        return this.targetPlayers == that.targetPlayers && this.targetMobs == that.targetMobs && this.targetPassive == that.targetPassive && this.range == that.range && this.maxRange == that.range;
    }

    public int hashCode() {
        return Objects.hash(this.targetPlayers, this.targetMobs, this.targetPassive, this.range, this.maxRange);
    }
}

