/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs;

import fathertoast.specialmobs.SpecialMobsMod;
import fathertoast.specialmobs.bestiary.EnumMobFamily;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SpecialMobReplacer {
    private static final String TAG_INIT = "SpecialMobsInit";
    private final Deque<MobReplacementEntry> toBeReplaced = new ArrayDeque<MobReplacementEntry>();

    private static boolean getInitFlag(Entity entity) {
        NBTTagCompound forgeData = entity.getEntityData();
        if (forgeData.func_150297_b(TAG_INIT, 99)) {
            return forgeData.func_74767_n(TAG_INIT);
        }
        return false;
    }

    private static void setInitFlag(Entity entity) {
        NBTTagCompound forgeData = entity.getEntityData();
        forgeData.func_74757_a(TAG_INIT, true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        EnumMobFamily mobFamily = this.getReplacingMobFamily(entity);
        if (mobFamily != null) {
            BlockPos entityPos;
            World world = event.getWorld();
            boolean isSpecial = this.shouldMakeNextSpecial(mobFamily, world, entityPos = new BlockPos(entity));
            if (this.shouldReplace(mobFamily, isSpecial)) {
                this.toBeReplaced.addLast(new MobReplacementEntry(mobFamily, isSpecial, entity, world, entityPos));
                event.setCanceled(true);
            } else {
                SpecialMobReplacer.setInitFlag(entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (!this.toBeReplaced.isEmpty()) {
                MobReplacementEntry replacement = this.toBeReplaced.removeFirst();
                this.replace(replacement.mobFamily, replacement.isSpecial, (Entity)replacement.entityToReplace, replacement.entityWorld, replacement.entityPos);
            }
        }
    }

    private EnumMobFamily getReplacingMobFamily(Entity entity) {
        EnumMobFamily mobFamily = EnumMobFamily.CLASS_TO_FAMILY_MAP.get(entity.getClass());
        if (mobFamily != null && !mobFamily.config.REPLACE_VANILLA && SpecialMobReplacer.getInitFlag(entity)) {
            return null;
        }
        return mobFamily;
    }

    private boolean shouldMakeNextSpecial(EnumMobFamily mobFamily, World world, BlockPos entityPos) {
        return world.field_73012_v.nextFloat() < mobFamily.config.getSpecialChance(world, entityPos);
    }

    private boolean shouldReplace(EnumMobFamily mobFamily, boolean isSpecial) {
        return isSpecial || mobFamily.config.REPLACE_VANILLA;
    }

    private void replace(EnumMobFamily mobFamily, boolean isSpecial, Entity entityToReplace, World world, BlockPos entityPos) {
        EntityLiving replacement;
        NBTTagCompound tag = new NBTTagCompound();
        entityToReplace.func_189511_e(tag);
        EnumMobFamily.Species variant = isSpecial ? mobFamily.nextVariant(world, entityPos) : mobFamily.vanillaReplacement;
        try {
            replacement = variant.constructor.newInstance(world);
        }
        catch (Exception ex) {
            SpecialMobsMod.log().error("Encountered an exception while constructing entity '{}'", (Object)("specialmobs:" + variant.unlocalizedName));
            return;
        }
        replacement.func_70020_e(tag);
        replacement.func_180482_a(world.func_175649_E(entityPos), null);
        for (Entity rider : entityToReplace.func_184188_bt()) {
            rider.func_184205_a((Entity)replacement, true);
        }
        if (entityToReplace.func_184218_aH()) {
            replacement.func_184205_a(entityToReplace.func_184187_bx(), true);
        }
        world.func_72838_d((Entity)replacement);
    }

    private static class MobReplacementEntry {
        final EnumMobFamily mobFamily;
        final boolean isSpecial;
        final EntityLiving entityToReplace;
        final World entityWorld;
        final BlockPos entityPos;

        MobReplacementEntry(EnumMobFamily family, boolean special, Entity entity, World world, BlockPos pos) {
            this.mobFamily = family;
            this.isSpecial = special;
            this.entityToReplace = (EntityLiving)entity;
            this.entityWorld = world;
            this.entityPos = pos;
        }
    }
}

