/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs;

import fathertoast.specialmobs.MessageTexture;
import fathertoast.specialmobs.SidedModProxy;
import fathertoast.specialmobs.SpecialMobReplacer;
import fathertoast.specialmobs.ai.IAngler;
import fathertoast.specialmobs.bestiary.EnumMobFamily;
import fathertoast.specialmobs.config.Config;
import fathertoast.specialmobs.entity.projectile.EntitySpecialFishHook;
import fathertoast.specialmobs.loot.LootTableHelper;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="specialmobs", name="Special Mobs", version="1.0.2_for_mc1.12.2", acceptedMinecraftVersions="[1.12.2]")
public class SpecialMobsMod {
    public static final String MOD_ID = "specialmobs";
    public static final String NAME = "Special Mobs";
    public static final String VERSION = "1.0.2_for_mc1.12.2";
    @SidedProxy(modId="specialmobs", clientSide="fathertoast.specialmobs.client.ClientProxy", serverSide="fathertoast.specialmobs.server.ServerProxy")
    public static SidedModProxy sidedProxy;
    public static final String NAMESPACE = "specialmobs:";
    public static final String TEXTURE_PATH = "specialmobs:textures/entity/";
    public static final String LOOT_TABLE_PATH = "specialmobs:entities/";
    private static Logger logger;
    private static SimpleNetworkWrapper networkWrapper;

    public static Logger log() {
        return logger;
    }

    public static SimpleNetworkWrapper network() {
        return networkWrapper;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Config.load(SpecialMobsMod.log(), "Special_Mobs", event.getModConfigurationDirectory());
        boolean isInDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        if (isInDev) {
            LootTableHelper.generateBaseLootTables(event.getModConfigurationDirectory());
        }
        int id = -1;
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("SM|FX");
        if (event.getSide() == Side.CLIENT) {
            SpecialMobsMod.network().registerMessage(MessageTexture.Handler.class, MessageTexture.class, ++id, Side.CLIENT);
        }
        sidedProxy.registerRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (Config.get().GENERAL.FANCY_FISHING_MOBS) {
            ResourceLocation key = new ResourceLocation("cast");
            SpecialMobsMod.log().debug("Overwriting vanilla property getter! (Ignore duplicate key '{}' message below)", (Object)key);
            Items.field_151112_aM.func_185043_a(key, (IItemPropertyGetter)new IAngler.ItemFishingRodPropertyGetter());
        }
        SpecialMobsMod.log().info("Registering entities...");
        long startTime = System.nanoTime();
        this.registerEntities();
        long estimatedTime = System.nanoTime() - startTime;
        SpecialMobsMod.log().info("Registered entities in {} ms", (Object)((double)estimatedTime / 1000000.0));
        if (Config.get().GENERAL.SPAWNING) {
            MinecraftForge.EVENT_BUS.register((Object)new SpecialMobReplacer());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private void registerEntities() {
        int registered = 0;
        int id = -1;
        for (EnumMobFamily family : EnumMobFamily.values()) {
            for (Class replaceableClass : family.replaceableClasses) {
                EnumMobFamily.CLASS_TO_FAMILY_MAP.put(replaceableClass, family);
            }
            this.registerVanillaReplacement(++id, family);
            for (EnumMobFamily.Species variant : family.variants) {
                this.registerSpecialVariant(++id, variant);
                ++registered;
            }
        }
        SpecialMobsMod.log().info("Registered {} special variants!", (Object)registered);
        this.registerEntity(++id, "SMFishHook", EntitySpecialFishHook.class, 64, 10, true);
    }

    private void registerVanillaReplacement(int id, EnumMobFamily family) {
        this.registerEntity(id, family.vanillaReplacement.unlocalizedName, family.vanillaReplacement.variantClass);
    }

    private void registerSpecialVariant(int id, EnumMobFamily.Species variant) {
        this.registerEntity(id, variant.unlocalizedName, variant.variantClass);
        ResourceLocation lootTable = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(LOOT_TABLE_PATH + variant.family.name.toLowerCase() + "/" + variant.name.toLowerCase()));
        try {
            variant.variantClass.getField("LOOT_TABLE").set(null, lootTable);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new RuntimeException("Special variant class for " + variant.unlocalizedName + " has no valid 'LOOT_TABLE' field", ex);
        }
        if (Config.get().GENERAL.SPAWN_EGGS) {
            EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation(NAMESPACE + variant.unlocalizedName), (int)variant.family.eggBaseColor, (int)variant.bestiaryInfo.eggSpotsColor);
        }
    }

    private void registerEntity(int id, String unlocalizedName, Class<? extends Entity> entityClass) {
        this.registerEntity(id, unlocalizedName, entityClass, 80, 3, true);
    }

    private void registerEntity(int id, String unlocalizedName, Class<? extends Entity> entityClass, int trackingRange, int trackingFrequency, boolean trackVelocity) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(NAMESPACE + unlocalizedName), entityClass, (String)unlocalizedName, (int)id, (Object)this, (int)trackingRange, (int)trackingFrequency, (boolean)trackVelocity);
    }
}

